unit Rtsqlreg;

interface

uses
   Classes, SysUtils, DB, DsgnIntf;

procedure Register;

implementation

uses
   RTDBSql, RTSqlEd;

{ TDBStringProperty }
type
	TDBStringProperty = class(TStringProperty)
	public
		function GetAttributes: TPropertyAttributes; override;
		procedure GetValueList(List: TStrings); virtual; abstract;
		procedure GetValues(Proc: TGetStrProc); override;
	end;

function TDBStringProperty.GetAttributes: TPropertyAttributes;
begin
	Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TDBStringProperty.GetValues(Proc: TGetStrProc);
var
	I: Integer;
	Values: TStringList;
begin
	Values := TStringList.Create;
	try
		GetValueList(Values);
		for I := 0 to Values.Count - 1 do Proc(Values[I]);
	finally
		Values.Free;
	end;
end;

{ TDatabaseNameProperty }
type
	TDatabaseNameProperty = class(TDBStringProperty)
	public
		procedure GetValueList(List: TStrings); override;
	end;

procedure TDatabaseNameProperty.GetValueList(List: TStrings);
begin
	Session.GetDatabaseNames(List);
end;

procedure Register;
begin
   RegisterComponents('RiT',[TRTSQLStatements]);
	RegisterPropertyEditor(TypeInfo(TFileName),TRtSQLStatements,'DatabaseName',TDatabaseNameProperty);
	RegisterPropertyEditor(TypeInfo(TFileName),TRtSQLStatements,'DatabaseName',TDatabaseNameProperty);
   RegisterComponentEditor(TRtSQLStatements,TRtSQLStatementsEditor);
end;

end.
