unit Test1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, RtDbSql, StdCtrls, Gauges, ExtCtrls, DB, DBTables;

type
  TForm1 = class(TForm)
    Sql: TRtSQLStatements;
    Memo1: TMemo;
    Label1: TLabel;
    Button1: TButton;
    Panel1: TPanel;
    Gauge1: TGauge;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure SqlError(Sender: TObject; E: Exception;
      var Action: TRtSQLAbortType);
    procedure SqlCallback(Sender: TObject; Data: Longint);
    procedure SqlAfterStatement(Sender: TObject; Data: Longint);
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SqlGetParams(Sender: TObject; Statement: TRtSQLStatement;
      Params: TParams);
    procedure SqlAfterExec(Sender: TObject);
  private
    { Private declarations }
    C1,C2,C3: integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
   Test2;

procedure TForm1.Button1Click(Sender: TObject);
begin
   Sql.LoadFromStrings(Memo1.Lines);
   Gauge1.MinValue := 0;
   Gauge1.MaxValue := Sql.Count-1;
   Sql.Execute([nil]);
end;

procedure TForm1.SqlError(Sender: TObject; E: Exception;
  var Action: TRtSQLAbortType);
begin
   if MessageDlg('Error: '+E.Message+#13'Cancel execution?',mtError,[mbYes,mbNo],0)=mrYes then
      Action := atRollback;
end;

procedure TForm1.SqlCallback(Sender: TObject; Data: Longint);
begin
   Gauge1.Progress := Sql.Index;
   if Data>0 then
      Label2.Caption := Format('%d%%',[Data])
   else
      Label2.Caption := Sql.Status;
   Label2.Update;
end;

procedure TForm1.SqlAfterStatement(Sender: TObject; Data: Longint);
begin
   if Sql.Statements[Data].AsQuery<>nil then
   begin
      Form2 := TForm2.Create(Application);
      Form2.DataSet := TQuery(Sql.Statements[Data].GetObject);
      Form2.Show;
   end
   else if Sql.Statements[Data].AsBatchMove<>nil then
   begin
      Form2 := TForm2.Create(Application);
      Form2.DataSet := TDBDataSet(Sql.Statements[Data].AsBatchMove.Destination);
      Sql.Statements[Data].AsBatchMove.Destination := nil;
      Form2.Show;
   end;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
   Button1.Left := ClientWidth-C1;
   Panel1.Width := Button1.Left+Button1.Width-Panel1.Left;
   Panel1.Top := ClientHeight-C2;
   Memo1.Width := Button1.Left+Button1.Width-Memo1.Left;
   Memo1.Height := Panel1.Top-Memo1.Top-C3;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   C1 := ClientWidth-Button1.Left;
   C2 := ClientHeight-Panel1.Top;
   C3 := Panel1.Top-Memo1.Height-Memo1.Top;
end;

procedure TForm1.SqlGetParams(Sender: TObject; Statement: TRtSQLStatement;
  Params: TParams);
begin
   Params[0].AsFloat := StrToFloat(InputBox('Set Rutime Parameters','Customer No','1351'));
end;

procedure TForm1.SqlAfterExec(Sender: TObject);
begin
   Gauge1.Progress := Gauge1.MaxValue;
end;

end.
