unit Testuni1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, StdCtrls, ExtCtrls, Buttons,
  RtDbCopy, Grids, DBGrids, Gauges;

type
  TForm1 = class(TForm)
    Database1: TDatabase;
    Table1: TTable;
    Table2: TTable;
    Panel1: TPanel;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Edit1: TEdit;
    Label2: TLabel;
    BitBtn1: TBitBtn;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    StringGrid1: TStringGrid;
    BitBtn2: TBitBtn;
    RtDbCopy1: TRtDbCopy;
    Gauge1: TGauge;
    procedure FormCreate(Sender: TObject);
    procedure RtDbCopy1Copy(Sender: TObject; Value: Integer;
      var Cancel,Handled: Boolean);
    procedure BitBtn1Click(Sender: TObject);
    procedure ComboBox1Exit(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure RtDbCopy1Error(Sender: TObject; E: Exception;
      var Cancel: Boolean);
    procedure RtDbCopy1Field(Sender: TObject; FieldNo: word; DataType: TFieldType;
      Data: Pointer; var IsBlank: Boolean);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

uses
   Login, Rt, TypInfo;

{$R *.DFM}

function SqlLogin(Database: TDatabase; AliasName,UserName,Password: string): Boolean;
begin
   if Database.Connected then
      Database.Close;
   Database.AliasName := AliasName;
   Database.Params.Values['USER NAME'] := UserName;
   Database.Params.Values['PASSWORD'] := Password;
   Database.Open;
   Result := Database.Connected;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
	List: TStringList;
begin
   if not Database1.Connected then
   begin
      LoginForm := TLoginForm.Create(Application);
      try
         if LoginForm.ShowModal=idOK then
            try
               SqlLogin(Database1,LoginForm.Alias,LoginForm.User,LoginForm.Password);
            except
               if (not Database1.Connected) then
                  raise EDatabaseError.Create('Login fehlgeschlagen !');
            end;
      finally
         LoginForm.Release;
      end;
   end;
   if Database1.Connected then
   begin
   	List := TStringList.Create;
   	Session.GetTableNames(Database1.DatabaseName,'',True,False,List);
      ComboBox1.Items.Assign(List);
      List.Free;
   end;
end;

procedure TForm1.RtDbCopy1Copy(Sender: TObject; Value: Integer;
  var Cancel,Handled: Boolean);
begin
	Case Value of
	   0:	begin
		   	Gauge1.MinValue := 0;
		      Gauge1.MaxValue := Table1.RecordCount;
		      Gauge1.Progress := 0;
		      Gauge1.Visible := True;
         end;
   else
    	Gauge1.AddProgress(1);
   end;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var
	n: integer;
   Mapping: string;
begin
   StringGrid1.Visible := False;
   Gauge1.Visible := False;
   if Table2.Active then
   	Table2.Close;
	Table2.TableName := Edit1.Text;
   RtDbCopy1.Mappings.Clear;
   for n:=1 to StringGrid1.RowCount-1 do
   begin
   	if Pos('STRING',UpperCase(StringGrid1.Cells[3,n]))>0 then
      	Mapping := '*'
      else
      	Mapping := '';
      Mapping := Mapping+StringGrid1.Cells[2,n]+':'+StringGrid1.Cells[3,n]+'='+StringGrid1.Cells[0,n];
      RtDbCopy1.Mappings.Add(Mapping);
   end;
   try
	   RtDbCopy1.Execute;
	   Gauge1.Visible := False;
   	Table2.Open;
	   DbGrid1.Visible := True;
   finally
   	if not DbGrid1.Visible then
         StringGrid1.Visible := True;
   end;
end;

procedure TForm1.ComboBox1Exit(Sender: TObject);
var
	n: integer;
begin
	if Table1.TableName=ComboBox1.Text then
   	exit;
	DbGrid1.Visible := False;
	StringGrid1.Visible := True;
	if Table1.Active then
   	Table1.Close;
	Table1.TableName := ComboBox1.Text;
	Table1.Open;
   StringGrid1.ColCount := 4;
   StringGrid1.RowCount := Table1.FieldCount+1;
   for n:=0 to Table1.FieldCount-1 do
   begin
      StringGrid1.Cells[0,n+1] := Table1.Fields[n].FieldName;
      StringGrid1.Cells[2,n+1] := Table1.Fields[n].FieldName;
      {$IFDEF WIN32}
      StringGrid1.Cells[1,n+1] := GetEnumName(TypeInfo(TFieldType),integer(Table1.Fields[n].DataType));
      {$ELSE}
      StringGrid1.Cells[1,n+1] := GetEnumName(TypeInfo(TFieldType),integer(Table1.Fields[n].DataType))^;
      {$ENDIF}
      StringGrid1.Cells[3,n+1] := StringGrid1.Cells[1,n+1];
   end;
   StringGrid1.Cells[0,0] := 'Source Field Names';
   StringGrid1.Cells[1,0] := 'Source Data Type';
   StringGrid1.Cells[2,0] := 'Destination Field Names';
   StringGrid1.Cells[3,0] := 'Destination Data Type';
   StringGrid1.Visible := True;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
	Close;
end;

procedure TForm1.RtDbCopy1Error(Sender: TObject; E: Exception;
  var Cancel: Boolean);
begin
	if MessageDlg('Error copying file: '+Table1.TableName+' in record#: '+IntToStr((Sender as TRtDbCopy).CopyNo)+
                 #13#10+E.Message,mtError,mbOkCancel,0)=mrOk then
      Cancel := False;
end;

procedure TForm1.RtDbCopy1Field(Sender: TObject; FieldNo: word; DataType: TFieldType;
  Data: Pointer; var IsBlank: Boolean);
begin
	if not IsBlank then
		case DataType of
	   	ftString: StrUpper(Data);
	   end;
end;

end.
