unit Testuni2;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, RtDbCopy, DBTables, DB, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Label2: TLabel;
    Edit1: TEdit;
    Database1: TDatabase;
    Table1: TTable;
    Table2: TTable;
    BatchMove1: TBatchMove;
    RtDbCopy1: TRtDbCopy;
    Button1: TButton;
    Button2: TButton;
    Label3: TLabel;
    Label4: TLabel;
    Bevel1: TBevel;
    Label7: TLabel;
    Label8: TLabel;
    CheckBox1: TCheckBox;
    RadioGroup1: TRadioGroup;
    procedure ComboBox1Change(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

uses
	Login;

{$R *.DFM}

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
	if Table1.Active then
   	Table1.Close;
{   Table1.TableName := ComboBox1.Items[ComboBox1.ItemIndex];}
   Table1.TableName := ComboBox1.Text
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
	if Table2.Active then
   	Table2.Close;
   Table2.TableName := Edit1.Text;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
	T: TDateTime;
   n: integer;
begin
	Button1.Enabled := False;
   try
   	Table1.Open;
      BatchMove1.Mappings.Clear;
      if CheckBox1.Checked then
      	for n:=Table1.FieldDefs.Count-1 downto 0 do
         	if (n mod 2)=0 then
   	      	BatchMove1.Mappings.Add(Table1.FieldDefs[n].Name+'='+Table1.FieldDefs[n].Name);
	   Label8.Caption := IntToStr(Table1.RecordCount);
      BatchMove1.Mode := TBatchMode(RadioGroup1.ItemIndex);
	   Label3.Caption := '00:00:00';
	   T := Time;
	   BatchMove1.Execute;
	   Label3.Caption := FormatDateTime('hh:nn:ss',Time-T);
   finally
   	Button1.Enabled := True;
   end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
	T: TDateTime;
   n: integer;
begin
	Button2.Enabled := False;
   try
   	Table1.Open;
      RtDbCopy1.Mappings.Clear;
      if CheckBox1.Checked then
      	for n:=Table1.FieldDefs.Count-1 downto 0 do
         	if (n mod 2)=0 then
	         	RtDbCopy1.Mappings.Add(Table1.FieldDefs[n].Name+'='+Table1.FieldDefs[n].Name);
	   Label8.Caption := IntToStr(Table1.RecordCount);
      RtDbCopy1.Mode := TRtCopyMode(RadioGroup1.ItemIndex);
	   Label4.Caption := '00:00:00';
	   T := Time;
	   RtDbCopy1.Execute;
	   Label4.Caption := FormatDateTime('hh:nn:ss',Time-T);
   finally
   	Button2.Enabled := True;
   end;
end;

function SqlLogin(Database: TDatabase; AliasName,UserName,Password: string): Boolean;
begin
   if Database.Connected then
      Database.Close;
   Database.AliasName := AliasName;
   Database.Params.Values['USER NAME'] := UserName;
   Database.Params.Values['PASSWORD'] := Password;
   Database.Open;
   Result := Database.Connected;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
	List: TStringList;
begin
   if not Database1.Connected then
   begin
      LoginForm := TLoginForm.Create(Application);
      try
         if LoginForm.ShowModal=idOK then
            try
               SqlLogin(Database1,LoginForm.Alias,LoginForm.User,LoginForm.Password);
            except
               if (not Database1.Connected) then
                  raise EDatabaseError.Create('Login fehlgeschlagen !');
            end;
      finally
         LoginForm.Release;
      end;
   end;
   if Database1.Connected then
   begin
   	List := TStringList.Create;
   	Session.GetTableNames(Database1.DatabaseName,'',True,False,List);
      ComboBox1.Items.Assign(List);
      List.Free;
   end;
   RadioGroup1.ItemIndex := integer(batCopy);
end;

end.
