unit Testunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DBTables, DB, ExtCtrls, RtDbID;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Database1: TDatabase;
    RtDbGenID1: TRtDbGenID;
    Table1: TTable;
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    Button2: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Bevel1: TBevel;
    ComboBox1: TComboBox;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

uses
	Login;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
	if Table1.Active then
   	Table1.Close;
	Table1.TableName := ComboBox1.Text;
   RtDbGenID1.IDName := Edit1.Text;
	Label2.Caption := IntToStr(RtDbGenID1.NewValue);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
	if Table1.Active then
   	Table1.Close;
	Table1.TableName := ComboBox1.Text;
   RtDbGenID1.IDName := Edit1.Text;
	Label3.Caption := IntToStr(RtDbGenID1.CurrentValue);
end;

function SqlLogin(Database: TDatabase; AliasName,UserName,Password: string): Boolean;
begin
   if Database.Connected then
      Database.Close;
   Database.AliasName := AliasName;
   Database.Params.Values['USER NAME'] := UserName;
   Database.Params.Values['PASSWORD'] := Password;
   Database.Open;
   Result := Database.Connected;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
	List: TStringList;
begin
   if not Database1.Connected then
   begin
      LoginForm := TLoginForm.Create(Application);
      try
         if LoginForm.ShowModal=idOK then
            try
               SqlLogin(Database1,LoginForm.Alias,LoginForm.User,LoginForm.Password);
            except
               if (not Database1.Connected) then
                  raise EDatabaseError.Create('Login fehlgeschlagen !');
            end;
      finally
         LoginForm.Release;
      end;
   end;
   if Database1.Connected then
   begin
   	List := TStringList.Create;
   	Session.GetTableNames(Database1.DatabaseName,'',True,False,List);
      ComboBox1.Items.Assign(List);
      List.Free;
   end;
end;

end.
