{
	SingleRowDBGrid component demo application.

  Demonstrates using a SingleRowDBGrid component in an database application.


}
unit SRGDemoU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, Grids, DBGrids, CompColl, DB, DBTables,
  SRDBGrid, ExtCtrls, Mask, DBCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    ExitButton: TButton;
    MainMenu1: TMainMenu;
    OptionsMenu: TMenuItem;
    LWSButtonEnabled: TMenuItem;
    ExitButtonEnabled: TMenuItem;
    GridGroupBox: TGroupBox;
    SingleRowDBGrid: TSingleRowDBGrid;
    LWSButton: TButton;
    FileMenu: TMenuItem;
    ExitOption: TMenuItem;
    PCtrls: TMenuItem;
    NCtrls: TMenuItem;
    Bevel1: TBevel;
    Species: TDBEdit;
    SpeciesLabel: TLabel;
    Notes: TDBMemo;
    DBNavigator1: TDBNavigator;
    BioLifeBitmap: TDBImage;
    NotesLabel: TLabel;
    StatusBar: TStatusBar;
    SpeciesEnabled: TMenuItem;
    NotesEnabled: TMenuItem;
    LocalWrapStateTrue: TMenuItem;
    HelpMenu: TMenuItem;
    Help1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    LWSButtonTabStopEnabled: TMenuItem;
    BitmapTabStopEnabled: TMenuItem;
    procedure OptionsMenuClick(Sender: TObject);
    procedure LWSButtonEnabledClick(Sender: TObject);
    procedure ExitButtonEnabledClick(Sender: TObject);
    procedure ExitOptionClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SpeciesEnabledClick(Sender: TObject);
    procedure NotesEnabledClick(Sender: TObject);
    procedure GridGroupBoxEnter(Sender: TObject);
    procedure PCtrlsClick(Sender: TObject);
    procedure PCtrlClick(Sender: TObject);
    procedure NCtrlClick(Sender: TObject);
    procedure NCtrlsClick(Sender: TObject);
    procedure LocalWrapStateTrueClick(Sender: TObject);
    procedure SetStatusBarText;
    procedure GridGroupBoxExit(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure LWSButtonClick(Sender: TObject);
    procedure GridGroupBoxClick(Sender: TObject);
    procedure LWSButtonTabStopEnabledClick(Sender: TObject);
    procedure BitmapTabStopEnabledClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.OptionsMenuClick(Sender: TObject);
var
	InGrid : Boolean;
begin
	SpeciesEnabled.Enabled		 := ActiveControl <> Species;
	SpeciesEnabled.Checked   	 := Species.Enabled;
	LWSButtonEnabled.Enabled   := ActiveControl <> LWSButton;
	LWSButtonEnabled.Checked 	 := LWSButton.Enabled;
  NotesEnabled.Enabled		 	 := ActiveControl <> Notes;
  NotesEnabled.Checked		 	 := Notes.Enabled;
	ExitButtonEnabled.Enabled	 := ActiveControl <> ExitButton;
	ExitButtonEnabled.Checked	 := ExitButton.Enabled;
  InGrid := ActiveControl = SingleRowDBGrid;
  LocalWrapStateTrue.Enabled := InGrid;
  LocalWrapStateTrue.Checked := SingleRowDBGrid.LocalWrapState;
  PCtrls.Enabled := (InGrid and not LocalWrapStateTrue.Checked);
  NCtrls.Enabled := PCtrls.Enabled;
  LWSButtonTabStopEnabled.Checked := LWSButton.TabStop;
  BitmapTabStopEnabled.Checked := BioLifeBitmap.TabStop;
end;

procedure TForm1.LWSButtonEnabledClick(Sender: TObject);
begin
  LWSButton.Enabled := not LWSButtonEnabled.Checked;
end;

procedure TForm1.ExitButtonEnabledClick(Sender: TObject);
begin
  ExitButton.Enabled := not ExitButtonEnabled.Checked;
end;

procedure TForm1.ExitOptionClick(Sender: TObject);
begin
	Application.Terminate;
end;

procedure TForm1.FormResize(Sender: TObject);
var
	Margin : Integer;
	StatusBarHeight : Integer;
begin
	Margin := GridGroupBox.Left;
  StatusBarHeight := StatusBar.Height;
	with GridGroupBox do
  begin
		Width := (Form1.ClientWidth - (Margin*2));
  	SingleRowDBGrid.Width := (Width - (SingleRowDBGrid.Left*2));
    LWSButton.Left := (Round(ClientWidth/2)-Round(LWSButton.Width/2));
  end;
  Notes.Left := Margin;
  with BioLifeBitmap do
  begin
  	Height:= (Form1.ClientHeight-Top-Margin-StatusBarHeight);
    Width := Height;
    Left 	:= (GridGroupBox.Left+GridGroupBox.Width-Width);
    Notes.Width := (Left-(Margin*2));
    with Notes do
    begin
    	Height := (Form1.ClientHeight-Top-ExitButton.Height-(Margin*2)-StatusBarHeight);
	    ExitButton.Left := (Left+Round(Width/2)-Round(ExitButton.Width/2));
    end;
  end;
  with ExitButton do
	  Top := (Form1.ClientHeight-Height-Margin-StatusBarHeight);
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
	Application.Terminate;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  I						: Integer;
  NCtrl				: TMenuItem;
  PCtrl	 			: TMenuItem;
  TabList			: TList;
  TListItem : TWinControl;
begin
	Height 	:= Screen.Height-20;
  Width		:= Screen.Width-20;
  Position:= poScreenCenter;

{	for some reason, gridgroupbox.caption is getting cleared if set in the IDE }
	GridGroupBox.Caption := ' &Grid ';

{	this uses up the available space; could put this in OnResize event to keep
	columns' size adjusted }
  with SingleRowDBGrid do
  	begin
  		Columns[0].Width := (Round(SingleRowDBGrid.ClientWidth*0.2));
  		Columns[1].Width := (Round(SingleRowDBGrid.ClientWidth*0.4));
  		Columns[2].Width := (SingleRowDBGrid.ClientWidth-Columns[0].Width-Columns[1].Width-14);
    end;

{	collect available prior/next controls }
  PCtrl := TMenuItem.Create(PCtrls);
  PCtrl.Caption := 'nil';
  PCtrl.OnClick := PCtrlClick;
  PCtrls.Add(PCtrl);
  NCtrl := TMenuItem.Create(NCtrls);
  NCtrl.Caption := 'nil';
  NCtrl.OnClick := NCtrlClick;
  NCtrls.Add(NCtrl);
  TabList := TList.Create;
  try
	  GetTabOrderList(TabList);
	  for I := 0 to (Pred(TabList.Count)) do
	  begin
	  	TListItem := TabList.Items[I];
      with TWinControl(TListItem) do
	    if ((TabStop = True) and (Name <> 'Grid')) then
	    	begin
			    PCtrl := TMenuItem.Create(PCtrls);
			    PCtrl.Caption := Name;
          PCtrl.OnClick := PCtrlClick;
			    PCtrls.Add(PCtrl);
			    NCtrl := TMenuItem.Create(NCtrls);
			    NCtrl.Caption := Name;
          NCtrl.OnClick := NCtrlClick;
			    NCtrls.Add(NCtrl);
	      end;
	  end;
  finally
  	TabList.Free;
  end;
end;

procedure TForm1.SpeciesEnabledClick(Sender: TObject);
begin
  Species.Enabled := not SpeciesEnabled.Checked;
end;

procedure TForm1.NotesEnabledClick(Sender: TObject);
begin
  Notes.Enabled := not NotesEnabled.Checked;
end;

procedure TForm1.GridGroupBoxEnter(Sender: TObject);
begin
	SetStatusBarText;
//	SingleRowDBGrid.SetFocus;
end;

procedure TForm1.PCtrlClick(Sender: TObject);
var
	I				 : Integer;
	TabList  : TList;
  TListItem: TWinControl;
begin
	with Sender as TMenuItem do
	  begin
	 	if Caption = 'nil' then
			TSingleRowDBGrid(ActiveControl).PriorControl := nil
	  else
	  	begin
			  TabList := TList.Create;
			  try
				  GetTabOrderList(TabList);
				  for I := 0 to (Pred(TabList.Count)) do
	        	begin
					  	TListItem := TabList.Items[I];
			  		  if (TWinControl(TListItem).Name = Caption) then
	 	  	      	TSingleRowDBGrid(ActiveControl).PriorControl := TListItem;
					  end;
			  finally
			  	TabList.Free;
			  end;
	    end;
		end;
  SetStatusBarText;
end;

procedure TForm1.PCtrlsClick(Sender: TObject);
var
  CtrlName: String;
  I			  : Integer;
  TCtrl   : TWinControl;
begin
	TCtrl := SingleRowDBGrid.PriorControl;
  if TCtrl = nil then
  	CtrlName := 'nil'
  else
  	CtrlName := TWinControl(TCtrl).Name;
  with PCtrls do
	  for I := 0 to Count - 1 do
	 		Items[I].Checked := Items[I].Caption = CtrlName;
end;

procedure TForm1.NCtrlsClick(Sender: TObject);
var
  CtrlName: String;
  I			  : Integer;
  TCtrl   : TWinControl;
begin
	TCtrl := SingleRowDBGrid.NextControl;
  if TCtrl = nil then
  	CtrlName := 'nil'
  else
  	CtrlName := TWinControl(TCtrl).Name;
  with NCtrls do
	  for I := 0 to Count - 1 do
  		Items[I].Checked := Items[I].Caption = CtrlName;
end;

procedure TForm1.NCtrlClick(Sender: TObject);
var
	I					 : Integer;
	TabList 	 : TList;
  TListItem: TWinControl;
begin
	with Sender as TMenuItem do
	  begin
	 	if Caption = 'nil' then
			TSingleRowDBGrid(ActiveControl).NextControl := nil
	  else
	  	begin
			  TabList := TList.Create;
			  try
				  GetTabOrderList(TabList);
				  for I := 0 to (Pred(TabList.Count)) do
	        	begin
					  	TListItem := TabList.Items[I];
			  		  if (TWinControl(TListItem).Name = Caption) then
	 	  	      	TSingleRowDBGrid(ActiveControl).NextControl := TListItem;
					  end;
			  finally
			  	TabList.Free;
			  end;
	    end;
		end;
  SetStatusBarText;
end;

procedure TForm1.LocalWrapStateTrueClick(Sender: TObject);
begin
	with SingleRowDBGrid do
  begin
		LocalWrapState := not LocalWrapStateTrue.Checked;
		if (LocalWrapState = True) then
      LWSButton.Caption := 'Set  &LocalWrapState FALSE'
    else
      LWSButton.Caption := 'Set  &LocalWrapState TRUE';
  end;
  SetStatusBarText;
end;

procedure TForm1.SetStatusBarText;
var
	S: String;
begin
	with SingleRowDBGrid do
  	begin
			if LocalWrapState then
		  	S := 'LocalWrapState is True;'
		  else
		  	S := 'LocalWrapState is False;';
			if PriorControl = nil then
      	S := (S + ' PriorControl is nil;')
      else
      	S := (S + ' PriorControl is ' + TWinControl(PriorControl).Name + ';');
			if NextControl = nil then
      	S := (S + ' NextControl is nil;')
      else
      	S := (S + ' NextControl is ' + TWinControl(NextControl).Name + '.');
  	end;
  StatusBar.SimpleText := S;
end;

procedure TForm1.GridGroupBoxExit(Sender: TObject);
begin
	StatusBar.SimpleText := '';
end;

procedure TForm1.Help1Click(Sender: TObject);
begin
  Application.HelpFile := 'SRDBGRID.HLP';
  Application.HelpCommand(HELP_CONTEXT,1012);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
	Application.HelpCommand(HELP_QUIT,0);
end;

procedure TForm1.LWSButtonClick(Sender: TObject);
begin
	with SingleRowDBGrid do
	if (LocalWrapState = True) then
  	begin
    	LocalWrapState := False;
      LWSButton.Caption := 'Set  &LocalWrapState TRUE';
    end
  else
  	begin
    	LocalWrapState := True;
      LWSButton.Caption := 'Set  &LocalWrapState FALSE';
    end;
  SetStatusBarText;
  SingleRowDBGrid.SetFocus;
end;

procedure TForm1.GridGroupBoxClick(Sender: TObject);
begin
	if ActiveControl <> LWSButton then
  	SingleRowDBGrid.SetFocus;
end;

procedure TForm1.LWSButtonTabStopEnabledClick(Sender: TObject);
begin
	LWSButton.TabStop := (LWSButtonTabStopEnabled.Checked = False);
end;

procedure TForm1.BitmapTabStopEnabledClick(Sender: TObject);
begin
	BioLifeBitmap.TabStop := (BitmapTabStopEnabled.Checked = False);
end;

end.
