unit qr20frm2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Qrctrls, quickrpt, DB, DBTables, ExtCtrls, Qr20ssbc, SSBC;

type
  TfrmQRReport = class(TForm)
    QuickRep1: TQuickRep;
    tbCustomers: TTable;
    tbCustomersCompany: TStringField;
    tbCustomersAddr1: TStringField;
    tbCustomersAddr2: TStringField;
    tbCustomersCity: TStringField;
    tbCustomersState: TStringField;
    tbCustomersZip: TStringField;
    DetailBand1: TQRBand;
    TitleBand1: TQRBand;
    QRLabel1: TQRLabel;
    QRDBText1: TQRDBText;
    QRDBText2: TQRDBText;
    QRDBText3: TQRDBText;
    QRDBText4: TQRDBText;
    QRDBText5: TQRDBText;
    QRDBText6: TQRDBText;
    SSBarcode1: TSSBarcode;
    QR20ssBarcode1: TQR20ssBarcode;
    dsCustomers: TDataSource;
    procedure tbCustomersZipGetText(Sender: TField; var Text: string;
      DisplayText: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmQRReport: TfrmQRReport;

implementation

{$R *.DFM}

procedure TfrmQRReport.tbCustomersZipGetText(Sender: TField;
  var Text: string; DisplayText: Boolean);
var
  St : string;
  
  function IsNumeric(St : string) : boolean;

  var
    X   : integer;
    AcceptSet : set of char;
  begin
    Result := true;
    AcceptSet := ['0'..'9','-'];
    for X := 1 to Length(St) do
      if not (St[X] in AcceptSet) then
        Result:= false;
  end;

begin
  { it is the programmer's responsibility to make sure, when an ssBarcode is linked to a
    DataSource/DataField, that the values being passed to the barcode are legal for that
    symbology.  In this case, we are using PostNet, which requires a numeric zip code.
    Since the DBDEMOS:CUSTOMERS.DB file has some non-U.S. zip codes, we must write a
    GetText handler to throw out any codes that aren't numeric. }

  St := Sender.AsString;
  if (not IsNumeric(St)) or (not (Length(St) in [5,9,10,11])) then
    Text := ''
  else
    Text := St;

end;

end.
