unit Rpdemofm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Spin, Ssbc, ExtCtrls,
  RPSSBC, RPDefine, RPBase, RPCanvas, RPrinter;

type
  TfmDemo = class(TForm)
    Panel: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    cbType: TComboBox;
    ckBearer: TCheckBox;
    ckReadable: TCheckBox;
    cbOrientation: TComboBox;
    edData: TEdit;
    btUpdate: TBitBtn;
    btClose: TBitBtn;
    Panel1: TPanel;
    edWidth: TEdit;
    Label5: TLabel;
    btPrint: TBitBtn;
    FontDialog: TFontDialog;
    btFont: TBitBtn;
    ReportPrinter1: TReportPrinter;
    RPSSBarCode: TRPSSBarCode;
    procedure btUpdateClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ckBearerClick(Sender: TObject);
    procedure ckReadableClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure btPrintClick(Sender: TObject);
    procedure btFontClick(Sender: TObject);
    procedure ReportPrinter1Print(Sender: TObject);
  private
    procedure RepositionCode;
  public
  end;

var
  fmDemo: TfmDemo;

implementation

{$R *.DFM}

procedure TfmDemo.btUpdateClick(Sender: TObject);
begin
  with RPssBarCode do
  begin
    Data := edData.Text;
    BarWidth := StrToFloat(edWidth.Text);
    case cbType.ItemIndex of
      0 : BarCodeType := bcCode128;
      1 : BarCodeType := bcCode39;
      2 : BarCodeType := bcEAN_13;
      3 : BarCodeType := bcInt2of5;
      4 : BarCodeType := bcPostnet;
      5 : BarCodeType := bcUPC_A;
    end;
    case cbOrientation.ItemIndex of
      0 : Orientation := orLeft_Right;
      1 : Orientation := orRight_Left;
      2 : Orientation := orTop_Bottom;
      3 : Orientation := orBottom_Top;
    end;
    ckBearer.Checked := BearerBars;
  end;
  RepositionCode;
end;

procedure TfmDemo.FormCreate(Sender: TObject);
begin
  cbType.ItemIndex := 1;
  cbOrientation.ItemIndex := 0;
  RepositionCode;
end;

procedure TfmDemo.ckBearerClick(Sender: TObject);
begin
  try
    RPssBarCode.BearerBars := ckBearer.Checked;
  finally
    ckBearer.Checked := RPssBarCode.BearerBars;
  end;
end;

procedure TfmDemo.ckReadableClick(Sender: TObject);
begin
  RPssBarCode.PrintHumanReadable := ckReadable.Checked;
end;

procedure TfmDemo.RepositionCode;

begin
  RPssBarCode.Left := (fmDemo.Width - RPssBarCode.Width) div 2;
  RPssBarCode.Top := ((fmDemo.Height-Panel.Height) - RPssBarCode.Height) div 2;
end;

procedure TfmDemo.FormResize(Sender: TObject);
begin
  RepositionCode;
end;

procedure TfmDemo.btPrintClick(Sender: TObject);
begin
  ReportPrinter1.Execute;
  ShowMessage('Report printed!');
end;

procedure TfmDemo.btFontClick(Sender: TObject);
begin
  with FontDialog do
  begin
    Font := RPssBarcode.Font;
    if Execute then
      RPssBarcode.Font := Font;
  end;
end;

procedure TfmDemo.ReportPrinter1Print(Sender: TObject);
begin
  With Sender as TBaseReport do
  begin
    { It's this easy to print your barcode!  Specify the X and Y positions in inches.
      The third parameter is the height in inches.  If you specify 0 (zero), ssBarcode will
      calculate the standard height-to-width ratio for this code }

    RPSSBarCode.PrintBarCode(Sender,2.0,2.0,0.0);
  end; { with }
end;

end.
