
unit tspimp;

interface

uses
  {$IFDEF Win32}
  Windows,
  {$ELSE}
  WinProcs, WinTypes,
  {$ENDIF}
  Tapih, Tspih;

{$DEFINE Tapi_NoSupportPhone}

{$I tspi.inc}

implementation

function TSPI_lineAccept(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    lpsUserUserInfo : LPCSTR;
    dwSize : DWORD) : LONG; 
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineAddToConference(
    dwRequestID : TDRV_REQUESTID;
    hdConfCall : HDRVCALL;
    hdConsultCall : HDRVCALL) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineAnswer(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    lpsUserUserInfo : LPCSTR;
    dwSize : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_lineBlindTransfer(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    lpszDestAddress : LPCWSTR;
    dwCountryCode : DWORD) : LONG;
{$ELSE}
function TSPI_lineBlindTransfer(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    lpszDestAddress : LPCSTR;
    dwCountryCode : DWORD) : LONG;
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineClose(
    hdLine : HDRVLINE) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineCloseCall(
    hdCall : HDRVCALL) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineCompleteCall(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    lpdwCompletionID : LPDWORD;
    dwCompletionMode : DWORD;
    dwMessageID : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineCompleteTransfer(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    hdConsultCall : HDRVCALL;
    htConfCall : HTAPICALL;
    lphdConfCall : LPHDRVCALL;
    dwTransferMode : DWORD) : LONG; 
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineConditionalMediaDetection(
    hdLine : HDRVLINE;
    dwMediaModes : DWORD;
    const lpCallParams : LPLINECALLPARAMS) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineDevSpecific(
    dwRequestID : TDRV_REQUESTID;
    hdLine : HDRVLINE;
    dwAddressID : DWORD;
    hdCall : HDRVCALL;
    lpParams : LPVOID;
    dwSize : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineDevSpecificFeature(
    dwRequestID : TDRV_REQUESTID;
    hdLine : HDRVLINE;
    dwFeature : DWORD;
    lpParams : LPVOID;
    dwSize : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_lineDial(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    lpszDestAddress : LPCWSTR;
    dwCountryCode : DWORD) : LONG; 
{$ELSE}
function TSPI_lineDial(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    lpszDestAddress : LPCSTR;
    dwCountryCode : DWORD) : LONG; 
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineDrop(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    lpsUserUserInfo : LPCSTR;
    dwSize : DWORD) : LONG; 
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineDropOnClose(
    hdCall : HDRVCALL) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineDropNoOwner(
    hdCall : HDRVCALL) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineForward(
    dwRequestID : TDRV_REQUESTID;
    hdLine : HDRVLINE;
    bAllAddresses : DWORD;
    dwAddressID : DWORD;
    const lpForwardList : LPLINEFORWARDLIST;
    dwNumRingsNoAnswer : DWORD;
    htConsultCall : HTAPICALL;
    lphdConsultCall : LPHDRVCALL;
    const lpCallParams : LPLINECALLPARAMS) : LONG; 
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_lineGatherDigits(
    hdCall : HDRVCALL;
    dwEndToEndID : DWORD;
    dwDigitModes : DWORD;
    lpsDigits : LPWSTR;
    dwNumDigits : DWORD;
    lpszTerminationDigits : LPCWSTR;
    dwFirstDigitTimeout : DWORD;
    dwInterDigitTimeout : DWORD) : LONG; 
{$ELSE}
function TSPI_lineGatherDigits(
    hdCall : HDRVCALL;
    dwEndToEndID : DWORD;
    dwDigitModes : DWORD;
    lpsDigits : LPSTR;
    dwNumDigits : DWORD;
    lpszTerminationDigits : LPCSTR;
    dwFirstDigitTimeout : DWORD;
    dwInterDigitTimeout : DWORD) : LONG;
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_lineGenerateDigits(
    hdCall : HDRVCALL;
    dwEndToEndID : DWORD;
    dwDigitMode : DWORD;
    lpszDigits : LPCWSTR;
    dwDuration : DWORD) : LONG; 
{$ELSE}
function TSPI_lineGenerateDigits(
    hdCall : HDRVCALL;
    dwEndToEndID : DWORD;
    dwDigitMode : DWORD;
    lpszDigits : LPCSTR;
    dwDuration : DWORD) : LONG; 
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineGenerateTone(
    hdCall : HDRVCALL;
    dwEndToEndID : DWORD;
    dwToneMode : DWORD;
    dwDuration : DWORD;
    dwNumTones : DWORD;
    const lpTones : LPLINEGENERATETONE) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineGetAddressCaps(
    dwDeviceID : DWORD;
    dwAddressID : DWORD;
    dwTSPIVersion : DWORD;
    dwExtVersion : DWORD;
    lpAddressCaps : LPLINEADDRESSCAPS) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_lineGetAddressID(
    hdLine : HDRVLINE;
    lpdwAddressID : LPDWORD;
    dwAddressMode : DWORD;
    lpsAddress : LPCWSTR;
    dwSize : DWORD) : LONG; 
{$ELSE}
function TSPI_lineGetAddressID(
    hdLine : HDRVLINE;
    lpdwAddressID : LPDWORD;
    dwAddressMode : DWORD;
    lpsAddress : LPCSTR;
    dwSize : DWORD) : LONG; 
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineGetAddressStatus(
    hdLine : HDRVLINE;
    dwAddressID : DWORD;
    lpAddressStatus : LPLINEADDRESSSTATUS) : LONG; 
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineGetCallAddressID(
    hdCall : HDRVCALL;
    lpdwAddressID : LPDWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineGetCallInfo(
    hdCall : HDRVCALL;
    lpCallInfo : LPLINECALLINFO) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineGetCallStatus(
    hdCall : HDRVCALL;
    lpCallStatus : LPLINECALLSTATUS) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineGetDevCaps(
    dwDeviceID : DWORD;
    dwTSPIVersion : DWORD;
    dwExtVersion : DWORD;
    lpLineDevCaps : LPLINEDEVCAPS) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_lineGetDevConfig(
    dwDeviceID : DWORD;
    lpDeviceConfig : LPVARSTRING;
    lpszDeviceClass : LPCWSTR) : LONG; 
{$ELSE}
function TSPI_lineGetDevConfig(
    dwDeviceID : DWORD;
    lpDeviceConfig : LPVARSTRING;
    lpszDeviceClass : LPCSTR) : LONG; 
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineGetExtensionID(
    dwDeviceID : DWORD;
    dwTSPIVersion : DWORD;
    lpExtensionID : LPLINEEXTENSIONID) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_lineGetIcon(
    dwDeviceID : DWORD;
    lpszDeviceClass : LPCWSTR;
    lphIcon : LPHICON) : LONG; 
{$ELSE}
function TSPI_lineGetIcon(
    dwDeviceID : DWORD;
    lpszDeviceClass : LPCSTR;
    lphIcon : LPHICON) : LONG; 
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_lineGetID(
    hdLine : HDRVLINE;
    dwAddressID : DWORD;
    hdCall : HDRVCALL;
    dwSelect : DWORD;
    lpDeviceID : LPVARSTRING;
    lpszDeviceClass : LPCWSTR;
    hTargetProcess : THandle) : LONG;                 // TSPI v2.0
{$ELSE}
function TSPI_lineGetID(
    hdLine : HDRVLINE;
    dwAddressID : DWORD;
    hdCall : HDRVCALL;
    dwSelect : DWORD;
    lpDeviceID : LPVARSTRING;
    lpszDeviceClass : LPCSTR) : LONG; 
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineGetLineDevStatus(
    hdLine : HDRVLINE;
    lpLineDevStatus : LPLINEDEVSTATUS) : LONG; 
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineGetNumAddressIDs(
    hdLine : HDRVLINE;
    lpdwNumAddressIDs : LPDWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineHold(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_lineMakeCall(
    dwRequestID : TDRV_REQUESTID;
    hdLine : HDRVLINE;
    htCall : HTAPICALL;
    lphdCall : LPHDRVCALL;
    lpszDestAddress : LPCWSTR;
    dwCountryCode : DWORD;
    const lpCallParams : LPLINECALLPARAMS) : LONG; 
{$ELSE}
function TSPI_lineMakeCall(
    dwRequestID : TDRV_REQUESTID;
    hdLine : HDRVLINE;
    htCall : HTAPICALL;
    lphdCall : LPHDRVCALL;
    lpszDestAddress : LPCSTR;
    dwCountryCode : DWORD;
    const lpCallParams : LPLINECALLPARAMS) : LONG; 
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineMonitorDigits(
    hdCall : HDRVCALL;
    dwDigitModes : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineMonitorMedia(
    hdCall : HDRVCALL;
    dwMediaModes : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineMonitorTones(
    hdCall : HDRVCALL;
    dwToneListID : DWORD;
    const lpToneList : LPLINEMONITORTONE;
    dwNumEntries : DWORD) : LONG; 
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineNegotiateExtVersion(
    dwDeviceID : DWORD;
    dwTSPIVersion : DWORD;
    dwLowVersion : DWORD;
    dwHighVersion : DWORD;
    lpdwExtVersion : LPDWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineNegotiateTSPIVersion(
    dwDeviceID : DWORD;
    dwLowVersion : DWORD;
    dwHighVersion : DWORD;
    lpdwTSPIVersion : LPDWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineOpen(
    dwDeviceID : DWORD;
    htLine : HTAPILINE;
    lphdLine : LPHDRVLINE;
    dwTSPIVersion : DWORD;
    lpfnEventProc : TLINEEVENT) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_linePark(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    dwParkMode : DWORD;
    lpszDirAddress : LPCWSTR;
    lpNonDirAddress : LPVARSTRING) : LONG; 
{$ELSE}
function TSPI_linePark(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    dwParkMode : DWORD;
    lpszDirAddress : LPCSTR;
    lpNonDirAddress : LPVARSTRING) : LONG;
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_linePickup(
    dwRequestID : TDRV_REQUESTID;
    hdLine : HDRVLINE;
    dwAddressID : DWORD;
    htCall : HTAPICALL;
    lphdCall : LPHDRVCALL;
    lpszDestAddress : LPCWSTR;
    lpszGroupID : LPCWSTR) : LONG; 
{$ELSE}
function TSPI_linePickup(
    dwRequestID : TDRV_REQUESTID;
    hdLine : HDRVLINE;
    dwAddressID : DWORD;
    htCall : HTAPICALL;
    lphdCall : LPHDRVCALL;
    lpszDestAddress : LPCSTR;
    lpszGroupID : LPCSTR) : LONG; 
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_linePrepareAddToConference(
    dwRequestID : TDRV_REQUESTID;
    hdConfCall : HDRVCALL;
    htConsultCall : HTAPICALL;
    lphdConsultCall : LPHDRVCALL;
    const lpCallParams : LPLINECALLPARAMS) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_lineRedirect(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    lpszDestAddress : LPCWSTR;
    dwCountryCode : DWORD) : LONG;
{$ELSE}
function TSPI_lineRedirect(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    lpszDestAddress : LPCSTR;
    dwCountryCode : DWORD) : LONG; 
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineReleaseUserUserInfo(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineRemoveFromConference(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineSecureCall(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineSelectExtVersion(
    hdLine : HDRVLINE;
    dwExtVersion : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineSendUserUserInfo(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    lpsUserUserInfo : LPCSTR;
    dwSize : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineSetAppSpecific(
    hdCall : HDRVCALL;
    dwAppSpecific : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}

function TSPI_lineSetCallData(                                           // TSPI v2.0
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    lpCallData : LPVOID;
    dwSize : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$ENDIF}

function TSPI_lineSetCallParams(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    dwBearerMode : DWORD;
    dwMinRate : DWORD;
    dwMaxRate : DWORD;
    const lpDialParams : LPLINEDIALPARAMS) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}

function TSPI_lineSetCallQualityOfService(                               // TSPI v2.0
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    lpSendingFlowspec : LPVOID;
    dwSendingFlowspecSize : DWORD;
    lpReceivingFlowspec : LPVOID;
    dwReceivingFlowspecSize : DWORD) : LONG; 
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineSetCallTreatment(                                      // TSPI v2.0
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    dwTreatment : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$ENDIF}

function TSPI_lineSetCurrentLocation(
    dwLocation : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineSetDefaultMediaDetection(
    hdLine : HDRVLINE;
    dwMediaModes : DWORD) : LONG; 
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_lineSetDevConfig(
    dwDeviceID : DWORD;
    const lpDeviceConfig : LPVOID;
    dwSize : DWORD;
    lpszDeviceClass : LPCWSTR) : LONG;
{$ELSE}
function TSPI_lineSetDevConfig(
    dwDeviceID : DWORD;
    const lpDeviceConfig : LPVOID;
    dwSize : DWORD;
    lpszDeviceClass : LPCSTR) : LONG;
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}

function TSPI_lineSetLineDevStatus(                                      // TSPI v2.0
    dwRequestID : TDRV_REQUESTID;
    hdLine : HDRVLINE;
    dwStatusToChange : DWORD;
    fStatus : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$ENDIF}

function TSPI_lineSetMediaControl(
    hdLine : HDRVLINE;
    dwAddressID : DWORD;
    hdCall : HDRVCALL;
    dwSelect : DWORD;
    const lpDigitList : LPLINEMEDIACONTROLDIGIT;
    dwDigitNumEntries : DWORD;
    const lpMediaList : LPLINEMEDIACONTROLMEDIA;
    dwMediaNumEntries : DWORD;
    const lpToneList : LPLINEMEDIACONTROLTONE;
    dwToneNumEntries : DWORD;
    const lpCallStateList : LPLINEMEDIACONTROLCALLSTATE;
    dwCallStateNumEntries : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineSetMediaMode(
    hdCall : HDRVCALL;
    dwMediaMode : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineSetStatusMessages(
    hdLine : HDRVLINE;
    dwLineStates : DWORD;
    dwAddressStates : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineSetTerminal(
    dwRequestID : TDRV_REQUESTID;
    hdLine : HDRVLINE;
    dwAddressID : DWORD;
    hdCall : HDRVCALL;
    dwSelect : DWORD;
    dwTerminalModes : DWORD;
    dwTerminalID : DWORD;
    bEnable : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineSetupConference(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    hdLine : HDRVLINE;
    htConfCall : HTAPICALL;
    lphdConfCall : LPHDRVCALL;
    htConsultCall : HTAPICALL;
    lphdConsultCall : LPHDRVCALL;
    dwNumParties : DWORD;
    const lpCallParams : LPLINECALLPARAMS) : LONG; 
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineSetupTransfer(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL;
    htConsultCall : HTAPICALL;
    lphdConsultCall : LPHDRVCALL;
    const lpCallParams : LPLINECALLPARAMS) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineSwapHold(
    dwRequestID : TDRV_REQUESTID;
    hdActiveCall : HDRVCALL;
    hdHeldCall : HDRVCALL) : LONG; 
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineUncompleteCall(
    dwRequestID : TDRV_REQUESTID;
    hdLine : HDRVLINE;
    dwCompletionID : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineUnhold(
    dwRequestID : TDRV_REQUESTID;
    hdCall : HDRVCALL) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$IFDEF Tapi_Ver20}
function TSPI_lineUnpark(
    dwRequestID : TDRV_REQUESTID;
    hdLine : HDRVLINE;
    dwAddressID : DWORD;
    htCall : HTAPICALL;
    lphdCall : LPHDRVCALL;
    lpszDestAddress : LPCWSTR) : LONG; 
{$ELSE}
function TSPI_lineUnpark(
    dwRequestID : TDRV_REQUESTID;
    hdLine : HDRVLINE;
    dwAddressID : DWORD;
    htCall : HTAPICALL;
    lphdCall : LPHDRVCALL;
    lpszDestAddress : LPCSTR) : LONG; 
{$ENDIF}
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_providerCreateLineDevice(
    dwTempID : DWORD;
    dwDeviceID : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_providerCreatePhoneDevice(
    dwTempID : DWORD;
    dwDeviceID : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_providerEnumDevices(
    dwPermanentProviderID : DWORD;
    lpdwNumLines : LPDWORD;
    lpdwNumPhones : LPDWORD;
    hProvider : HPROVIDER;
    lpfnLineCreateProc : TLINEEVENT;
    lpfnPhoneCreateProc : TPHONEEVENT) : LONG;
begin
  lpdwNumLines^:=3;
  lpdwNumPhones^:=0;
  Result:=0;
end;

{$IFDEF Tapi_Ver20}
function TSPI_providerFreeDialogInstance(                                // TSPI v2.0
    hdDlgInst : HDRVDIALOGINSTANCE) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_providerGenericDialogData(                                 // TSPI v2.0
    dwObjectID : DWORD;
    dwObjectType : DWORD;
    lpParams : LPVOID;
    dwSize : DWORD) : LONG; 
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$ENDIF}

function TSPI_providerInit(
    dwTSPIVersion : DWORD;
    dwPermanentProviderID : DWORD;
    dwLineDeviceIDBase : DWORD;
    dwPhoneDeviceIDBase : DWORD;
    dwNumLines : DWORD;
    dwNumPhones : DWORD;
    lpfnCompletionProc : TASYNC_COMPLETION
{$IFDEF Tapi_Ver20}
    ;
    lpdwTSPIOptions : LPDWORD
{$ENDIF}
    ) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_providerInstall(
    hwndOwner : HWND;
    dwPermanentProviderID : DWORD) : LONG;
begin
  Result:=0;
end;

function TSPI_providerRemove(
    hwndOwner : HWND;
    dwPermanentProviderID : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_providerShutdown(
    dwTSPIVersion : DWORD
{$IFDEF Tapi_Ver20}
    ;
    dwPermanentProviderID : DWORD                    // TSPI v2.0
{$ENDIF}
    ) : LONG;
begin
  Result:=0;
end;

{$IFDEF Tapi_Ver20}

function TSPI_providerUIIdentify(                                        // TSPI v2.0
    lpszUIDLLName : LPWSTR) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TUISPI_lineConfigDialog(                                        // TSPI v2.0
    lpfnUIDLLCallback : TUISPIDLLCALLBACK;
    dwDeviceID : DWORD;
    hwndOwner : HWND;
    lpszDeviceClass : LPCWSTR) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TUISPI_lineConfigDialogEdit(                                    // TSPI v2.0
    lpfnUIDLLCallback : TUISPIDLLCALLBACK;
    dwDeviceID : DWORD;
    hwndOwner : HWND;
    lpszDeviceClass : LPCWSTR;
    const lpDeviceConfigIn : LPVOID;
    dwSize : DWORD;
    lpDeviceConfigOut : LPVARSTRING) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TUISPI_providerConfig(                                          // TSPI v2.0
    lpfnUIDLLCallback : TUISPIDLLCALLBACK;
    hwndOwner : HWND;
    dwPermanentProviderID : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TUISPI_providerGenericDialog(                                   // TSPI v2.0
    lpfnUIDLLCallback : TUISPIDLLCALLBACK;
    htDlgInst : HTAPIDIALOGINSTANCE;
    lpParams : LPVOID;
    dwSize : DWORD;
    hEvent : THandle) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TUISPI_providerGenericDialogData(                               // TSPI v2.0
    htDlgInst : HTAPIDIALOGINSTANCE;
    lpParams : LPVOID;
    dwSize : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TUISPI_providerInstall(                                         // TSPI v2.0
    lpfnUIDLLCallback : TUISPIDLLCALLBACK;
    hwndOwner : HWND;
    dwPermanentProviderID : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TUISPI_providerRemove(                                          // TSPI v2.0
    lpfnUIDLLCallback : TUISPIDLLCALLBACK;
    hwndOwner : HWND;
    dwPermanentProviderID : DWORD) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

{$ENDIF}

function TSPI_lineConfigDialog(
    dwDeviceID : DWORD;
    hwndOwner : HWND;
    lpszDeviceClass : LPCSTR) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_lineConfigDialogEdit(
    dwDeviceID : DWORD;
    hwndOwner : HWND;
    lpszDeviceClass : LPCSTR;
    const lpDeviceConfigIn : LPVOID;
    dwSize : DWORD;
    lpDeviceConfigOut : LPVARSTRING
) : LONG;
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

function TSPI_providerConfig(
    hwndOwner : HWND;
    dwPermanentProviderID : DWORD
) : LONG; 
begin
  Result:=LINEERR_OPERATIONUNAVAIL;
end;

end.
