{!! Include file for TAPI service providers (TSP). }

{$IFNDEF Win32}
  {$DEFINE Tapi_ForceVer14}
{$ENDIF}
{$IFDEF Tapi_ForceVer14}
  {$UNDEF Tapi_Ver20}
{$ENDIF}

{$IFDEF Win32}  {!!-------------------Win32-------------------}

  function TSPI_lineAccept(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpsUserUserInfo : LPCSTR;
      dwSize : DWORD) : LONG; stdcall;


  function TSPI_lineAddToConference(
      dwRequestID : TDRV_REQUESTID;
      hdConfCall : HDRVCALL;
      hdConsultCall : HDRVCALL) : LONG; stdcall;


  function TSPI_lineAnswer(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpsUserUserInfo : LPCSTR;
      dwSize : DWORD) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineBlindTransfer(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpszDestAddress : LPCWSTR;
      dwCountryCode : DWORD) : LONG; stdcall;
  {$ELSE}
  function TSPI_lineBlindTransfer(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpszDestAddress : LPCSTR;
      dwCountryCode : DWORD) : LONG; stdcall;
  {$ENDIF}


  function TSPI_lineClose(
      hdLine : HDRVLINE) : LONG; stdcall;


  function TSPI_lineCloseCall(
      hdCall : HDRVCALL) : LONG; stdcall;


  function TSPI_lineCompleteCall(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpdwCompletionID : LPDWORD;
      dwCompletionMode : DWORD;
      dwMessageID : DWORD) : LONG; stdcall;


  function TSPI_lineCompleteTransfer(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      hdConsultCall : HDRVCALL;
      htConfCall : HTAPICALL;
      lphdConfCall : LPHDRVCALL;
      dwTransferMode : DWORD) : LONG; stdcall;


  function TSPI_lineConditionalMediaDetection(
      hdLine : HDRVLINE;
      dwMediaModes : DWORD;
      const lpCallParams : LPLINECALLPARAMS) : LONG; stdcall;


  function TSPI_lineDevSpecific(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      hdCall : HDRVCALL;
      lpParams : LPVOID;
      dwSize : DWORD) : LONG; stdcall;


  function TSPI_lineDevSpecificFeature(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwFeature : DWORD;
      lpParams : LPVOID;
      dwSize : DWORD) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineDial(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpszDestAddress : LPCWSTR;
      dwCountryCode : DWORD) : LONG; stdcall;
  {$ELSE}
  function TSPI_lineDial(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpszDestAddress : LPCSTR;
      dwCountryCode : DWORD) : LONG; stdcall;
  {$ENDIF}


  function TSPI_lineDrop(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpsUserUserInfo : LPCSTR;
      dwSize : DWORD) : LONG; stdcall;


  function TSPI_lineDropOnClose(
      hdCall : HDRVCALL) : LONG; stdcall;


  function TSPI_lineDropNoOwner(
      hdCall : HDRVCALL) : LONG; stdcall;


  function TSPI_lineForward(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      bAllAddresses : DWORD;
      dwAddressID : DWORD;
      const lpForwardList : LPLINEFORWARDLIST;
      dwNumRingsNoAnswer : DWORD;
      htConsultCall : HTAPICALL;
      lphdConsultCall : LPHDRVCALL;
      const lpCallParams : LPLINECALLPARAMS) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineGatherDigits(
      hdCall : HDRVCALL;
      dwEndToEndID : DWORD;
      dwDigitModes : DWORD;
      lpsDigits : LPWSTR;
      dwNumDigits : DWORD;
      lpszTerminationDigits : LPCWSTR;
      dwFirstDigitTimeout : DWORD;
      dwInterDigitTimeout : DWORD) : LONG; stdcall;
  {$ELSE}
  function TSPI_lineGatherDigits(
      hdCall : HDRVCALL;
      dwEndToEndID : DWORD;
      dwDigitModes : DWORD;
      lpsDigits : LPSTR;
      dwNumDigits : DWORD;
      lpszTerminationDigits : LPCSTR;
      dwFirstDigitTimeout : DWORD;
      dwInterDigitTimeout : DWORD) : LONG; stdcall;
  {$ENDIF}


  {$IFDEF Tapi_Ver20}
  function TSPI_lineGenerateDigits(
      hdCall : HDRVCALL;
      dwEndToEndID : DWORD;
      dwDigitMode : DWORD;
      lpszDigits : LPCWSTR;
      dwDuration : DWORD) : LONG; stdcall;
  {$ELSE}
  function TSPI_lineGenerateDigits(
      hdCall : HDRVCALL;
      dwEndToEndID : DWORD;
      dwDigitMode : DWORD;
      lpszDigits : LPCSTR;
      dwDuration : DWORD) : LONG; stdcall;
  {$ENDIF}


  function TSPI_lineGenerateTone(
      hdCall : HDRVCALL;
      dwEndToEndID : DWORD;
      dwToneMode : DWORD;
      dwDuration : DWORD;
      dwNumTones : DWORD;
      const lpTones : LPLINEGENERATETONE) : LONG; stdcall;


  function TSPI_lineGetAddressCaps(
      dwDeviceID : DWORD;
      dwAddressID : DWORD;
      dwTSPIVersion : DWORD;
      dwExtVersion : DWORD;
      lpAddressCaps : LPLINEADDRESSCAPS) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineGetAddressID(
      hdLine : HDRVLINE;
      lpdwAddressID : LPDWORD;
      dwAddressMode : DWORD;
      lpsAddress : LPCWSTR;
      dwSize : DWORD) : LONG; stdcall;
  {$ELSE}
  function TSPI_lineGetAddressID(
      hdLine : HDRVLINE;
      lpdwAddressID : LPDWORD;
      dwAddressMode : DWORD;
      lpsAddress : LPCSTR;
      dwSize : DWORD) : LONG; stdcall;
  {$ENDIF}


  function TSPI_lineGetAddressStatus(
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      lpAddressStatus : LPLINEADDRESSSTATUS) : LONG; stdcall;


  function TSPI_lineGetCallAddressID(
      hdCall : HDRVCALL;
      lpdwAddressID : LPDWORD) : LONG; stdcall;


  function TSPI_lineGetCallInfo(
      hdCall : HDRVCALL;
      lpCallInfo : LPLINECALLINFO) : LONG; stdcall;


  function TSPI_lineGetCallStatus(
      hdCall : HDRVCALL;
      lpCallStatus : LPLINECALLSTATUS) : LONG; stdcall;


  function TSPI_lineGetDevCaps(
      dwDeviceID : DWORD;
      dwTSPIVersion : DWORD;
      dwExtVersion : DWORD;
      lpLineDevCaps : LPLINEDEVCAPS) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineGetDevConfig(
      dwDeviceID : DWORD;
      lpDeviceConfig : LPVARSTRING;
      lpszDeviceClass : LPCWSTR) : LONG; stdcall;
  {$ELSE}
  function TSPI_lineGetDevConfig(
      dwDeviceID : DWORD;
      lpDeviceConfig : LPVARSTRING;
      lpszDeviceClass : LPCSTR) : LONG; stdcall;
  {$ENDIF}


  function TSPI_lineGetExtensionID(
      dwDeviceID : DWORD;
      dwTSPIVersion : DWORD;
      lpExtensionID : LPLINEEXTENSIONID) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineGetIcon(
      dwDeviceID : DWORD;
      lpszDeviceClass : LPCWSTR;
      lphIcon : LPHICON) : LONG; stdcall;
  {$ELSE}
  function TSPI_lineGetIcon(
      dwDeviceID : DWORD;
      lpszDeviceClass : LPCSTR;
      lphIcon : LPHICON) : LONG; stdcall;
  {$ENDIF}


  {$IFDEF Tapi_Ver20}
  function TSPI_lineGetID(
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      hdCall : HDRVCALL;
      dwSelect : DWORD;
      lpDeviceID : LPVARSTRING;
      lpszDeviceClass : LPCWSTR;
      hTargetProcess : THandle) : LONG; stdcall;                // TSPI v2.0
  {$ELSE}
  function TSPI_lineGetID(
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      hdCall : HDRVCALL;
      dwSelect : DWORD;
      lpDeviceID : LPVARSTRING;
      lpszDeviceClass : LPCSTR) : LONG; stdcall;
  {$ENDIF}


  function TSPI_lineGetLineDevStatus(
      hdLine : HDRVLINE;
      lpLineDevStatus : LPLINEDEVSTATUS) : LONG; stdcall;


  function TSPI_lineGetNumAddressIDs(
      hdLine : HDRVLINE;
      lpdwNumAddressIDs : LPDWORD) : LONG; stdcall;


  function TSPI_lineHold(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineMakeCall(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      htCall : HTAPICALL;
      lphdCall : LPHDRVCALL;
      lpszDestAddress : LPCWSTR;
      dwCountryCode : DWORD;
      const lpCallParams : LPLINECALLPARAMS) : LONG; stdcall;
  {$ELSE}
  function TSPI_lineMakeCall(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      htCall : HTAPICALL;
      lphdCall : LPHDRVCALL;
      lpszDestAddress : LPCSTR;
      dwCountryCode : DWORD;
      const lpCallParams : LPLINECALLPARAMS) : LONG; stdcall;
  {$ENDIF}


  function TSPI_lineMonitorDigits(
      hdCall : HDRVCALL;
      dwDigitModes : DWORD) : LONG; stdcall;


  function TSPI_lineMonitorMedia(
      hdCall : HDRVCALL;
      dwMediaModes : DWORD) : LONG; stdcall;


  function TSPI_lineMonitorTones(
      hdCall : HDRVCALL;
      dwToneListID : DWORD;
      const lpToneList : LPLINEMONITORTONE;
      dwNumEntries : DWORD) : LONG; stdcall;


  function TSPI_lineNegotiateExtVersion(
      dwDeviceID : DWORD;
      dwTSPIVersion : DWORD;
      dwLowVersion : DWORD;
      dwHighVersion : DWORD;
      lpdwExtVersion : LPDWORD) : LONG; stdcall;


  function TSPI_lineNegotiateTSPIVersion(
      dwDeviceID : DWORD;
      dwLowVersion : DWORD;
      dwHighVersion : DWORD;
      lpdwTSPIVersion : LPDWORD) : LONG; stdcall;


  function TSPI_lineOpen(
      dwDeviceID : DWORD;
      htLine : HTAPILINE;
      lphdLine : LPHDRVLINE;
      dwTSPIVersion : DWORD;
      lpfnEventProc : TLINEEVENT) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_linePark(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      dwParkMode : DWORD;
      lpszDirAddress : LPCWSTR;
      lpNonDirAddress : LPVARSTRING) : LONG; stdcall;
  {$ELSE}
  function TSPI_linePark(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      dwParkMode : DWORD;
      lpszDirAddress : LPCSTR;
      lpNonDirAddress : LPVARSTRING) : LONG; stdcall;
  {$ENDIF}


  {$IFDEF Tapi_Ver20}
  function TSPI_linePickup(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      htCall : HTAPICALL;
      lphdCall : LPHDRVCALL;
      lpszDestAddress : LPCWSTR;
      lpszGroupID : LPCWSTR) : LONG; stdcall;
  {$ELSE}
  function TSPI_linePickup(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      htCall : HTAPICALL;
      lphdCall : LPHDRVCALL;
      lpszDestAddress : LPCSTR;
      lpszGroupID : LPCSTR) : LONG; stdcall;
  {$ENDIF}


  function TSPI_linePrepareAddToConference(
      dwRequestID : TDRV_REQUESTID;
      hdConfCall : HDRVCALL;
      htConsultCall : HTAPICALL;
      lphdConsultCall : LPHDRVCALL;
      const lpCallParams : LPLINECALLPARAMS) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineRedirect(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpszDestAddress : LPCWSTR;
      dwCountryCode : DWORD) : LONG; stdcall;
  {$ELSE}
  function TSPI_lineRedirect(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpszDestAddress : LPCSTR;
      dwCountryCode : DWORD) : LONG; stdcall;
  {$ENDIF}


  function TSPI_lineReleaseUserUserInfo(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL) : LONG; stdcall;


  function TSPI_lineRemoveFromConference(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL) : LONG; stdcall;


  function TSPI_lineSecureCall(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL) : LONG; stdcall;


  function TSPI_lineSelectExtVersion(
      hdLine : HDRVLINE;
      dwExtVersion : DWORD) : LONG; stdcall;


  function TSPI_lineSendUserUserInfo(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpsUserUserInfo : LPCSTR;
      dwSize : DWORD) : LONG; stdcall;


  function TSPI_lineSetAppSpecific(
      hdCall : HDRVCALL;
      dwAppSpecific : DWORD) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineSetCallData(                                           // TSPI v2.0
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpCallData : LPVOID;
      dwSize : DWORD) : LONG; stdcall;
  {$ENDIF}


  function TSPI_lineSetCallParams(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      dwBearerMode : DWORD;
      dwMinRate : DWORD;
      dwMaxRate : DWORD;
      const lpDialParams : LPLINEDIALPARAMS) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineSetCallQualityOfService(                               // TSPI v2.0
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpSendingFlowspec : LPVOID;
      dwSendingFlowspecSize : DWORD;
      lpReceivingFlowspec : LPVOID;
      dwReceivingFlowspecSize : DWORD) : LONG; stdcall;


  function TSPI_lineSetCallTreatment(                                      // TSPI v2.0
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      dwTreatment : DWORD) : LONG; stdcall;
  {$ENDIF}


  function TSPI_lineSetCurrentLocation(
      dwLocation : DWORD) : LONG; stdcall;


  function TSPI_lineSetDefaultMediaDetection(
      hdLine : HDRVLINE;
      dwMediaModes : DWORD) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineSetDevConfig(
      dwDeviceID : DWORD;
      const lpDeviceConfig : LPVOID;
      dwSize : DWORD;
      lpszDeviceClass : LPCWSTR) : LONG; stdcall;
  {$ELSE}
  function TSPI_lineSetDevConfig(
      dwDeviceID : DWORD;
      const lpDeviceConfig : LPVOID;
      dwSize : DWORD;
      lpszDeviceClass : LPCSTR) : LONG; stdcall;
  {$ENDIF}


  {$IFDEF Tapi_Ver20}
  function TSPI_lineSetLineDevStatus(                                      // TSPI v2.0
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwStatusToChange : DWORD;
      fStatus : DWORD) : LONG; stdcall;
  {$ENDIF}


  function TSPI_lineSetMediaControl(
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      hdCall : HDRVCALL;
      dwSelect : DWORD;
      const lpDigitList : LPLINEMEDIACONTROLDIGIT;
      dwDigitNumEntries : DWORD;
      const lpMediaList : LPLINEMEDIACONTROLMEDIA;
      dwMediaNumEntries : DWORD;
      const lpToneList : LPLINEMEDIACONTROLTONE;
      dwToneNumEntries : DWORD;
      const lpCallStateList : LPLINEMEDIACONTROLCALLSTATE;
      dwCallStateNumEntries : DWORD) : LONG; stdcall;


  function TSPI_lineSetMediaMode(
      hdCall : HDRVCALL;
      dwMediaMode : DWORD) : LONG; stdcall;


  function TSPI_lineSetStatusMessages(
      hdLine : HDRVLINE;
      dwLineStates : DWORD;
      dwAddressStates : DWORD) : LONG; stdcall;


  function TSPI_lineSetTerminal(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      hdCall : HDRVCALL;
      dwSelect : DWORD;
      dwTerminalModes : DWORD;
      dwTerminalID : DWORD;
      bEnable : DWORD) : LONG; stdcall;


  function TSPI_lineSetupConference(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      hdLine : HDRVLINE;
      htConfCall : HTAPICALL;
      lphdConfCall : LPHDRVCALL;
      htConsultCall : HTAPICALL;
      lphdConsultCall : LPHDRVCALL;
      dwNumParties : DWORD;
      const lpCallParams : LPLINECALLPARAMS) : LONG; stdcall;


  function TSPI_lineSetupTransfer(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      htConsultCall : HTAPICALL;
      lphdConsultCall : LPHDRVCALL;
      const lpCallParams : LPLINECALLPARAMS) : LONG; stdcall;


  function TSPI_lineSwapHold(
      dwRequestID : TDRV_REQUESTID;
      hdActiveCall : HDRVCALL;
      hdHeldCall : HDRVCALL) : LONG; stdcall;


  function TSPI_lineUncompleteCall(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwCompletionID : DWORD) : LONG; stdcall;


  function TSPI_lineUnhold(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineUnpark(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      htCall : HTAPICALL;
      lphdCall : LPHDRVCALL;
      lpszDestAddress : LPCWSTR) : LONG; stdcall;
  {$ELSE}
  function TSPI_lineUnpark(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      htCall : HTAPICALL;
      lphdCall : LPHDRVCALL;
      lpszDestAddress : LPCSTR) : LONG; stdcall;
  {$ENDIF}


  {$IFNDEF Tapi_NoSupportPhone}

  function TSPI_phoneClose(
      hdPhone : HDRVPHONE) : LONG; stdcall;


  function TSPI_phoneDevSpecific(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      lpParams : LPVOID;
      dwSize : DWORD) : LONG; stdcall;


  function TSPI_phoneGetButtonInfo(
      hdPhone : HDRVPHONE;
      dwButtonLampID : DWORD;
      lpButtonInfo : LPPHONEBUTTONINFO) : LONG; stdcall;


  function TSPI_phoneGetData(
      hdPhone : HDRVPHONE;
      dwDataID : DWORD;
      lpData : LPVOID;
      dwSize : DWORD) : LONG; stdcall;


  function TSPI_phoneGetDevCaps(
      dwDeviceID : DWORD;
      dwTSPIVersion : DWORD;
      dwExtVersion : DWORD;
      lpPhoneCaps : LPPHONECAPS) : LONG; stdcall;


  function TSPI_phoneGetDisplay(
      hdPhone : HDRVPHONE;
      lpDisplay : LPVARSTRING) : LONG; stdcall;


  function TSPI_phoneGetExtensionID(
      dwDeviceID : DWORD;
      dwTSPIVersion : DWORD;
      lpExtensionID : LPPHONEEXTENSIONID) : LONG; stdcall;


  function TSPI_phoneGetGain(
      hdPhone : HDRVPHONE;
      dwHookSwitchDev : DWORD;
      lpdwGain : LPDWORD) : LONG; stdcall;


  function TSPI_phoneGetHookSwitch(
      hdPhone : HDRVPHONE;
      lpdwHookSwitchDevs : LPDWORD) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_phoneGetIcon(
      dwDeviceID : DWORD;
      lpszDeviceClass : LPCWSTR;
      lphIcon : LPHICON) : LONG; stdcall;
  {$ELSE}
  function TSPI_phoneGetIcon(
      dwDeviceID : DWORD;
      lpszDeviceClass : LPCSTR;
      lphIcon : LPHICON) : LONG; stdcall;
  {$ENDIF}


  {$IFDEF Tapi_Ver20}
  function TSPI_phoneGetID(
      hdPhone : HDRVPHONE;
      lpDeviceID : LPVARSTRING;
      lpszDeviceClass : LPCWSTR;
      hTargetProcess : THandle) : LONG; stdcall;                          // TSPI v2.0
  {$ELSE}
  function TSPI_phoneGetID(
      hdPhone : HDRVPHONE;
      lpDeviceID : LPVARSTRING;
      lpszDeviceClass : LPCSTR) : LONG; stdcall;
  {$ENDIF}


  function TSPI_phoneGetLamp(
      hdPhone : HDRVPHONE;
      dwButtonLampID : DWORD;
      lpdwLampMode : LPDWORD) : LONG; stdcall;


  function TSPI_phoneGetRing(
      hdPhone : HDRVPHONE;
      lpdwRingMode : LPDWORD;
      lpdwVolume : LPDWORD) : LONG; stdcall;


  function TSPI_phoneGetStatus(
      hdPhone : HDRVPHONE;
      lpPhoneStatus : LPPHONESTATUS) : LONG; stdcall;


  function TSPI_phoneGetVolume(
      hdPhone : HDRVPHONE;
      dwHookSwitchDev : DWORD;
      lpdwVolume : LPDWORD) : LONG; stdcall;


  function TSPI_phoneNegotiateExtVersion(
      dwDeviceID : DWORD;
      dwTSPIVersion : DWORD;
      dwLowVersion : DWORD;
      dwHighVersion : DWORD;
      lpdwExtVersion : LPDWORD) : LONG; stdcall;


  function TSPI_phoneNegotiateTSPIVersion(
      dwDeviceID : DWORD;
      dwLowVersion : DWORD;
      dwHighVersion : DWORD;
      lpdwTSPIVersion : LPDWORD) : LONG; stdcall;


  function TSPI_phoneOpen(
      dwDeviceID : DWORD;
      htPhone : HTAPIPHONE;
      lphdPhone : LPHDRVPHONE;
      dwTSPIVersion : DWORD;
      lpfnEventProc : TPHONEEVENT) : LONG; stdcall;


  function TSPI_phoneSelectExtVersion(
      hdPhone : HDRVPHONE;
      dwExtVersion : DWORD) : LONG; stdcall;


  function TSPI_phoneSetButtonInfo(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwButtonLampID : DWORD;
      const lpButtonInfo : LPPHONEBUTTONINFO) : LONG; stdcall;


  function TSPI_phoneSetData(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwDataID : DWORD;
      const lpData : LPVOID;
      dwSize : DWORD) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_phoneSetDisplay(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwRow : DWORD;
      dwColumn : DWORD;
      lpsDisplay : LPCWSTR;
      dwSize : DWORD) : LONG; stdcall;
  {$ELSE}
  function TSPI_phoneSetDisplay(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwRow : DWORD;
      dwColumn : DWORD;
      lpsDisplay : LPCSTR;
      dwSize : DWORD) : LONG; stdcall;
  {$ENDIF}


  function TSPI_phoneSetGain(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwHookSwitchDev : DWORD;
      dwGain : DWORD) : LONG; stdcall;


  function TSPI_phoneSetHookSwitch(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwHookSwitchDevs : DWORD;
      dwHookSwitchMode : DWORD) : LONG; stdcall;


  function TSPI_phoneSetLamp(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwButtonLampID : DWORD;
      dwLampMode : DWORD) : LONG; stdcall;


  function TSPI_phoneSetRing(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwRingMode : DWORD;
      dwVolume : DWORD) : LONG; stdcall;


  function TSPI_phoneSetStatusMessages(
      hdPhone : HDRVPHONE;
      dwPhoneStates : DWORD;
      dwButtonModes : DWORD;
      dwButtonStates : DWORD) : LONG; stdcall;


  function TSPI_phoneSetVolume(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwHookSwitchDev : DWORD;
      dwVolume : DWORD) : LONG; stdcall;

  {$ENDIF}

  
  function TSPI_providerCreateLineDevice(
      dwTempID : DWORD;
      dwDeviceID : DWORD) : LONG; stdcall;


  function TSPI_providerCreatePhoneDevice(
      dwTempID : DWORD;
      dwDeviceID : DWORD) : LONG; stdcall;


  function TSPI_providerEnumDevices(
      dwPermanentProviderID : DWORD;
      lpdwNumLines : LPDWORD;
      lpdwNumPhones : LPDWORD;
      hProvider : HPROVIDER;
      lpfnLineCreateProc : TLINEEVENT;
      lpfnPhoneCreateProc : TPHONEEVENT) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_providerFreeDialogInstance(                                // TSPI v2.0
      hdDlgInst : HDRVDIALOGINSTANCE) : LONG; stdcall;


  function TSPI_providerGenericDialogData(                                 // TSPI v2.0
      dwObjectID : DWORD;
      dwObjectType : DWORD;
      lpParams : LPVOID;
      dwSize : DWORD) : LONG; stdcall;
  {$ENDIF}


  function TSPI_providerInit(
      dwTSPIVersion : DWORD;
      dwPermanentProviderID : DWORD;
      dwLineDeviceIDBase : DWORD;
      dwPhoneDeviceIDBase : DWORD;
      dwNumLines : DWORD;
      dwNumPhones : DWORD;
      lpfnCompletionProc : TASYNC_COMPLETION
  {$IFDEF Tapi_Ver20}
      ;
      lpdwTSPIOptions : LPDWORD
  {$ENDIF}
      ) : LONG; stdcall;


  function TSPI_providerInstall(
      hwndOwner : HWND;
      dwPermanentProviderID : DWORD) : LONG; stdcall;


  function TSPI_providerRemove(
      hwndOwner : HWND;
      dwPermanentProviderID : DWORD) : LONG; stdcall;


  function TSPI_providerShutdown(
      dwTSPIVersion : DWORD
  {$IFDEF Tapi_Ver20}
      ;
      dwPermanentProviderID : DWORD                    // TSPI v2.0
  {$ENDIF}
      ) : LONG; stdcall;


  {$IFDEF Tapi_Ver20}
  function TSPI_providerUIIdentify(                                        // TSPI v2.0
      lpszUIDLLName : LPWSTR) : LONG; stdcall;
  {$ENDIF}



  {$IFDEF Tapi_Ver20}
  //
  // The following function prototypes pertain
  // to a service provider's UI module
  //


  function TUISPI_lineConfigDialog(                                        // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      dwDeviceID : DWORD;
      hwndOwner : HWND;
      lpszDeviceClass : LPCWSTR) : LONG; stdcall;


  function TUISPI_lineConfigDialogEdit(                                    // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      dwDeviceID : DWORD;
      hwndOwner : HWND;
      lpszDeviceClass : LPCWSTR;
      const lpDeviceConfigIn : LPVOID;
      dwSize : DWORD;
      lpDeviceConfigOut : LPVARSTRING) : LONG; stdcall;


  {$IFNDEF Tapi_NoSupportPhone}

  function TUISPI_phoneConfigDialog(                                       // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      dwDeviceID : DWORD;
      hwndOwner : HWND;
      lpszDeviceClass : LPCWSTR) : LONG; stdcall;

  {$ENDIF}

  function TUISPI_providerConfig(                                          // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      hwndOwner : HWND;
      dwPermanentProviderID : DWORD) : LONG; stdcall;


  function TUISPI_providerGenericDialog(                                   // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      htDlgInst : HTAPIDIALOGINSTANCE;
      lpParams : LPVOID;
      dwSize : DWORD;
      hEvent : THandle) : LONG; stdcall;


  function TUISPI_providerGenericDialogData(                               // TSPI v2.0
      htDlgInst : HTAPIDIALOGINSTANCE;
      lpParams : LPVOID;
      dwSize : DWORD) : LONG; stdcall;


  function TUISPI_providerInstall(                                         // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      hwndOwner : HWND;
      dwPermanentProviderID : DWORD) : LONG; stdcall;


  function TUISPI_providerRemove(                                          // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      hwndOwner : HWND;
      dwPermanentProviderID : DWORD) : LONG; stdcall;

  {$ELSE}

  { The following were obsoleted by the above (but are needed to build 1.4 SPs) }

  function TSPI_lineConfigDialog(
      dwDeviceID : DWORD;
      hwndOwner : HWND;
      lpszDeviceClass : LPCSTR) : LONG; stdcall;

  function TSPI_lineConfigDialogEdit(
      dwDeviceID : DWORD;
      hwndOwner : HWND;
      lpszDeviceClass : LPCSTR;
      const lpDeviceConfigIn : LPVOID;
      dwSize : DWORD;
      lpDeviceConfigOut : LPVARSTRING
  ) : LONG; stdcall;


  {$IFNDEF Tapi_NoSupportPhone}

  function TSPI_phoneConfigDialog(
      dwDeviceID : DWORD;
      hwndOwner : HWND;
      lpszDeviceClass : LPCSTR
  ) : LONG; stdcall;

  {$ENDIF}

  function TSPI_providerConfig(
      hwndOwner : HWND;
      dwPermanentProviderID : DWORD
  ) : LONG; stdcall;
  {$ENDIF}

{$ELSE} {!!-------------------Win16 compatibility-------------------}

  function TSPI_lineAccept(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpsUserUserInfo : LPCSTR;
      dwSize : DWORD) : LONG; export;


  function TSPI_lineAddToConference(
      dwRequestID : TDRV_REQUESTID;
      hdConfCall : HDRVCALL;
      hdConsultCall : HDRVCALL) : LONG; export;


  function TSPI_lineAnswer(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpsUserUserInfo : LPCSTR;
      dwSize : DWORD) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineBlindTransfer(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpszDestAddress : LPCWSTR;
      dwCountryCode : DWORD) : LONG; export;
  {$ELSE}
  function TSPI_lineBlindTransfer(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpszDestAddress : LPCSTR;
      dwCountryCode : DWORD) : LONG; export;
  {$ENDIF}


  function TSPI_lineClose(
      hdLine : HDRVLINE) : LONG; export;


  function TSPI_lineCloseCall(
      hdCall : HDRVCALL) : LONG; export;


  function TSPI_lineCompleteCall(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpdwCompletionID : LPDWORD;
      dwCompletionMode : DWORD;
      dwMessageID : DWORD) : LONG; export;


  function TSPI_lineCompleteTransfer(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      hdConsultCall : HDRVCALL;
      htConfCall : HTAPICALL;
      lphdConfCall : LPHDRVCALL;
      dwTransferMode : DWORD) : LONG; export;


  function TSPI_lineConditionalMediaDetection(
      hdLine : HDRVLINE;
      dwMediaModes : DWORD;
      const lpCallParams : LPLINECALLPARAMS) : LONG; export;


  function TSPI_lineDevSpecific(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      hdCall : HDRVCALL;
      lpParams : LPVOID;
      dwSize : DWORD) : LONG; export;


  function TSPI_lineDevSpecificFeature(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwFeature : DWORD;
      lpParams : LPVOID;
      dwSize : DWORD) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineDial(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpszDestAddress : LPCWSTR;
      dwCountryCode : DWORD) : LONG; export;
  {$ELSE}
  function TSPI_lineDial(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpszDestAddress : LPCSTR;
      dwCountryCode : DWORD) : LONG; export;
  {$ENDIF}


  function TSPI_lineDrop(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpsUserUserInfo : LPCSTR;
      dwSize : DWORD) : LONG; export;


  function TSPI_lineDropOnClose(
      hdCall : HDRVCALL) : LONG; export;


  function TSPI_lineDropNoOwner(
      hdCall : HDRVCALL) : LONG; export;


  function TSPI_lineForward(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      bAllAddresses : DWORD;
      dwAddressID : DWORD;
      const lpForwardList : LPLINEFORWARDLIST;
      dwNumRingsNoAnswer : DWORD;
      htConsultCall : HTAPICALL;
      lphdConsultCall : LPHDRVCALL;
      const lpCallParams : LPLINECALLPARAMS) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineGatherDigits(
      hdCall : HDRVCALL;
      dwEndToEndID : DWORD;
      dwDigitModes : DWORD;
      lpsDigits : LPWSTR;
      dwNumDigits : DWORD;
      lpszTerminationDigits : LPCWSTR;
      dwFirstDigitTimeout : DWORD;
      dwInterDigitTimeout : DWORD) : LONG; export;
  {$ELSE}
  function TSPI_lineGatherDigits(
      hdCall : HDRVCALL;
      dwEndToEndID : DWORD;
      dwDigitModes : DWORD;
      lpsDigits : LPSTR;
      dwNumDigits : DWORD;
      lpszTerminationDigits : LPCSTR;
      dwFirstDigitTimeout : DWORD;
      dwInterDigitTimeout : DWORD) : LONG; export;
  {$ENDIF}


  {$IFDEF Tapi_Ver20}
  function TSPI_lineGenerateDigits(
      hdCall : HDRVCALL;
      dwEndToEndID : DWORD;
      dwDigitMode : DWORD;
      lpszDigits : LPCWSTR;
      dwDuration : DWORD) : LONG; export;
  {$ELSE}
  function TSPI_lineGenerateDigits(
      hdCall : HDRVCALL;
      dwEndToEndID : DWORD;
      dwDigitMode : DWORD;
      lpszDigits : LPCSTR;
      dwDuration : DWORD) : LONG; export;
  {$ENDIF}


  function TSPI_lineGenerateTone(
      hdCall : HDRVCALL;
      dwEndToEndID : DWORD;
      dwToneMode : DWORD;
      dwDuration : DWORD;
      dwNumTones : DWORD;
      const lpTones : LPLINEGENERATETONE) : LONG; export;


  function TSPI_lineGetAddressCaps(
      dwDeviceID : DWORD;
      dwAddressID : DWORD;
      dwTSPIVersion : DWORD;
      dwExtVersion : DWORD;
      lpAddressCaps : LPLINEADDRESSCAPS) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineGetAddressID(
      hdLine : HDRVLINE;
      lpdwAddressID : LPDWORD;
      dwAddressMode : DWORD;
      lpsAddress : LPCWSTR;
      dwSize : DWORD) : LONG; export;
  {$ELSE}
  function TSPI_lineGetAddressID(
      hdLine : HDRVLINE;
      lpdwAddressID : LPDWORD;
      dwAddressMode : DWORD;
      lpsAddress : LPCSTR;
      dwSize : DWORD) : LONG; export;
  {$ENDIF}


  function TSPI_lineGetAddressStatus(
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      lpAddressStatus : LPLINEADDRESSSTATUS) : LONG; export;


  function TSPI_lineGetCallAddressID(
      hdCall : HDRVCALL;
      lpdwAddressID : LPDWORD) : LONG; export;


  function TSPI_lineGetCallInfo(
      hdCall : HDRVCALL;
      lpCallInfo : LPLINECALLINFO) : LONG; export;


  function TSPI_lineGetCallStatus(
      hdCall : HDRVCALL;
      lpCallStatus : LPLINECALLSTATUS) : LONG; export;


  function TSPI_lineGetDevCaps(
      dwDeviceID : DWORD;
      dwTSPIVersion : DWORD;
      dwExtVersion : DWORD;
      lpLineDevCaps : LPLINEDEVCAPS) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineGetDevConfig(
      dwDeviceID : DWORD;
      lpDeviceConfig : LPVARSTRING;
      lpszDeviceClass : LPCWSTR) : LONG; export;
  {$ELSE}
  function TSPI_lineGetDevConfig(
      dwDeviceID : DWORD;
      lpDeviceConfig : LPVARSTRING;
      lpszDeviceClass : LPCSTR) : LONG; export;
  {$ENDIF}


  function TSPI_lineGetExtensionID(
      dwDeviceID : DWORD;
      dwTSPIVersion : DWORD;
      lpExtensionID : LPLINEEXTENSIONID) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineGetIcon(
      dwDeviceID : DWORD;
      lpszDeviceClass : LPCWSTR;
      lphIcon : LPHICON) : LONG; export;
  {$ELSE}
  function TSPI_lineGetIcon(
      dwDeviceID : DWORD;
      lpszDeviceClass : LPCSTR;
      lphIcon : LPHICON) : LONG; export;
  {$ENDIF}


  {$IFDEF Tapi_Ver20}
  function TSPI_lineGetID(
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      hdCall : HDRVCALL;
      dwSelect : DWORD;
      lpDeviceID : LPVARSTRING;
      lpszDeviceClass : LPCWSTR;
      hTargetProcess : THandle) : LONG; export;                // TSPI v2.0
  {$ELSE}
  function TSPI_lineGetID(
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      hdCall : HDRVCALL;
      dwSelect : DWORD;
      lpDeviceID : LPVARSTRING;
      lpszDeviceClass : LPCSTR) : LONG; export;
  {$ENDIF}


  function TSPI_lineGetLineDevStatus(
      hdLine : HDRVLINE;
      lpLineDevStatus : LPLINEDEVSTATUS) : LONG; export;


  function TSPI_lineGetNumAddressIDs(
      hdLine : HDRVLINE;
      lpdwNumAddressIDs : LPDWORD) : LONG; export;


  function TSPI_lineHold(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineMakeCall(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      htCall : HTAPICALL;
      lphdCall : LPHDRVCALL;
      lpszDestAddress : LPCWSTR;
      dwCountryCode : DWORD;
      const lpCallParams : LPLINECALLPARAMS) : LONG; export;
  {$ELSE}
  function TSPI_lineMakeCall(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      htCall : HTAPICALL;
      lphdCall : LPHDRVCALL;
      lpszDestAddress : LPCSTR;
      dwCountryCode : DWORD;
      const lpCallParams : LPLINECALLPARAMS) : LONG; export;
  {$ENDIF}


  function TSPI_lineMonitorDigits(
      hdCall : HDRVCALL;
      dwDigitModes : DWORD) : LONG; export;


  function TSPI_lineMonitorMedia(
      hdCall : HDRVCALL;
      dwMediaModes : DWORD) : LONG; export;


  function TSPI_lineMonitorTones(
      hdCall : HDRVCALL;
      dwToneListID : DWORD;
      const lpToneList : LPLINEMONITORTONE;
      dwNumEntries : DWORD) : LONG; export;


  function TSPI_lineNegotiateExtVersion(
      dwDeviceID : DWORD;
      dwTSPIVersion : DWORD;
      dwLowVersion : DWORD;
      dwHighVersion : DWORD;
      lpdwExtVersion : LPDWORD) : LONG; export;


  function TSPI_lineNegotiateTSPIVersion(
      dwDeviceID : DWORD;
      dwLowVersion : DWORD;
      dwHighVersion : DWORD;
      lpdwTSPIVersion : LPDWORD) : LONG; export;


  function TSPI_lineOpen(
      dwDeviceID : DWORD;
      htLine : HTAPILINE;
      lphdLine : LPHDRVLINE;
      dwTSPIVersion : DWORD;
      lpfnEventProc : TLINEEVENT) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_linePark(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      dwParkMode : DWORD;
      lpszDirAddress : LPCWSTR;
      lpNonDirAddress : LPVARSTRING) : LONG; export;
  {$ELSE}
  function TSPI_linePark(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      dwParkMode : DWORD;
      lpszDirAddress : LPCSTR;
      lpNonDirAddress : LPVARSTRING) : LONG; export;
  {$ENDIF}


  {$IFDEF Tapi_Ver20}
  function TSPI_linePickup(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      htCall : HTAPICALL;
      lphdCall : LPHDRVCALL;
      lpszDestAddress : LPCWSTR;
      lpszGroupID : LPCWSTR) : LONG; export;
  {$ELSE}
  function TSPI_linePickup(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      htCall : HTAPICALL;
      lphdCall : LPHDRVCALL;
      lpszDestAddress : LPCSTR;
      lpszGroupID : LPCSTR) : LONG; export;
  {$ENDIF}


  function TSPI_linePrepareAddToConference(
      dwRequestID : TDRV_REQUESTID;
      hdConfCall : HDRVCALL;
      htConsultCall : HTAPICALL;
      lphdConsultCall : LPHDRVCALL;
      const lpCallParams : LPLINECALLPARAMS) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineRedirect(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpszDestAddress : LPCWSTR;
      dwCountryCode : DWORD) : LONG; export;
  {$ELSE}
  function TSPI_lineRedirect(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpszDestAddress : LPCSTR;
      dwCountryCode : DWORD) : LONG; export;
  {$ENDIF}


  function TSPI_lineReleaseUserUserInfo(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL) : LONG; export;


  function TSPI_lineRemoveFromConference(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL) : LONG; export;


  function TSPI_lineSecureCall(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL) : LONG; export;


  function TSPI_lineSelectExtVersion(
      hdLine : HDRVLINE;
      dwExtVersion : DWORD) : LONG; export;


  function TSPI_lineSendUserUserInfo(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpsUserUserInfo : LPCSTR;
      dwSize : DWORD) : LONG; export;


  function TSPI_lineSetAppSpecific(
      hdCall : HDRVCALL;
      dwAppSpecific : DWORD) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineSetCallData(                                           // TSPI v2.0
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpCallData : LPVOID;
      dwSize : DWORD) : LONG; export;
  {$ENDIF}


  function TSPI_lineSetCallParams(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      dwBearerMode : DWORD;
      dwMinRate : DWORD;
      dwMaxRate : DWORD;
      const lpDialParams : LPLINEDIALPARAMS) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineSetCallQualityOfService(                               // TSPI v2.0
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      lpSendingFlowspec : LPVOID;
      dwSendingFlowspecSize : DWORD;
      lpReceivingFlowspec : LPVOID;
      dwReceivingFlowspecSize : DWORD) : LONG; export;


  function TSPI_lineSetCallTreatment(                                      // TSPI v2.0
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      dwTreatment : DWORD) : LONG; export;
  {$ENDIF}


  function TSPI_lineSetCurrentLocation(
      dwLocation : DWORD) : LONG; export;


  function TSPI_lineSetDefaultMediaDetection(
      hdLine : HDRVLINE;
      dwMediaModes : DWORD) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineSetDevConfig(
      dwDeviceID : DWORD;
      const lpDeviceConfig : LPVOID;
      dwSize : DWORD;
      lpszDeviceClass : LPCWSTR) : LONG; export;
  {$ELSE}
  function TSPI_lineSetDevConfig(
      dwDeviceID : DWORD;
      const lpDeviceConfig : LPVOID;
      dwSize : DWORD;
      lpszDeviceClass : LPCSTR) : LONG; export;
  {$ENDIF}


  {$IFDEF Tapi_Ver20}
  function TSPI_lineSetLineDevStatus(                                      // TSPI v2.0
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwStatusToChange : DWORD;
      fStatus : DWORD) : LONG; export;
  {$ENDIF}


  function TSPI_lineSetMediaControl(
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      hdCall : HDRVCALL;
      dwSelect : DWORD;
      const lpDigitList : LPLINEMEDIACONTROLDIGIT;
      dwDigitNumEntries : DWORD;
      const lpMediaList : LPLINEMEDIACONTROLMEDIA;
      dwMediaNumEntries : DWORD;
      const lpToneList : LPLINEMEDIACONTROLTONE;
      dwToneNumEntries : DWORD;
      const lpCallStateList : LPLINEMEDIACONTROLCALLSTATE;
      dwCallStateNumEntries : DWORD) : LONG; export;


  function TSPI_lineSetMediaMode(
      hdCall : HDRVCALL;
      dwMediaMode : DWORD) : LONG; export;


  function TSPI_lineSetStatusMessages(
      hdLine : HDRVLINE;
      dwLineStates : DWORD;
      dwAddressStates : DWORD) : LONG; export;


  function TSPI_lineSetTerminal(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      hdCall : HDRVCALL;
      dwSelect : DWORD;
      dwTerminalModes : DWORD;
      dwTerminalID : DWORD;
      bEnable : DWORD) : LONG; export;


  function TSPI_lineSetupConference(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      hdLine : HDRVLINE;
      htConfCall : HTAPICALL;
      lphdConfCall : LPHDRVCALL;
      htConsultCall : HTAPICALL;
      lphdConsultCall : LPHDRVCALL;
      dwNumParties : DWORD;
      const lpCallParams : LPLINECALLPARAMS) : LONG; export;


  function TSPI_lineSetupTransfer(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL;
      htConsultCall : HTAPICALL;
      lphdConsultCall : LPHDRVCALL;
      const lpCallParams : LPLINECALLPARAMS) : LONG; export;


  function TSPI_lineSwapHold(
      dwRequestID : TDRV_REQUESTID;
      hdActiveCall : HDRVCALL;
      hdHeldCall : HDRVCALL) : LONG; export;


  function TSPI_lineUncompleteCall(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwCompletionID : DWORD) : LONG; export;


  function TSPI_lineUnhold(
      dwRequestID : TDRV_REQUESTID;
      hdCall : HDRVCALL) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_lineUnpark(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      htCall : HTAPICALL;
      lphdCall : LPHDRVCALL;
      lpszDestAddress : LPCWSTR) : LONG; export;
  {$ELSE}
  function TSPI_lineUnpark(
      dwRequestID : TDRV_REQUESTID;
      hdLine : HDRVLINE;
      dwAddressID : DWORD;
      htCall : HTAPICALL;
      lphdCall : LPHDRVCALL;
      lpszDestAddress : LPCSTR) : LONG; export;
  {$ENDIF}

  {$IFNDEF Tapi_NoSupportPhone}

  function TSPI_phoneClose(
      hdPhone : HDRVPHONE) : LONG; export;


  function TSPI_phoneDevSpecific(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      lpParams : LPVOID;
      dwSize : DWORD) : LONG; export;


  function TSPI_phoneGetButtonInfo(
      hdPhone : HDRVPHONE;
      dwButtonLampID : DWORD;
      lpButtonInfo : LPPHONEBUTTONINFO) : LONG; export;


  function TSPI_phoneGetData(
      hdPhone : HDRVPHONE;
      dwDataID : DWORD;
      lpData : LPVOID;
      dwSize : DWORD) : LONG; export;


  function TSPI_phoneGetDevCaps(
      dwDeviceID : DWORD;
      dwTSPIVersion : DWORD;
      dwExtVersion : DWORD;
      lpPhoneCaps : LPPHONECAPS) : LONG; export;


  function TSPI_phoneGetDisplay(
      hdPhone : HDRVPHONE;
      lpDisplay : LPVARSTRING) : LONG; export;


  function TSPI_phoneGetExtensionID(
      dwDeviceID : DWORD;
      dwTSPIVersion : DWORD;
      lpExtensionID : LPPHONEEXTENSIONID) : LONG; export;


  function TSPI_phoneGetGain(
      hdPhone : HDRVPHONE;
      dwHookSwitchDev : DWORD;
      lpdwGain : LPDWORD) : LONG; export;


  function TSPI_phoneGetHookSwitch(
      hdPhone : HDRVPHONE;
      lpdwHookSwitchDevs : LPDWORD) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_phoneGetIcon(
      dwDeviceID : DWORD;
      lpszDeviceClass : LPCWSTR;
      lphIcon : LPHICON) : LONG; export;
  {$ELSE}
  function TSPI_phoneGetIcon(
      dwDeviceID : DWORD;
      lpszDeviceClass : LPCSTR;
      lphIcon : LPHICON) : LONG; export;
  {$ENDIF}


  {$IFDEF Tapi_Ver20}
  function TSPI_phoneGetID(
      hdPhone : HDRVPHONE;
      lpDeviceID : LPVARSTRING;
      lpszDeviceClass : LPCWSTR;
      hTargetProcess : THandle) : LONG; export;                          // TSPI v2.0
  {$ELSE}
  function TSPI_phoneGetID(
      hdPhone : HDRVPHONE;
      lpDeviceID : LPVARSTRING;
      lpszDeviceClass : LPCSTR) : LONG; export;
  {$ENDIF}


  function TSPI_phoneGetLamp(
      hdPhone : HDRVPHONE;
      dwButtonLampID : DWORD;
      lpdwLampMode : LPDWORD) : LONG; export;


  function TSPI_phoneGetRing(
      hdPhone : HDRVPHONE;
      lpdwRingMode : LPDWORD;
      lpdwVolume : LPDWORD) : LONG; export;


  function TSPI_phoneGetStatus(
      hdPhone : HDRVPHONE;
      lpPhoneStatus : LPPHONESTATUS) : LONG; export;


  function TSPI_phoneGetVolume(
      hdPhone : HDRVPHONE;
      dwHookSwitchDev : DWORD;
      lpdwVolume : LPDWORD) : LONG; export;


  function TSPI_phoneNegotiateExtVersion(
      dwDeviceID : DWORD;
      dwTSPIVersion : DWORD;
      dwLowVersion : DWORD;
      dwHighVersion : DWORD;
      lpdwExtVersion : LPDWORD) : LONG; export;


  function TSPI_phoneNegotiateTSPIVersion(
      dwDeviceID : DWORD;
      dwLowVersion : DWORD;
      dwHighVersion : DWORD;
      lpdwTSPIVersion : LPDWORD) : LONG; export;


  function TSPI_phoneOpen(
      dwDeviceID : DWORD;
      htPhone : HTAPIPHONE;
      lphdPhone : LPHDRVPHONE;
      dwTSPIVersion : DWORD;
      lpfnEventProc : TPHONEEVENT) : LONG; export;


  function TSPI_phoneSelectExtVersion(
      hdPhone : HDRVPHONE;
      dwExtVersion : DWORD) : LONG; export;


  function TSPI_phoneSetButtonInfo(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwButtonLampID : DWORD;
      const lpButtonInfo : LPPHONEBUTTONINFO) : LONG; export;


  function TSPI_phoneSetData(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwDataID : DWORD;
      const lpData : LPVOID;
      dwSize : DWORD) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_phoneSetDisplay(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwRow : DWORD;
      dwColumn : DWORD;
      lpsDisplay : LPCWSTR;
      dwSize : DWORD) : LONG; export;
  {$ELSE}
  function TSPI_phoneSetDisplay(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwRow : DWORD;
      dwColumn : DWORD;
      lpsDisplay : LPCSTR;
      dwSize : DWORD) : LONG; export;
  {$ENDIF}


  function TSPI_phoneSetGain(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwHookSwitchDev : DWORD;
      dwGain : DWORD) : LONG; export;


  function TSPI_phoneSetHookSwitch(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwHookSwitchDevs : DWORD;
      dwHookSwitchMode : DWORD) : LONG; export;


  function TSPI_phoneSetLamp(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwButtonLampID : DWORD;
      dwLampMode : DWORD) : LONG; export;


  function TSPI_phoneSetRing(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwRingMode : DWORD;
      dwVolume : DWORD) : LONG; export;


  function TSPI_phoneSetStatusMessages(
      hdPhone : HDRVPHONE;
      dwPhoneStates : DWORD;
      dwButtonModes : DWORD;
      dwButtonStates : DWORD) : LONG; export;


  function TSPI_phoneSetVolume(
      dwRequestID : TDRV_REQUESTID;
      hdPhone : HDRVPHONE;
      dwHookSwitchDev : DWORD;
      dwVolume : DWORD) : LONG; export;

  {$ENDIF}


  function TSPI_providerCreateLineDevice(
      dwTempID : DWORD;
      dwDeviceID : DWORD) : LONG; export;


  function TSPI_providerCreatePhoneDevice(
      dwTempID : DWORD;
      dwDeviceID : DWORD) : LONG; export;


  function TSPI_providerEnumDevices(
      dwPermanentProviderID : DWORD;
      lpdwNumLines : LPDWORD;
      lpdwNumPhones : LPDWORD;
      hProvider : HPROVIDER;
      lpfnLineCreateProc : TLINEEVENT;
      lpfnPhoneCreateProc : TPHONEEVENT) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_providerFreeDialogInstance(                                // TSPI v2.0
      hdDlgInst : HDRVDIALOGINSTANCE) : LONG; export;


  function TSPI_providerGenericDialogData(                                 // TSPI v2.0
      dwObjectID : DWORD;
      dwObjectType : DWORD;
      lpParams : LPVOID;
      dwSize : DWORD) : LONG; export;
  {$ENDIF}


  function TSPI_providerInit(
      dwTSPIVersion : DWORD;
      dwPermanentProviderID : DWORD;
      dwLineDeviceIDBase : DWORD;
      dwPhoneDeviceIDBase : DWORD;
      dwNumLines : DWORD;
      dwNumPhones : DWORD;
      lpfnCompletionProc : TASYNC_COMPLETION
  {$IFDEF Tapi_Ver20}
      ;
      lpdwTSPIOptions : LPDWORD
  {$ENDIF}
      ) : LONG; export;


  function TSPI_providerInstall(
      hwndOwner : HWND;
      dwPermanentProviderID : DWORD) : LONG; export;


  function TSPI_providerRemove(
      hwndOwner : HWND;
      dwPermanentProviderID : DWORD) : LONG; export;


  function TSPI_providerShutdown(
      dwTSPIVersion : DWORD
  {$IFDEF Tapi_Ver20}
      ;
      dwPermanentProviderID : DWORD                    // TSPI v2.0
  {$ENDIF}
      ) : LONG; export;


  {$IFDEF Tapi_Ver20}
  function TSPI_providerUIIdentify(                                        // TSPI v2.0
      lpszUIDLLName : LPWSTR) : LONG; export;
  {$ENDIF}



  {$IFDEF Tapi_Ver20}
  //
  // The following function prototypes pertain
  // to a service provider's UI module
  //


  function TUISPI_lineConfigDialog(                                        // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      dwDeviceID : DWORD;
      hwndOwner : HWND;
      lpszDeviceClass : LPCWSTR) : LONG; export;


  function TUISPI_lineConfigDialogEdit(                                    // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      dwDeviceID : DWORD;
      hwndOwner : HWND;
      lpszDeviceClass : LPCWSTR;
      const lpDeviceConfigIn : LPVOID;
      dwSize : DWORD;
      lpDeviceConfigOut : LPVARSTRING) : LONG; export;


  {$IFNDEF Tapi_NoSupportPhone}

  function TUISPI_phoneConfigDialog(                                       // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      dwDeviceID : DWORD;
      hwndOwner : HWND;
      lpszDeviceClass : LPCWSTR) : LONG; export;

  {$ENDIF}


  function TUISPI_providerConfig(                                          // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      hwndOwner : HWND;
      dwPermanentProviderID : DWORD) : LONG; export;


  function TUISPI_providerGenericDialog(                                   // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      htDlgInst : HTAPIDIALOGINSTANCE;
      lpParams : LPVOID;
      dwSize : DWORD;
      hEvent : THandle) : LONG; export;


  function TUISPI_providerGenericDialogData(                               // TSPI v2.0
      htDlgInst : HTAPIDIALOGINSTANCE;
      lpParams : LPVOID;
      dwSize : DWORD) : LONG; export;


  function TUISPI_providerInstall(                                         // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      hwndOwner : HWND;
      dwPermanentProviderID : DWORD) : LONG; export;


  function TUISPI_providerRemove(                                          // TSPI v2.0
      lpfnUIDLLCallback : TUISPIDLLCALLBACK;
      hwndOwner : HWND;
      dwPermanentProviderID : DWORD) : LONG; export;

  {$ELSE}

  { The following were obsoleted by the above (but are needed to build 1.4 SPs) }

  function TSPI_lineConfigDialog(
      dwDeviceID : DWORD;
      hwndOwner : HWND;
      lpszDeviceClass : LPCSTR) : LONG; export;

  function TSPI_lineConfigDialogEdit(
      dwDeviceID : DWORD;
      hwndOwner : HWND;
      lpszDeviceClass : LPCSTR;
      const lpDeviceConfigIn : LPVOID;
      dwSize : DWORD;
      lpDeviceConfigOut : LPVARSTRING
  ) : LONG; export;

  {$IFNDEF Tapi_NoSupportPhone}

  function TSPI_phoneConfigDialog(
      dwDeviceID : DWORD;
      hwndOwner : HWND;
      lpszDeviceClass : LPCSTR
  ) : LONG; export;

  {$ENDIF}

  function TSPI_providerConfig(
      hwndOwner : HWND;
      dwPermanentProviderID : DWORD
  ) : LONG; export;
  {$ENDIF}

{$ENDIF}

