{++

  TAPI Support Kit for Delphi
  Version 3.0  Copyright (c) 1995-1997 by Alexander Staubo

  TAPI Service Provicer Interface (TSPI) definitions and function imports.
  For detailed notes see tapih.pas.


  Conditional Compiler Defines
  ----------------------------

     Tapi_Ver20 and        See tapih.pas
     Tapi_Ver14

     Tapi_NoPhoneSupport   Omits support for phone functions.


  Notes About Writing Service Providers
  -------------------------------------
  Server provider function headers have been moved into a separate
  file called tspi.inc, and the export declaration for a complete TSP in
  a file called tspiexp.inc.

  Service providers should use these files in the following manner:

  ---mytapi.dpr---

    library Mytapi;

    (* This is the TSP project file *)

    uses
      Tapi, Tspi, Mytapi2;

    {$I tspiexp.inc)   { Exports )

    begin
    end.

  ---mytapi2.pas---

    unit Mytapi2;

    interface

    (* This is the TSP implementation *)

    uses
      Tapi, Tspi;

    {$I tspi.inc)   { Function headers )

    implementation

    .
    .
    .
    actual TSP function implementations here
    .
    .
    .

    end.

  Note that Tapi_Ver20 is used to determine whether the compiled TSP is a
  version 2.0 TSP or not. (TAPI 2.0 under NT 4.0 supports 32-bit TSPs only.
  TAPI 1.4 under Windows95 requires that the TSP is 16-bit.)

    * To compile a 16-bit TAPI 1.4-compliant TSP, add Tapi_Ver14 to the
      list of conditional defines under Options|Project and compile
      the project with Delphi 1.x.

    * To compile a 32-bit TAPI 2.0-compliant TSP, no define is necessary
      (the define Tapi_Ver20 is enabled by default). Tapi_Ver14 cannot
      be defined. Compile the project with Delphi 2.0.


  Note about API compliance
  -------------------------
  If your TSP will support only a subset of the full TSPI, you should not use
  tspiexp.inc to export your TSP functions. You should instead copy selected
  functions from this file and insert into your project file, like so:

    exports
      lineOpen,
      lineClose;

  You will have to extract the selected functions from tspi.inc into
  your implementation file, as well.

  For TSPs which will implement all line functions, but no phone functions,
  you can add the define Tapi_NoSupportPhone to your project. This will omit
  phone functions from being declared/compiled.

 --}

{ Include definitions }
{$I tapidef.inc }

unit Tspih;

interface

(*++ BUILD Version: 0000    { Increment this if a change has global effects }

The  Telephony  API  is jointly copyrighted by Intel and Microsoft.  You are
granted  a royalty free worldwide, unlimited license to make copies, and use
the   API/SPI  for  making  applications/drivers  that  interface  with  the
specification provided that this paragraph and the Intel/Microsoft copyright
statement is maintained as is in the text and source code files.

Copyright (c) 1992-1996  Microsoft Corporation
Portions copyright 1992, 1993 Intel/Microsoft, all rights reserved.

Module Name:

    tspi.h

Notes:

    Additions to the Telephony Service Provider Interface (TSPI) since
    version 1.0 are noted by version number (i.e. "TSPI v1.4").

--*)

{$IFDEF WIN32}
  {$IFNDEF Tapi_Ver20}
    !!  { Building a 32-bit 1.3 or 1.4 service provider is not supported }
  {$ENDIF}
{$ENDIF}

uses
  {$IFDEF Win32}
  Windows,
  {$ELSE}
  WinProcs, WinTypes,
  {$ENDIF}
  Tapih;

{ tspi.h  is  only  of  use  in  conjunction  with tapi.h.  Very few types are }
{ defined  in  tspi.h.   Most  types of procedure formal parameters are simply }
{ passed through from corresponding procedures in tapi.h.  A working knowledge }
{ of the TAPI interface is required for an understanding of this interface. }

type
  HDRVCALL__ =
    record
      unused : INT;
    end;
  HDRVCALL = ^HDRVCALL__;
  LPHDRVCALL = ^HDRVCALL;

  HDRVLINE__ =
    record
      unused : INT;
    end;
  HDRVLINE = ^HDRVLINE__;
  LPHDRVLINE = ^HDRVLINE;

  HDRVPHONE__ =
    record
      unused : INT;
    end;
  HDRVPHONE = ^HDRVPHONE__;
  LPHDRVPHONE = ^HDRVPHONE;

  HDRVDIALOGINSTANCE__ =
    record
      unused : INT;
    end;
  HDRVDIALOGINSTANCE = ^HDRVDIALOGINSTANCE__;
  LPHDRVDIALOGINSTANCE = ^HDRVDIALOGINSTANCE;

  HTAPICALL__ =
    record
      unused : INT;
    end;
  HTAPICALL = ^HTAPICALL__;
  LPHTAPICALL = ^HTAPICALL;

  HTAPILINE__ =
    record
      unused : INT;
    end;
  HTAPILINE = ^HTAPILINE__;
  LPHTAPILINE = ^HTAPILINE;

  HTAPIPHONE__ =
    record
      unused : INT;
    end;
  HTAPIPHONE = ^HTAPIPHONE__;
  LPHTAPIPHONE = ^HTAPIPHONE;

  HTAPIDIALOGINSTANCE__ =
    record
      unused : INT;
    end;
  HTAPIDIALOGINSTANCE = ^HTAPIDIALOGINSTANCE__;
  LPHTAPIDIALOGINSTANCE = ^HTAPIDIALOGINSTANCE;

  HPROVIDER__ =
    record
      unused : INT;
    end;
  HPROVIDER = ^HPROVIDER__;
  LPHPROVIDER = ^HPROVIDER;

  TDRV_REQUESTID = DWORD;

  TASYNC_COMPLETION = procedure (dwRequestID : TDRV_REQUESTID;
                                 lResult : LONG);
                                 {$IFDEF Win32}
                                 stdcall;
                                 {$ENDIF}

  TLINEEVENT = procedure (htLine : HTAPILINE;
                          htCall : HTAPICALL;
                          dwMsg : DWORD;
                          dwParam1 : DWORD;
                          dwParam2 : DWORD;
                          dwParam3 : DWORD);
                          {$IFDEF Win32}
                          stdcall;
                          {$ENDIF}

  TPHONEEVENT = procedure (htPhone : HTAPIPHONE;
                           dwMsg : DWORD;
                           dwParam1 : DWORD;
                           dwParam2 : DWORD;
                           dwParam3 : DWORD);
                           {$IFDEF Win32}
                           stdcall;
                           {$ENDIF}

  TUISPIDLLCALLBACK = procedure (dwObjectID : DWORD;
                                 dwObjectType : DWORD;
                                 lpParams : LPVOID;
                                 dwSize : DWORD);
                                 {$IFDEF Win32}
                                 stdcall;
                                 {$ENDIF}

{$IFDEF Tapi_Ver20}
  LPUISPICREATEDIALOGINSTANCEPARAMS = ^TUISPICREATEDIALOGINSTANCEPARAMS;
  PUISPICREATEDIALOGINSTANCEPARAMS = ^TUISPICREATEDIALOGINSTANCEPARAMS;
  TUISPICREATEDIALOGINSTANCEPARAMS =
    record
      dwRequestID : TDRV_REQUESTID;

      hdDlgInst : HDRVDIALOGINSTANCE;

      htDlgInst : HTAPIDIALOGINSTANCE;

      lpszUIDLLName : LPCWSTR;

      lpParams : LPVOID;

      dwSize : DWORD;
    end;
{$ENDIF}

const
  TSPI_MESSAGE_BASE = 500;
    { The lowest-numbered TSPI-specific message ID number }

  LINE_NEWCALL                            = (TSPI_MESSAGE_BASE + 0);
  LINE_CALLDEVSPECIFIC                    = (TSPI_MESSAGE_BASE + 1);
  LINE_CALLDEVSPECIFICFEATURE             = (TSPI_MESSAGE_BASE + 2);
{$IFDEF Tapi_Ver20}
  LINE_CREATEDIALOGINSTANCE               = (TSPI_MESSAGE_BASE + 3);
                                                                { TSPI v2.0 }
  LINE_SENDDIALOGINSTANCEDATA             = (TSPI_MESSAGE_BASE + 4);
                                                                { TSPI v2.0 }
{$ENDIF}


{$IFDEF Tapi_Ver20}
  LINETSPIOPTION_NONREENTRANT             = $00000001;      { TSPI v2.0 }
{$ENDIF}


{$IFDEF Tapi_Ver20}
  TUISPIDLL_OBJECT_LINEID                 = 1;              { TSPI v2.0 }
  TUISPIDLL_OBJECT_PHONEID                = 2;              { TSPI v2.0 }
  TUISPIDLL_OBJECT_PROVIDERID             = 3;              { TSPI v2.0 }
  TUISPIDLL_OBJECT_DIALOGINSTANCE         = 4;              { TSPI v2.0 }
{$ENDIF}



{ The following function prototypes pertain }
{ to a service provider's core module }


{!! TSPI_ and TUISPI_ functions are moved to tspi.inc }


{$IFNDEF Tapi_Ver20}


{ The following macros are the ordinal numbers of the exported tspi functions }

{!! Underscore prefix added to each of these constants, to avoid them
    interfering with TSPI function names }


const
  TSPI_PROC_BASE                      = 500;

  _TSPI_LINEACCEPT                     = (TSPI_PROC_BASE + 0);
  _TSPI_LINEADDTOCONFERENCE            = (TSPI_PROC_BASE + 1);
  _TSPI_LINEANSWER                     = (TSPI_PROC_BASE + 2);
  _TSPI_LINEBLINDTRANSFER              = (TSPI_PROC_BASE + 3);
  _TSPI_LINECLOSE                      = (TSPI_PROC_BASE + 4);
  _TSPI_LINECLOSECALL                  = (TSPI_PROC_BASE + 5);
  _TSPI_LINECOMPLETECALL               = (TSPI_PROC_BASE + 6);
  _TSPI_LINECOMPLETETRANSFER           = (TSPI_PROC_BASE + 7);
  _TSPI_LINECONDITIONALMEDIADETECTION  = (TSPI_PROC_BASE + 8);
  _TSPI_LINECONFIGDIALOG               = (TSPI_PROC_BASE + 9);
  _TSPI_LINEDEVSPECIFIC                = (TSPI_PROC_BASE + 10);
  _TSPI_LINEDEVSPECIFICFEATURE         = (TSPI_PROC_BASE + 11);
  _TSPI_LINEDIAL                       = (TSPI_PROC_BASE + 12);
  _TSPI_LINEDROP                       = (TSPI_PROC_BASE + 13);
  _TSPI_LINEFORWARD                    = (TSPI_PROC_BASE + 14);
  _TSPI_LINEGATHERDIGITS               = (TSPI_PROC_BASE + 15);
  _TSPI_LINEGENERATEDIGITS             = (TSPI_PROC_BASE + 16);
  _TSPI_LINEGENERATETONE               = (TSPI_PROC_BASE + 17);
  _TSPI_LINEGETADDRESSCAPS             = (TSPI_PROC_BASE + 18);
  _TSPI_LINEGETADDRESSID               = (TSPI_PROC_BASE + 19);
  _TSPI_LINEGETADDRESSSTATUS           = (TSPI_PROC_BASE + 20);
  _TSPI_LINEGETCALLADDRESSID           = (TSPI_PROC_BASE + 21);
  _TSPI_LINEGETCALLINFO                = (TSPI_PROC_BASE + 22);
  _TSPI_LINEGETCALLSTATUS              = (TSPI_PROC_BASE + 23);
  _TSPI_LINEGETDEVCAPS                 = (TSPI_PROC_BASE + 24);
  _TSPI_LINEGETDEVCONFIG               = (TSPI_PROC_BASE + 25);
  _TSPI_LINEGETEXTENSIONID             = (TSPI_PROC_BASE + 26);
  _TSPI_LINEGETICON                    = (TSPI_PROC_BASE + 27);
  _TSPI_LINEGETID                      = (TSPI_PROC_BASE + 28);
  _TSPI_LINEGETLINEDEVSTATUS           = (TSPI_PROC_BASE + 29);
  _TSPI_LINEGETNUMADDRESSIDS           = (TSPI_PROC_BASE + 30);
  _TSPI_LINEHOLD                       = (TSPI_PROC_BASE + 31);
  _TSPI_LINEMAKECALL                   = (TSPI_PROC_BASE + 32);
  _TSPI_LINEMONITORDIGITS              = (TSPI_PROC_BASE + 33);
  _TSPI_LINEMONITORMEDIA               = (TSPI_PROC_BASE + 34);
  _TSPI_LINEMONITORTONES               = (TSPI_PROC_BASE + 35);
  _TSPI_LINENEGOTIATEEXTVERSION        = (TSPI_PROC_BASE + 36);
  _TSPI_LINENEGOTIATETSPIVERSION       = (TSPI_PROC_BASE + 37);
  _TSPI_LINEOPEN                       = (TSPI_PROC_BASE + 38);
  _TSPI_LINEPARK                       = (TSPI_PROC_BASE + 39);
  _TSPI_LINEPICKUP                     = (TSPI_PROC_BASE + 40);
  _TSPI_LINEPREPAREADDTOCONFERENCE     = (TSPI_PROC_BASE + 41);
  _TSPI_LINEREDIRECT                   = (TSPI_PROC_BASE + 42);
  _TSPI_LINEREMOVEFROMCONFERENCE       = (TSPI_PROC_BASE + 43);
  _TSPI_LINESECURECALL                 = (TSPI_PROC_BASE + 44);
  _TSPI_LINESELECTEXTVERSION           = (TSPI_PROC_BASE + 45);
  _TSPI_LINESENDUSERUSERINFO           = (TSPI_PROC_BASE + 46);
  _TSPI_LINESETAPPSPECIFIC             = (TSPI_PROC_BASE + 47);
  _TSPI_LINESETCALLPARAMS              = (TSPI_PROC_BASE + 48);
  _TSPI_LINESETDEFAULTMEDIADETECTION   = (TSPI_PROC_BASE + 49);
  _TSPI_LINESETDEVCONFIG               = (TSPI_PROC_BASE + 50);
  _TSPI_LINESETMEDIACONTROL            = (TSPI_PROC_BASE + 51);
  _TSPI_LINESETMEDIAMODE               = (TSPI_PROC_BASE + 52);
  _TSPI_LINESETSTATUSMESSAGES          = (TSPI_PROC_BASE + 53);
  _TSPI_LINESETTERMINAL                = (TSPI_PROC_BASE + 54);
  _TSPI_LINESETUPCONFERENCE            = (TSPI_PROC_BASE + 55);
  _TSPI_LINESETUPTRANSFER              = (TSPI_PROC_BASE + 56);
  _TSPI_LINESWAPHOLD                   = (TSPI_PROC_BASE + 57);
  _TSPI_LINEUNCOMPLETECALL             = (TSPI_PROC_BASE + 58);
  _TSPI_LINEUNHOLD                     = (TSPI_PROC_BASE + 59);
  _TSPI_LINEUNPARK                     = (TSPI_PROC_BASE + 60);
  _TSPI_PHONECLOSE                     = (TSPI_PROC_BASE + 61);
  _TSPI_PHONECONFIGDIALOG              = (TSPI_PROC_BASE + 62);
  _TSPI_PHONEDEVSPECIFIC               = (TSPI_PROC_BASE + 63);
  _TSPI_PHONEGETBUTTONINFO             = (TSPI_PROC_BASE + 64);
  _TSPI_PHONEGETDATA                   = (TSPI_PROC_BASE + 65);
  _TSPI_PHONEGETDEVCAPS                = (TSPI_PROC_BASE + 66);
  _TSPI_PHONEGETDISPLAY                = (TSPI_PROC_BASE + 67);
  _TSPI_PHONEGETEXTENSIONID            = (TSPI_PROC_BASE + 68);
  _TSPI_PHONEGETGAIN                   = (TSPI_PROC_BASE + 69);
  _TSPI_PHONEGETHOOKSWITCH             = (TSPI_PROC_BASE + 70);
  _TSPI_PHONEGETICON                   = (TSPI_PROC_BASE + 71);
  _TSPI_PHONEGETID                     = (TSPI_PROC_BASE + 72);
  _TSPI_PHONEGETLAMP                   = (TSPI_PROC_BASE + 73);
  _TSPI_PHONEGETRING                   = (TSPI_PROC_BASE + 74);
  _TSPI_PHONEGETSTATUS                 = (TSPI_PROC_BASE + 75);
  _TSPI_PHONEGETVOLUME                 = (TSPI_PROC_BASE + 76);
  _TSPI_PHONENEGOTIATEEXTVERSION       = (TSPI_PROC_BASE + 77);
  _TSPI_PHONENEGOTIATETSPIVERSION      = (TSPI_PROC_BASE + 78);
  _TSPI_PHONEOPEN                      = (TSPI_PROC_BASE + 79);
  _TSPI_PHONESELECTEXTVERSION          = (TSPI_PROC_BASE + 80);
  _TSPI_PHONESETBUTTONINFO             = (TSPI_PROC_BASE + 81);
  _TSPI_PHONESETDATA                   = (TSPI_PROC_BASE + 82);
  _TSPI_PHONESETDISPLAY                = (TSPI_PROC_BASE + 83);
  _TSPI_PHONESETGAIN                   = (TSPI_PROC_BASE + 84);
  _TSPI_PHONESETHOOKSWITCH             = (TSPI_PROC_BASE + 85);
  _TSPI_PHONESETLAMP                   = (TSPI_PROC_BASE + 86);
  _TSPI_PHONESETRING                   = (TSPI_PROC_BASE + 87);
  _TSPI_PHONESETSTATUSMESSAGES         = (TSPI_PROC_BASE + 88);
  _TSPI_PHONESETVOLUME                 = (TSPI_PROC_BASE + 89);
  _TSPI_PROVIDERCONFIG                 = (TSPI_PROC_BASE + 90);
  _TSPI_PROVIDERINIT                   = (TSPI_PROC_BASE + 91);
  _TSPI_PROVIDERINSTALL                = (TSPI_PROC_BASE + 92);
  _TSPI_PROVIDERREMOVE                 = (TSPI_PROC_BASE + 93);
  _TSPI_PROVIDERSHUTDOWN               = (TSPI_PROC_BASE + 94);

  _TSPI_PROVIDERENUMDEVICES            = (TSPI_PROC_BASE + 95);  { TSPI v1.4 }
  _TSPI_LINEDROPONCLOSE                = (TSPI_PROC_BASE + 96);  { TSPI v1.4 }
  _TSPI_LINEDROPNOOWNER                = (TSPI_PROC_BASE + 97);  { TSPI v1.4 }
  _TSPI_PROVIDERCREATELINEDEVICE       = (TSPI_PROC_BASE + 98);  { TSPI v1.4 }
  _TSPI_PROVIDERCREATEPHONEDEVICE      = (TSPI_PROC_BASE + 99);  { TSPI v1.4 }
  _TSPI_LINESETCURRENTLOCATION         = (TSPI_PROC_BASE + 100); { TSPI v1.4 }
  _TSPI_LINECONFIGDIALOGEDIT           = (TSPI_PROC_BASE + 101); { TSPI v1.4 }
  _TSPI_LINERELEASEUSERUSERINFO        = (TSPI_PROC_BASE + 102); { TSPI v1.4 }

{$ENDIF}

implementation

end.
