unit Fmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Finger, StdCtrls, ExtCtrls, Buttons;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    QueryEdit: TEdit;
    Label1: TLabel;
    Terminal: TMemo;
    FingerButton: TBitBtn;
    CancelButton: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FingerButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
  private
    { Private declarations }
    Finger : TFinger;
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  Finger:=TFinger.Create(Self);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Finger.Free;
end;

procedure TForm1.DisableControls;
begin
  QueryEdit.Enabled:=false;
  FingerButton.Enabled:=false;
  CancelButton.Enabled:=true;
  Terminal.Cursor:=crHourGlass;
end;

procedure TForm1.EnableControls;
begin
  QueryEdit.Enabled:=true;
  FingerButton.Enabled:=true;
  CancelButton.Enabled:=false;
  Terminal.Cursor:=crDefault;
end;

procedure TForm1.FingerButtonClick(Sender: TObject);
begin
  DisableControls;
  try
    Finger.Query:=QueryEdit.Text;
    Finger.Execute;
    Terminal.Lines.Assign(Finger.RecvLines);
  finally
    EnableControls;
  end;
end;

procedure TForm1.CancelButtonClick(Sender: TObject);
begin
  Finger.Cancel;
end;

end.
