unit Fmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, Finger, ComCtrls;

type
  TFingerForm = class(TForm)
    Panel1: TPanel;
    QueryEdit: TEdit;
    Label1: TLabel;
    Terminal: TMemo;
    FingerButton: TBitBtn;
    CancelButton: TBitBtn;
    Finger1: TFinger;
    StatusBar1: TStatusBar;
    procedure FingerButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure Finger1Closed(Sender: TObject);
    procedure Finger1Connecting(Sender: TObject);
    procedure Finger1Receiving(Sender: TObject);
    procedure Finger1Sending(Sender: TObject);
    procedure Finger1Canceled(Sender: TObject);
    procedure Finger1Error(Sender: TObject; var Msg: string);
  private
    { Private declarations }
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  FingerForm: TFingerForm;

implementation

{$R *.DFM}

procedure TFingerForm.DisableControls;
begin
  QueryEdit.Enabled:=false;
  FingerButton.Enabled:=false;
  CancelButton.Enabled:=true;
  Terminal.Cursor:=crHourGlass;
end;

procedure TFingerForm.EnableControls;
begin
  QueryEdit.Enabled:=true;
  FingerButton.Enabled:=true;
  CancelButton.Enabled:=false;
  Terminal.Cursor:=crDefault;
end;

procedure TFingerForm.FingerButtonClick(Sender: TObject);
begin
  DisableControls;
  try
    Finger1.Query:=QueryEdit.Text;
    Finger1.Execute;
  finally
    EnableControls;
  end;
end;

procedure TFingerForm.CancelButtonClick(Sender: TObject);
begin
  Finger1.Cancel;
end;

procedure TFingerForm.Finger1Closed(Sender: TObject);
begin
  StatusBar1.SimpleText:='Connection closed';
end;

procedure TFingerForm.Finger1Connecting(Sender: TObject);
begin
  StatusBar1.SimpleText:='Connecting';
end;

procedure TFingerForm.Finger1Receiving(Sender: TObject);
begin
  StatusBar1.SimpleText:='Receiving data';
end;

procedure TFingerForm.Finger1Sending(Sender: TObject);
begin
  StatusBar1.SimpleText:='Sending query';
end;

procedure TFingerForm.Finger1Canceled(Sender: TObject);
begin
  StatusBar1.SimpleText:='Operation has been canceled';
end;

procedure TFingerForm.Finger1Error(Sender: TObject; var Msg: string);
begin
  StatusBar1.SimpleText:=Msg;
end;

end.
