unit Unit1;

interface

uses
  SysUtils, Forms, StdCtrls, Classes, Controls, Gauges,
  MSPing, WSExtra;

type
  TForm1 = class(TForm)
    MSPing1: TMSPing;
    MSTrace1: TMSTrace;
    Edit1: TEdit;
    Memo1: TMemo;
    BtnPing: TButton;
    BtnTrace: TButton;
    BtnCancel: TButton;
    Gauge1: TGauge;
    procedure BtnPingClick(Sender: TObject);
    procedure MSPing1Data(Sender: TObject; Status: Integer);
    procedure MSPing1Finished(Sender: TObject);
    procedure BtnTraceClick(Sender: TObject);
    procedure MSTrace1Data(Sender: TObject; Status: Integer);
    procedure MSTrace1Finished(Sender: TObject);
    procedure MSTrace1Test(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure MSPingError(Sender: TObject; Error: Integer; Msg: String);
  private
    procedure SetButtons(isReady: Boolean);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.SetButtons(isReady: Boolean);
begin
  BtnPing.Visible := isReady;
  BtnTrace.Visible := isReady;
  BtnCancel.Visible := not isReady;
  Gauge1.Visible := not isReady;
end;

procedure TForm1.BtnPingClick(Sender: TObject);
begin
  Memo1.Clear;
  Gauge1.Progress := 0;
  Gauge1.MaxValue := MSPing1.Number;
  SetButtons(False);
  MSPing1.Destination := Edit1.Text;
end;

procedure TForm1.MSPing1Data(Sender: TObject; Status: Integer);
begin
  Memo1.Lines.Add(MSPing1.GetData);
  Gauge1.Progress := MSPing1.Sent;
end;

procedure TForm1.MSPing1Finished(Sender: TObject);
begin
  Memo1.Lines.Add(MSPing1.GetStats);
  SetButtons(True);
end;

procedure TForm1.BtnTraceClick(Sender: TObject);
begin
  Memo1.Clear;
  Gauge1.Progress := 0;
  SetButtons(False);
  MSTrace1.Destination := Edit1.Text;
end;

procedure TForm1.MSTrace1Test(Sender: TObject);
begin
  Gauge1.Progress := 0;
  Gauge1.MaxValue := MSTrace1.ExpectedHops;
end;

procedure TForm1.MSTrace1Data(Sender: TObject; Status: Integer);
begin
  Memo1.Lines.Add(MSTrace1.GetData);
  if MSTrace1.SendTestPacket then Gauge1.Progress := MSTrace1.HopCount;
end;

procedure TForm1.MSTrace1Finished(Sender: TObject);
begin
  Memo1.Lines.Add(MSTrace1.GetStats);
  SetButtons(True);
end;

procedure TForm1.BtnCancelClick(Sender: TObject);
begin
  if MSPing1.Inprogress then MSPing1.Cancel;
  if MSTrace1.Inprogress then MSTrace1.Cancel;
end;

procedure TForm1.MSPingError(Sender: TObject; Error: Integer; Msg: String);
begin
  Memo1.Lines.Add('Error ' + IntToStr(Error) + ': ' + Msg);
  SetButtons(True);
end;

end.
