unit Pop3main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, POP3, Buttons, Grids, ExtCtrls,
  Pop3Su, IniFiles, MsgDcd, mailbase, Gauges;

type
  TPOP3Form = class(TForm)
    ToolBar: TPanel;
    GetButton: TSpeedButton;
    CancelButton: TSpeedButton;
    SetupButton: TSpeedButton;
    ExitButton: TSpeedButton;
    InBox: TStringGrid;
    POP3: TPOP3;
    Holder: TPanel;
    ProgressBarHolder: TPanel;
    StatusBar: TPanel;
    ProgressBar: TGauge;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure GetButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure SetupButtonClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure InBoxDblClick(Sender: TObject);
    procedure POP3StatusChange(Sender: TObject);
    procedure POP3Progress(Sender: TObject);
    procedure InBoxKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    IniName : string;
    AttDir : string;
  public
    { Public declarations }
    procedure ProcessInBox;
    procedure EnableControls;
    procedure DisableControls;
  end;

var
  POP3Form: TPOP3Form;

implementation

{$R *.DFM}

procedure TPOP3Form.FormCreate(Sender: TObject);
begin
  IniName:=ChangeFileExt(Application.ExeName,'.ini');
  with TIniFile.Create(IniName) do
  try
    POP3.Server:=ReadString('Setup','Server','');
    POP3.UserName:=ReadString('Setup','User Name','');
{****** Warning!!! No Encription for Password!!! *****}
    POP3.Password:=ReadString('Setup','Password','');
    POP3.LogFileName:=ReadString('Setup','Log File','');
    AttDir:=ReadString('Setup','Attachments','');
  finally
    free;
  end;
  InBox.Cells[0,0]:='From';
  InBox.Cells[1,0]:='Subject';
  InBox.Cells[2,0]:='Size';
end;

procedure TPOP3Form.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  with TIniFile.Create(IniName) do
  try
    WriteString('Setup','Server',POP3.Server);
    WriteString('Setup','User Name',POP3.UserName);
{****** Warning!!! No Encription for Password!!! *****}
    WriteString('Setup','Password',POP3.Password);
    WriteString('Setup','Log File',POP3.LogFileName);
    WriteString('Setup','Attachments',AttDir);
  finally
    free;
  end;
end;

procedure TPOP3Form.DisableControls;
var
  i : Integer;
  SB : TSpeedButton;
begin
  for i:=0 to ToolBar.ControlCount-1 do
  begin
    SB:=ToolBar.Controls[i] as TSpeedButton;
    SB.Enabled:=SB.Tag=1;
  end;
  Cursor:=crHourGlass;
end;

procedure TPOP3Form.EnableControls;
var
  i : Integer;
  SB : TSpeedButton;
begin
  for i:=0 to ToolBar.ControlCount-1 do
  begin
    SB:=ToolBar.Controls[i] as TSpeedButton;
    SB.Enabled:=SB.Tag<>1;
  end;
  Cursor:=crDefault;
end;

procedure TPOP3Form.GetButtonClick(Sender: TObject);
begin
  if (POP3.Server='') or (POP3.UserName='') or
     (POP3.Password='') then
   MessageDlg('You might want to enter the information'^M^J+
              'in the Setup dialog box...',mtError,[mbOk],0)
  else
  with POP3 do
  begin
    try
      DisableControls;
      Open;
      LogIn;
      GetStatistics;
      if TotalMessages>0 then
        GetMessages;
      LogOut;
    finally
      Close;
      EnableControls;
    end;
  end;
  ProcessInBox;
end;

procedure TPOP3Form.ProcessInBox;
var
  i : Integer;
begin
  if POP3.MailMessages.Count>0 then
  begin
    InBox.Enabled:=true;
    InBox.RowCount:=POP3.MailMessages.Count+1;
    for i:=1 to Pop3.MailMessages.Count do
    with TMailMessage(POP3.MailMessages.Objects[i-1]) do
    begin
      InBox.Cells[0,i]:=From;
      InBox.Cells[1,i]:=Subject;
      InBox.Cells[2,i]:=IntToStr(Size);
    end;
    InBox.Repaint;
    StatusBar.Caption:='Doubleclick or press Enter to process a message';
  end
  else
    StatusBar.Caption:='No New Messages';
end;

procedure TPOP3Form.CancelButtonClick(Sender: TObject);
begin
  Pop3.Cancel;
end;

procedure TPOP3Form.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TPOP3Form.SetupButtonClick(Sender: TObject);
begin
  with TSetupDlg.Create(Self) do
  try
    ServerEdit.Text:=POP3.Server;
    UserNameEdit.Text:=POP3.UserName;
    PasswordEdit.Text:=POP3.Password;
    LogFileNameEdit.Text:=POP3.LogFileName;
    AttDirEdit.Text:=AttDir;
    if ShowModal=mrOk then
    begin
      POP3.Server:=ServerEdit.Text;
      POP3.UserName:=UserNameEdit.Text;
      POP3.Password:=PasswordEdit.Text;
      POP3.LogFileName:=LogFileNameEdit.Text;
      AttDir:=AttDirEdit.Text;
    end;
  finally
    free;
  end;
end;

procedure TPOP3Form.FormResize(Sender: TObject);
begin
  with InBox do
  begin
    ColWidths[0]:=Trunc(0.25*Width);
    ColWidths[1]:=Trunc(0.5*Width);
    ColWidths[2]:=Trunc(0.25*Width);
  end;
end;

procedure TPOP3Form.InBoxDblClick(Sender: TObject);
var
  MailMessage : TMailMessage;
begin
  MsgDcd.AttachmentsDir:=AttDir;
  MailMessage:=TMailMessage(POP3.MailMessages.Objects[InBox.Row-1]);
  MailMessage.Body.Position:=0;
  with TMsgProcessor.Create(Self,MailMessage.Body) do
  try
    ShowModal;
  finally
    free;
  end;
end;

procedure TPOP3Form.POP3StatusChange(Sender: TObject);
var
  s : string;
begin
  case POP3.Status of
   psIdle : s:='';
   psResolving : s:='Resolving remote host';
   psConnecting : s:='Connecting to server';
   psLogIn : s:='Logging In';
   psLogOut : s:='Logging Out';
   psRetrieving : s:='Retrieving Message(s)';
   psDeleting : s:='Deleting Message(s)';
   psCancel : s:='Canceled';
   psTimeOut : s:='Timed Out';
  end;
  StatusBar.Caption:=s;
end;

procedure TPOP3Form.POP3Progress(Sender: TObject);
begin
  ProgressBar.Progress:=POP3.Progress;
end;

procedure TPOP3Form.InBoxKeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#13 then
    InBoxDblClick(Sender);
end;

end.
