unit Msgutils;

interface

uses Classes,SysUtils;

function TrimStr(s : string) : string;
procedure TrimStringList(SL : TStrings);
function GetHeaderValue(Hdr : TStrings; const ID : string) : string;
function GetParameter(const p : string; s : string) : string;
function AddBackSlash(const DirName : string) : string;

const
  InvStr = '$$Unable to Get$$';

implementation

function TrimStr(s : string) : string;
begin
  while (Length(s)>0) and (s[1] in [' ',^I]) do
    Delete(s,1,1);
  while (Length(s)>0) and (s[Length(s)] in [' ',^I]) do
    Delete(s,Length(s),1);
  result:=s;
end;

procedure TrimStringList(SL : TStrings);
begin
  with SL do
  begin
    while (Count>0) and (Strings[0]='') do
      Delete(0);
    while (Count>0) and (Strings[Count-1]='') do
      Delete(Count-1);
  end;
end;

function GetHeaderValue(Hdr : TStrings; const ID : string) : string;
var
  Found : boolean;
  i,j : Integer;
begin
  Found:=false; Result:='';
  for i:=0 to Hdr.Count-1 do
  if Pos(UpperCase(ID),UpperCase(Hdr[i]))=1 then
  begin
    Found:=true;
    Break;
  end;
  if Found then
  begin
    Result:=Hdr[i];
    j:=Pos(':',Result);
    Delete(Result,1,j+1);
    Result:=TrimStr(Result);
    Inc(i);
    while (i<=Hdr.Count-1) and (Pos(':',Hdr[i])=0) do
    begin
      Result:=Concat(Result,' ',TrimStr(Hdr[i]));
      Inc(i);
    end;
  end;
end;

function GetParameter(const p : string; s : string) : string;
{Gets p="value" or p=value, returns 'value'}
{April 07, 1996, removing trailing ;}
var
  i : Integer;
  LastCh : Char;
begin
  Result:=InvStr;
  i:=Pos(UpperCase(p),UpperCase(s));
  if i<>0 then
  begin
    Result:='';
    Delete(s,1,i+Length(p));
    s:=TrimStr(s);
    if s[1]='"' then
    begin
      LastCh:='"';
      i:=2;
    end
    else
    begin
      LastCh:=' ';
      i:=1;
    end;
    while (i<=Length(s)) and (s[i]<>LastCh) do
    begin
      Result:=Concat(Result,s[i]);
      Inc(i);
    end;
    if Result[Length(Result)]=';' then
      Delete(Result,Length(Result),1);
    Result:=TrimStr(Result);
  end;
end;

function AddBackSlash(const DirName : string) : string;
begin
  if (Length(DirName)>0) and (DirName[Length(DirName)]<>'\')
    then Result:=Concat(DirName,'\')
  else
    Result:=DirName;
end;

end.
