unit protTEST;

interface

uses
  WinProcs,WinTypes, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB, DBTables, Grids, DBGrids, StdCtrls, ExtCtrls, Buttons, Menus, ShellAPI, tProtect;

type
  TForm1 = class(TForm)
    tblProtected: TTable;
    tblStructureBackup: TTable;
    DataSource1: TDataSource;
    Panel1: TPanel;
    btnProtectTable: TButton;
    btnOpenTable: TButton;
    Panel2: TPanel;
    DBGrid1: TDBGrid;
    btnCloseTable: TButton;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Break1: TMenuItem;
    Tablefile1: TMenuItem;
    PrimaryIndex1: TMenuItem;
    SecondaryIndex1: TMenuItem;
    Protection1: TMenuItem;
    On1: TMenuItem;
    Off1: TMenuItem;
    Open1: TMenuItem;
    Close1: TMenuItem;
    N1: TMenuItem;
    Changeindextosecondary1: TMenuItem;
    Changeindextoprimary1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    PopupMenu1: TPopupMenu;
    TableFile2: TMenuItem;
    PrimaryIndex2: TMenuItem;
    SecondaryIndex2: TMenuItem;
    btnBreak: TButton;
    btnIndex: TButton;
    PopupMenu2: TPopupMenu;
    ActivatePrimaryIndex1: TMenuItem;
    ActivateSecondaryIndex1: TMenuItem;
    About1: TMenuItem;
    Protector1: TProtector;
    Panel3: TPanel;
    Label1: TLabel;
    comboBoxSetProtectedAlias: TComboBox;
    Label2: TLabel;
    ComboBoxSetProtTable: TComboBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    comboBoxSetBackupAlias: TComboBox;
    ComboBoxSetBackupTable: TComboBox;
    Edit1: TEdit;
    Label7: TLabel;
    TUinstalled: TCheckBox;
    TUtest: TCheckBox;
    TUrepair: TCheckBox;
    BitBtn1: TBitBtn;
    StatusBar1: TPanel;
    procedure btnProtectTableClick(Sender: TObject);
    procedure btnOpenTableClick(Sender: TObject);
    procedure btnCloseTableClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure PrimaryIndex1Click(Sender: TObject);
    procedure Changeindextoprimary1Click(Sender: TObject);
    procedure Changeindextosecondary1Click(Sender: TObject);
    procedure SecondaryIndex1Click(Sender: TObject);
    procedure Tablefile1Click(Sender: TObject);
    procedure btnBreakClick(Sender: TObject);
    procedure btnIndexClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure comboBoxSetProtectedAliasChange(Sender: TObject);
    procedure ComboBoxSetProtTableChange(Sender: TObject);
    procedure comboBoxSetBackupAliasChange(Sender: TObject);
    procedure ComboBoxSetBackupTableChange(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure TUinstalledClick(Sender: TObject);
    procedure TUtestClick(Sender: TObject);
    procedure TUrepairClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public

    { Public declarations }
  end;
var
  Form1: TForm1;
  FPointer: Pointer;
  Names : TstringList;
implementation

uses About;

{$R *.DFM}

procedure TForm1.btnProtectTableClick(Sender: TObject);
begin
 if btnProtectTable.Caption = '&Protect' then
   begin
     On1.Enabled:=false;
     Off1.Enabled:=True;
     btnProtectTable.Caption := '&UnProtect';
     StatusBar1.Caption:= 'Table Protected with the Component';
   end
 else
   begin
     On1.Enabled := true;
     Off1.Enabled := False;
     btnProtectTable.Caption := '&Protect';
     StatusBar1.Caption:= 'Table Protection is Off';
   end;
end;

procedure TForm1.btnOpenTableClick(Sender: TObject);
begin
if btnProtectTable.caption ='&UnProtect' then
  begin
    StatusBar1.Caption:= 'Opening the table in protected mode...';
    screen.cursor:= crHourglass;
    DBGrid1.datasource:= nil;
    Protector1.ProtectedOpen;
    DBGrid1.datasource:=DataSource1;
    screen.cursor:= crDefault;
    StatusBar1.Caption:= 'Table protected with the component';
  end
else
    tblProtected.Open;
end;

procedure TForm1.btnCloseTableClick(Sender: TObject);
begin
  if tblProtected.active then tblProtected.close;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  Tabname,
  DirString,
  FileNameStr   : String;
  FileHandle : Integer;
  AliasParams      : TstringList;
  Character    : PChar;
begin
  {$ifNDef Win32}
    messageDLG('This function not available in 16-bit version. '+chr(13)+'(there is no TUtility repair function -'+
               ' which is required to repair serious .DB file damage.) '+chr(13)+
               'Please use the "damage index" functions instead.' , mtInformation,[mbOK],0);
    exit;
  {$endif}


  if messageDLG('Warning:  Do not use this function on a table without a backup structure'+
               ' (if you do, it will NOT be repairable!)'+
               'Also, do not use without TUtility installed'+
                chr(10)+chr(13)+ 'Do you want to continue with damage the .db file ??',
                mtWarning,[mbYes, mbCancel],0)=mrCancel then   exit;
  aliasParams := TstringList.Create;
  try
    Session.GetAliasParams(tblProtected.DatabaseName, AliasParams);
    DirString := Copy(AliasParams.Strings[0],6,60);
    if copy(DirString,length((DirString)),1)<>'\' then
      DirString := DirString+'\';
  finally
    AliasParams.free;
  end;

  Tabname := copy(tblProtected.TableName,1,pos('.',tblProtected.TableName)-1);
  FileNameStr := DirString + Tabname+'.db';

  if tblProtected.active then tblProtected.close;
  if FileExists(FileNameStr) then
    begin
    FileHandle := FileOpen(FileNameStr, fmOpenWrite or fmShareDenyNone);

    try
       FileSeek(FileHandle,7,0);

       GetMem(Character,2);
       try
         StrPCopy(Character,'!');
         FileWrite(FileHandle,Character,1);
  {this will cause header corruption - serious enough to require "borrow structure" function}
       finally
         freeMem(Character,2);
       end;

    finally
      FileClose(FileHandle);
      Showmessage('    Table .db file is broken!       ');
    end;
    end;
end;


procedure TForm1.PrimaryIndex1Click(Sender: TObject);
var
  Tabname,
  DirString,
  FileNameStr   : String;
  FileHandle : Integer;
  AliasParams      : TstringList;
  Character    : PChar;
begin
  AliasParams := TstringList.Create;
  try
    Session.GetAliasParams(tblProtected.DatabaseName, AliasParams);
    DirString := Copy(AliasParams.Strings[0],6,60);
    if copy(DirString,length((DirString)),1)<>'\' then
      DirString := DirString+'\';
  finally
    AliasParams.free;
  end;

  Tabname := copy(tblProtected.TableName,1,pos('.',tblProtected.TableName)-1);
  FileNameStr := DirString + Tabname+'.px';

  if tblProtected.active then tblProtected.close;
  if FileExists(FileNameStr) then
    begin
    FileHandle := FileOpen(FileNameStr, fmOpenWrite or fmShareDenyNone);

    try
       FileSeek(FileHandle,2,0);

       GetMem(Character,5);
       try
         StrPCopy(Character,'!!!');
         FileWrite(FileHandle,Character,3);
       finally
         freeMem(Character,5);
       end;

    finally
      FileClose(FileHandle);
      Showmessage('     Primary Index is broken!       ');
    end;
    end;
end;

procedure TForm1.SecondaryIndex1Click(Sender: TObject);
var
  Tabname,
  DirString,
  FileNameStr   : String;
  FileHandle : Integer;
  AliasParams      : TstringList;
  Character    : PChar;
begin
  AliasParams := TstringList.Create;
  try
    Session.GetAliasParams(tblProtected.DatabaseName, AliasParams);
    DirString := Copy(AliasParams.Strings[0],6,60);
    if copy(DirString,length((DirString)),1)<>'\' then
      DirString := DirString+'\';
  finally
    AliasParams.free;
  end;

  Tabname := copy(tblProtected.TableName,1,pos('.',tblProtected.TableName)-1);
  FileNameStr := DirString + Tabname+'.XG0';

  if tblProtected.active then tblProtected.close;
  if FileExists(FileNameStr) then
    begin
    FileHandle := FileOpen(FileNameStr, fmOpenWrite or fmShareDenyNone);

    try
       FileSeek(FileHandle,1,0);

       GetMem(Character,8);
       try
         StrPCopy(Character,'!!!!!!!');
         FileWrite(FileHandle,Character,7);
       finally
         freeMem(Character,8);
       end;

    finally
      FileClose(FileHandle);
      Showmessage('     Secondary Index is broken!       ');
    end;
    end;
end;





procedure TForm1.Changeindextoprimary1Click(Sender: TObject);
begin
if btnProtectTable.caption ='&UnProtect' then
  begin
    screen.cursor:= crHourglass;
    DBGrid1.datasource:= nil;
    Protector1.NewIndexName:='';
    Protector1.ChangeIndex;
    DBGrid1.datasource:=DataSource1;
    screen.cursor:= crDefault;
  end
else
  tblProtected.indexname:='';
DBGRID1.refresh;
end;


procedure TForm1.Changeindextosecondary1Click(Sender: TObject);
begin
if btnProtectTable.caption ='&UnProtect' then
  begin
    screen.cursor:= crHourglass;
    DBGrid1.datasource:= nil;
    Protector1.NewIndexName:='SecInd1';
    Protector1.ChangeIndex;
    DBGrid1.datasource:=DataSource1;
    screen.cursor:= crDefault;
  end
else
  tblProtected.indexname:='SecInd1';
DBGRID1.refresh;
end;


procedure TForm1.Tablefile1Click(Sender: TObject);
begin
{}
end;

procedure TForm1.btnBreakClick(Sender: TObject);
begin
  with sender as TButton do
    begin
      PopUpMenu1.popup(Form1.Left+Panel1.Left+Left, Form1.top+Panel1.Top+Top+3*Height);
    end;
end;

procedure TForm1.btnIndexClick(Sender: TObject);
begin
  with sender as TButton do
    begin
      PopUpMenu2.popup(Form1.Left+Panel1.Left+Left, Form1.top+Panel1.Top+Top+3*Height);
    end;
end;

procedure TForm1.About1Click(Sender: TObject);
begin
  AboutBox.Showmodal;
end;

procedure TForm1.comboBoxSetProtectedAliasChange(Sender: TObject);
begin
  tblProtected.DatabaseName:=comboBoxSetProtectedAlias.Text;
  Session.GetTableNames(comboBoxSetProtectedAlias.Items[comboBoxSetProtectedAlias.ItemIndex], '*.*',
    True, False, ComboBoxSetProtTable.Items);
end;

procedure TForm1.ComboBoxSetProtTableChange(Sender: TObject);
begin
  tblProtected.tableName:=comboBoxSetProtTable.Text;
end;

procedure TForm1.comboBoxSetBackupAliasChange(Sender: TObject);
begin
  form1.tblStructureBackup.DatabaseName:=comboBoxSetBackupAlias.Text;
  Session.GetTableNames(comboBoxSetBackupAlias.Items[comboBoxSetBackupAlias.ItemIndex], '*.*',
    True, False, ComboBoxSetBackupTable.Items);
end;

procedure TForm1.ComboBoxSetBackupTableChange(Sender: TObject);
begin
 tblStructureBackup.tableName:=comboBoxSetBackupTable.Text;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
   Protector1.ErrorLogFile:=Edit1.Text;
end;

procedure TForm1.TUinstalledClick(Sender: TObject);
begin
  if TUinstalled.checked then
    begin
    Protector1.TUtilDLLInstalled:=True;
    if Protector1.UseTUtilFortest then
      TUtest.state:=cbChecked
    else
      TUtest.state:=cbUnChecked;
  {TUtility repair disabled for 16-bit compile  ... it's not working correctly yet}
  {$ifDef Win32}
  if Protector1.UseTUtilForRepair then
    TUrepair.state:=cbChecked
  else
    TUrepair.state:=cbUnChecked;
  {$else}
    TUrepair.visible:=False;
  {$endif}
    end
  else
    begin
    Protector1.TUtilDLLInstalled:=False;
    TUtest.state:=cbGrayed;
    TUrepair.state:=cbGrayed;
    end;

end;

procedure TForm1.TUtestClick(Sender: TObject);
begin
  if TUtest.checked then
    Protector1.UseTUtilFortest:=True
  else
    Protector1.UseTUtilFortest:=False;

end;

procedure TForm1.TUrepairClick(Sender: TObject);
begin
  {TUtility repair disabled for 16-bit compile  ... it's not working correctly yet}
  {$ifDef Win32}
  if TUrepair.checked then
    Protector1.UseTUtilForRepair:=True
  else
    Protector1.UseTUtilForRepair:=False;
  {$else}
    TUrepair.visible:=False;
  {$endif}

end;

procedure TForm1.FormActivate(Sender: TObject);
Var
 I : Integer;
 AliasNameList: TstringList;
begin
  AliasNameList:= TstringList.create;
  try
     Session.GetAliasNames(AliasNameList);
     AliasNameList.sort;
     for I:=0 to AliasNameList.count-1 do
       begin
         comboBoxSetProtectedAlias.items.add(AliasNameList.strings[i]);
         comboBoxSetBackupAlias.items.add(AliasNameList.strings[i]);
  {       Combobox3.items.add(AliasNameList.strings[i]); }
       end;
  finally
    AliasNameList.free;
  end;
end;

end.
