unit Rebprop;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, db, ProtTest;

type
  TBtnBottomDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Bevel1: TBevel;
    comboBoxSetProtectedAlias: TComboBox;
    comboBoxSetBackupAlias: TComboBox;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    TUinstalled: TCheckBox;
    TUtest: TCheckBox;
    TUrepair: TCheckBox;
    ComboBoxSetProtTable: TComboBox;
    Label3: TLabel;
    ComboBoxSetBackupTable: TComboBox;
    Label5: TLabel;
    procedure FormShow(Sender: TObject);
    procedure comboBoxSetProtectedAliasChange(Sender: TObject);
    procedure comboBoxSetBackupAliasChange(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure TUinstalledClick(Sender: TObject);
    procedure TUtestClick(Sender: TObject);
    procedure TUrepairClick(Sender: TObject);
    procedure ComboBoxSetProtTableChange(Sender: TObject);
    procedure ComboBoxSetBackupTableChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  BtnBottomDlg: TBtnBottomDlg;

implementation

{$R *.DFM}

procedure TBtnBottomDlg.FormShow(Sender: TObject);
 Var
 I : Integer;
 AliasNameList: TstringList;
begin
  AliasNameList:= TstringList.create;
  try
     Session.GetAliasNames(AliasNameList);
     AliasNameList.sort;
     for I:=0 to AliasNameList.count-1 do
       begin
         comboBoxSetProtectedAlias.items.add(AliasNameList.strings[i]);
         comboBoxSetBackupAlias.items.add(AliasNameList.strings[i]);
  {       Combobox3.items.add(AliasNameList.strings[i]); }
       end;
  finally
  AliasNameList.free;
  end;

  if form1.Protector1.TUtilDLLInstalled then
    TUinstalled.state:=cbChecked
  else
    TUinstalled.state:=cbunChecked;

  if form1.Protector1.UseTUtilFortest then
    TUtest.state:=cbChecked
  else
    TUtest.state:=cbUnChecked;

  {TUtility repair disabled for 16-bit compile  ... it's not working correctly yet}
  {$ifDef Win32}
  if form1.Protector1.UseTUtilForRepair then
    TUrepair.state:=cbChecked
  else
    TUrepair.state:=cbUnChecked;
  {$else}
    TUrepair.visible:=False;
  {$endif}
end;

procedure TBtnBottomDlg.comboBoxSetProtectedAliasChange(Sender: TObject);
begin
  form1.tblProtected.DatabaseName:=comboBoxSetProtectedAlias.Text;
  Session.GetTableNames(comboBoxSetProtectedAlias.Items[comboBoxSetProtectedAlias.ItemIndex], '*.*',
    True, False, ComboBoxSetProtTable.Items);
end;

procedure TBtnBottomDlg.comboBoxSetBackupAliasChange(Sender: TObject);
begin
  form1.tblStructureBackup.DatabaseName:=comboBoxSetBackupAlias.Text;
  Session.GetTableNames(comboBoxSetBackupAlias.Items[comboBoxSetBackupAlias.ItemIndex], '*.*',
    True, False, ComboBoxSetBackupTable.Items);
end;

procedure TBtnBottomDlg.Edit1Change(Sender: TObject);
begin
   form1.Protector1.ErrorLogFile:=Edit1.Text;
end;

procedure TBtnBottomDlg.TUinstalledClick(Sender: TObject);
begin
  if TUinstalled.checked then
    begin
    form1.Protector1.TUtilDLLInstalled:=True;
    if form1.Protector1.UseTUtilFortest then
      TUtest.state:=cbChecked
    else
      TUtest.state:=cbUnChecked;
  {TUtility repair disabled for 16-bit compile  ... it's not working correctly yet}
  {$ifDef Win32}
  if form1.Protector1.UseTUtilForRepair then
    TUrepair.state:=cbChecked
  else
    TUrepair.state:=cbUnChecked;
  {$else}
    TUrepair.visible:=False;
  {$endif}
    end
  else
    begin
    form1.Protector1.TUtilDLLInstalled:=False;
    TUtest.state:=cbGrayed;
    TUrepair.state:=cbGrayed;
    end;
end;

procedure TBtnBottomDlg.TUtestClick(Sender: TObject);
begin
  if TUtest.checked then
    form1.Protector1.UseTUtilFortest:=True
  else
    form1.Protector1.UseTUtilFortest:=False;
end;

procedure TBtnBottomDlg.TUrepairClick(Sender: TObject);
begin
  {TUtility repair disabled for 16-bit compile  ... it's not working correctly yet}
  {$ifDef Win32}
  if TUrepair.checked then
    form1.Protector1.UseTUtilForRepair:=True
  else
    form1.Protector1.UseTUtilForRepair:=False;
  {$else}
    TUrepair.visible:=False;
  {$endif}
end;

procedure TBtnBottomDlg.ComboBoxSetProtTableChange(Sender: TObject);
begin
  form1.tblProtected.tableName:=comboBoxSetProtTable.Text;
end;

procedure TBtnBottomDlg.ComboBoxSetBackupTableChange(Sender: TObject);
begin
  form1.tblStructureBackup.tableName:=comboBoxSetBackupTable.Text;
end;

end.
