unit Prottest;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, StdCtrls, ExtCtrls, Grids,
  DBGrids, Menus, Buttons, About16, Dsgnintf, Gauges, Trebuild;

{$Define DEMO}

type
  TForm1 = class(TForm)
    tblWorking: TTable;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    ButtonOpen: TButton;
    Button5: TButton;
    Panel2: TPanel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    OpenTable1: TMenuItem;
    CloseTable1: TMenuItem;
    N1: TMenuItem;
    ActivatePrimaryIndex1: TMenuItem;
    ActivateSecondaryIndex1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    Break1: TMenuItem;
    Tablefiledb1: TMenuItem;
    PrimaryIndex1: TMenuItem;
    SecondaryIndexXG01: TMenuItem;
    Protect1: TMenuItem;
    Button4: TButton;
    Button6: TButton;
    SpeedButton1: TSpeedButton;
    PopupMenu1: TPopupMenu;
    PopupMenu2: TPopupMenu;
    TableFiledb2: TMenuItem;
    PrimaryIndexpx1: TMenuItem;
    SecondaryIndex1: TMenuItem;
    ActivatePrimaryIndex2: TMenuItem;
    ActivateSecondaryIndex2: TMenuItem;
    About1: TMenuItem;
    ButtonRun: TButton;
    SetProperties1: TMenuItem;
    ComponentsProperties1: TMenuItem;
    OpenDialog1: TOpenDialog;
    PopupMenu3: TPopupMenu;
    Gauge1: TGauge;
    Label1: TLabel;
    Rebuilder1: TRebuilder;
    procedure Button4Click(Sender: TObject);
    procedure ButtonOpenClick(Sender: TObject);
    procedure CloseTable1Click(Sender: TObject);
    procedure ActivatePrimaryIndex1Click(Sender: TObject);
    procedure ActivateSecondaryIndex1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Tablefiledb1Click(Sender: TObject);
    procedure PrimaryIndex1Click(Sender: TObject);
    procedure SecondaryIndexXG01Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure ComponentsProperties1Click(Sender: TObject);
    procedure ButtonRunClick(Sender: TObject);
    procedure Rebuilder1NextTableTest(TestingTableName: String; TableNo,
      TableCount: Integer; IsReb: Boolean);
  private
    { Private declarations }
  public
    procedure ChangeSecondaryIndex(Sender: TObject);

    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
Uses RebProp;
{$R *.DFM}

procedure TForm1.Button4Click(Sender: TObject);
begin
{}
end;

procedure TForm1.ButtonOpenClick(Sender: TObject);
var
AliasParams : TstringList;
DosPath : String;
begin
try
  screen.cursor := crHourGlass;
  if Rebuilder1.Protectedalias='' then
    begin
      showmessage('Set please the properties of the TRebuilder first.');
      exit;
    end;
  if tblWorking.active then tblWorking.close;
  AliasParams := TStringList.create;
  Session.GetAliasParams(Rebuilder1.Protectedalias, AliasParams);
  DosPath := (Copy(AliasParams.Strings[0],6,60));
  if (copy(DosPath,length(DosPath)-1,1))<>'\' then DosPath:=DosPath+'\';;
  OpenDialog1.Initialdir := Dospath;
  OpenDialog1.execute;
  tblWorking.DatabaseName := Rebuilder1.Protectedalias;
  tblWorking.TableName := extractFileName(OpenDialog1.FileName);
  TblWorking.indexname:='';
  tblWorking.open;
finally
  screen.cursor := crDefault;
end;
end;

procedure TForm1.CloseTable1Click(Sender: TObject);
begin
if TblWorking.active then TblWorking.close;
end;

procedure TForm1.ActivatePrimaryIndex1Click(Sender: TObject);
begin
  TblWorking.indexname:='';
DBGRID1.refresh;

end;

procedure TForm1.ActivateSecondaryIndex1Click(Sender: TObject);
var
I,j,k        : Integer;
NewItem1 : TMenuItem;
begin
TblWorking.indexdefs.Update;

if TblWorking.indexdefs.count >0 then
  begin
    i:=Popupmenu3.Items.Count;
    if i>0 then
      for j:=0 to(Popupmenu3.Items.Count-1) do
        begin
          { You delete item 0 since list is always decreasing }
          Popupmenu3.Items[0].free;
        end;
    for k:=0 to TblWorking.indexdefs.count-1 do
      begin
        if  (TblWorking.indexdefs.items[k].name <> '') then
        { If Table Name is Blank then it is Primary Index - no need to list it}
        begin
          NewItem1 := TMenuItem.Create(Popupmenu3);
          NewItem1.Caption :=  TblWorking.indexdefs.items[k].name;
          NewItem1.OnClick := ChangeSecondaryIndex;
          Popupmenu3.Items.add(NewItem1);
          if k=10 then
            NewItem1.Break:=mbBarBreak;
        end;
      end;
  end;
PopUpMenu3.popup(Form1.Left+Panel1.Left+10, Form1.top+Panel1.Top+10);
end;

procedure TForm1.ChangeSecondaryIndex(Sender: TObject);
begin
  with sender as TMenuItem do
    begin
      TblWorking.indexname := caption;
      DBGRID1.refresh;
    end;
end;


procedure TForm1.Exit1Click(Sender: TObject);
begin
close;
end;

procedure TForm1.Tablefiledb1Click(Sender: TObject);
var
  Tabname,
  DirString,
  FileNameStr   : String;
  FileHandle : Integer;
  AliasParams      : TstringList;
  Character    : PChar;
begin
  AliasParams := TstringList.Create;
  try
    Session.GetAliasParams(TblWorking.DatabaseName, AliasParams);
    DirString := Copy(AliasParams.Strings[0],6,60);
    if copy(DirString,length((DirString)),1)<>'\' then
      DirString := DirString+'\';
  finally
    AliasParams.free;
  end;

  Tabname := copy(TblWorking.TableName,1,pos('.',TblWorking.TableName)-1);
  FileNameStr := DirString + Tabname+'.db';

  if TblWorking.active then TblWorking.close;
  if FileExists(FileNameStr) then
    begin
    FileHandle := FileOpen(FileNameStr, fmOpenWrite or fmShareDenyNone);

    try
       FileSeek(FileHandle,7,0);

       GetMem(Character,2);
       try
         StrPCopy(Character,'!');
         FileWrite(FileHandle,Character,1);
  {this will cause header corruption - serious enough to require "borrow structure" function}
       finally
         freeMem(Character,2);
       end;

    finally
      FileClose(FileHandle);
      Showmessage('     .db file is broken!       ');
    end;
    end;
end;


procedure TForm1.PrimaryIndex1Click(Sender: TObject);
var
  Tabname,
  DirString,
  FileNameStr   : String;
  FileHandle : Integer;
  AliasParams      : TstringList;
  Character    : PChar;
begin
  AliasParams := TstringList.Create;
  try
    Session.GetAliasParams(TblWorking.DatabaseName, AliasParams);
    DirString := Copy(AliasParams.Strings[0],6,60);
    if copy(DirString,length((DirString)),1)<>'\' then
      DirString := DirString+'\';
  finally
    AliasParams.free;
  end;

  Tabname := copy(TblWorking.TableName,1,pos('.',TblWorking.TableName)-1);
  FileNameStr := DirString + Tabname+'.px';

  if TblWorking.active then TblWorking.close;
  if FileExists(FileNameStr) then
    begin
    FileHandle := FileOpen(FileNameStr, fmOpenWrite or fmShareDenyNone);

    try
       FileSeek(FileHandle,2,0);

       GetMem(Character,5);
       try
         StrPCopy(Character,'!!!');
         FileWrite(FileHandle,Character,3);
       finally
         freeMem(Character,5);
       end;

    finally
      FileClose(FileHandle);
      Showmessage('     Primary Index is broken!       ');
    end;
    end;
end;

procedure TForm1.SecondaryIndexXG01Click(Sender: TObject);
var
  Tabname,
  DirString,
  FileNameStr   : String;
  FileHandle : Integer;
  AliasParams      : TstringList;
  Character    : PChar;
begin
  AliasParams := TstringList.Create;
  try
    Session.GetAliasParams(TblWorking.DatabaseName, AliasParams);
    DirString := Copy(AliasParams.Strings[0],6,60);
    if copy(DirString,length((DirString)),1)<>'\' then
      DirString := DirString+'\';
  finally
    AliasParams.free;
  end;

  Tabname := copy(TblWorking.TableName,1,pos('.',TblWorking.TableName)-1);
  FileNameStr := DirString + Tabname+'.XG0';

  if TblWorking.active then TblWorking.close;
  if FileExists(FileNameStr) then
    begin
    FileHandle := FileOpen(FileNameStr, fmOpenWrite or fmShareDenyNone);

    try
       FileSeek(FileHandle,1,0);

       GetMem(Character,8);
       try
         StrPCopy(Character,'!!!!!!!');
         FileWrite(FileHandle,Character,7);
       finally
         freeMem(Character,8);
       end;

    finally
      FileClose(FileHandle);
      Showmessage('     Secondary Index is broken!       ');
    end;
    end;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  with sender as TButton do
    begin
      PopUpMenu1.popup(Form1.Left+Panel1.Left+Left, Form1.top+Panel1.Top+Top+3*Height);
    end;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
   with sender as TButton do
    begin
      PopUpMenu2.popup(Form1.Left+Panel1.Left+Left, Form1.top+Panel1.Top+Top+3*Height);
    end;
end;

procedure TForm1.About1Click(Sender: TObject);
begin
  AboutBox.showmodal;
end;

procedure TForm1.ComponentsProperties1Click(Sender: TObject);
begin
   BtnBottomDlg.Showmodal;
end;

procedure TForm1.ButtonRunClick(Sender: TObject);
begin
buttonopen.enabled:=False;
try
  Rebuilder1.checkAlias;
finally
  buttonopen.enabled:=True;
  Gauge1.progress := 0;
  Label1.Caption := 'Finished';
  screen.cursor := crDefault;
end;
end;

procedure TForm1.Rebuilder1NextTableTest(TestingTableName: String; TableNo,
  TableCount: Integer; IsReb: Boolean);
begin
Gauge1.maxvalue := Tablecount+1;
Gauge1.progress := TableNo;
Application.processmessages;
if Isreb then
  begin
   Label1.Font.Color := clRed;
   Label1.caption := ' Rebuilding table ' + TestingTableName;
  end
else
  Begin
      Label1.Font.Color := clBlack;
   Label1.caption := ' Testing table ' + TestingTableName;
  end;
panel2.refresh;
Application.processmessages;
end;

end.
