unit Rebprop;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, db, ProtTest;

type
  TBtnBottomDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Bevel1: TBevel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    TUinstalled: TCheckBox;
    TUtest: TCheckBox;
    TUrepair: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure TUinstalledClick(Sender: TObject);
    procedure TUtestClick(Sender: TObject);
    procedure TUrepairClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  BtnBottomDlg: TBtnBottomDlg;

implementation

{$R *.DFM}

procedure TBtnBottomDlg.FormShow(Sender: TObject);
 Var
 I : Integer;
 AliasNameList: TstringList;
begin
  AliasNameList:= TstringList.create;
  try
     Session.GetAliasNames(AliasNameList);
     AliasNameList.sort;
     for I:=0 to AliasNameList.count-1 do
       begin
         Combobox1.items.add(AliasNameList.strings[i]);
         Combobox2.items.add(AliasNameList.strings[i]);
         Combobox3.items.add(AliasNameList.strings[i]);
       end;
  finally
  AliasNameList.free;
  end;

  if form1.Rebuilder1.TUtilDLLInstalled then
    TUinstalled.state:=cbChecked
  else
    TUinstalled.state:=cbunChecked;

  if form1.Rebuilder1.UseTUtilFortest then
    TUtest.state:=cbChecked
  else
    TUtest.state:=cbUnChecked;

  {TUtility repair disabled for 16-bit compile  ... it's not working correctly yet}
  {$ifDef Win32}
  if form1.Rebuilder1.UseTUtilForRepair then
    TUrepair.state:=cbChecked
  else
    TUrepair.state:=cbUnChecked;
  {$else}
    TUrepair.visible:=False;
  {$endif}
end;

procedure TBtnBottomDlg.ComboBox3Change(Sender: TObject);
begin
  form1.Rebuilder1.BackUpDataAlias:=Combobox3.Text;
end;

procedure TBtnBottomDlg.ComboBox1Change(Sender: TObject);
begin
  form1.Rebuilder1.ProtectedAlias:=Combobox1.Text;
end;

procedure TBtnBottomDlg.ComboBox2Change(Sender: TObject);
begin
  form1.Rebuilder1.BackUpStrAlias:=Combobox2.Text;
end;

procedure TBtnBottomDlg.Edit1Change(Sender: TObject);
begin
   form1.Rebuilder1.ErrorLogFile:=Edit1.Text;
end;

procedure TBtnBottomDlg.TUinstalledClick(Sender: TObject);
begin
  if TUinstalled.checked then
    begin
    form1.Rebuilder1.TUtilDLLInstalled:=True;
    if form1.Rebuilder1.UseTUtilFortest then
      TUtest.state:=cbChecked
    else
      TUtest.state:=cbUnChecked;
  {TUtility repair disabled for 16-bit compile  ... it's not working correctly yet}
  {$ifDef Win32}
  if form1.Rebuilder1.UseTUtilForRepair then
    TUrepair.state:=cbChecked
  else
    TUrepair.state:=cbUnChecked;
  {$else}
    TUrepair.visible:=False;
  {$endif}
    end
  else
    begin
    form1.Rebuilder1.TUtilDLLInstalled:=False;
    TUtest.state:=cbGrayed;
    TUrepair.state:=cbGrayed;
    end;
end;

procedure TBtnBottomDlg.TUtestClick(Sender: TObject);
begin
  if TUtest.checked then
    form1.Rebuilder1.UseTUtilFortest:=True
  else
    form1.Rebuilder1.UseTUtilFortest:=False;
end;

procedure TBtnBottomDlg.TUrepairClick(Sender: TObject);
begin
  {TUtility repair disabled for 16-bit compile  ... it's not working correctly yet}
  {$ifDef Win32}
  if TUrepair.checked then
    form1.Rebuilder1.UseTUtilForRepair:=True
  else
    form1.Rebuilder1.UseTUtilForRepair:=False;
  {$else}
    TUrepair.visible:=False;
  {$endif}
end;

end.
