{*******************************************************}
{                                                       }
{  TUtility Tools Component Registration Module         }
{  DB Aware Components for Delphi                       }
{  Copyright (c) 1995,1996,1997 Out & About Productions }
{                                                       }
{*******************************************************}

unit Tu_int;

interface

uses Classes, DsgnIntf, SysUtils, DB, DBTables, Tu, TRepDlg, VerDlg, RebDlg,
  TUIdx, Dialogs;

{$IFDEF Win32}
  {$R TU_INT32.DCR}
{$ELSE}
  {$R TU_INT16.DCR}
{$ENDIF}


procedure Register;

implementation

{ TTutilityComponentEditor }

type
  TTutilityComponentEditor = class(TDefaultEditor)
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

procedure TTutilityComponentEditor.ExecuteVerb(Index: Integer);
begin
  MessageDlg('TUtility Paradox Table Repair Components'
             +#10#13+ 'Version 4.00'
             +#10#13+ '(c) 1995, 1996, Out && About Productions'
             +#10#13+ 'WWW: www.o2a.com'
             +#10#13+ 'email: 75664.1224@compuserve.com'
             +#10#13+ 'Fax: (415)695 9934'
             +#10#13+ ''
{$IFDEF WIN32}
             +#10#13+ 'TUTIL32.DLL Version '+  TTUtility(Component).VersionTU
{$ELSE}
             +#10#13+ 'TUTILITY.DLL Version '+  TTUtility(Component).VersionTU
{$ENDIF}
             +#10#13+ '        BDE Version '+  TTUtility(Component).VersionBDE,
             mtInformation,[mbOK],0);
end;

function TTutilityComponentEditor.GetVerb(Index: Integer): string;
begin
  result := 'Component Info';
end;

function TTutilityComponentEditor.GetVerbCount: Integer;
begin
  result := 1;
end;


{ TDBStringProperty and TDatabaseNameProperty are direct copies of the property
  editors of the same name in the DBReg.pas unit }

{ TDBStringProperty }

type
  TDBStringProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings); virtual; abstract;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TDBStringProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TDBStringProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

{ TDatabaseNameProperty }

type
  TDatabaseNameProperty = class(TDBStringProperty)
  public
    procedure GetValueList(List: TStrings); override;
  end;

procedure TDatabaseNameProperty.GetValueList(List: TStrings);
begin
  Session.GetDatabaseNames(List);
end;

procedure Register;
begin
  RegisterComponents('Paradox', [TTUtility]);
  RegisterComponents('Paradox', [TRepairDialog]);
  RegisterComponents('Paradox', [TVerifyDlg]);
  RegisterComponents('Paradox', [TRebuildDlg]);
  RegisterComponents('Paradox', [TIdxUtl]);
  RegisterComponentEditor(TTUtility,TTutilityComponentEditor);
{  RegisterComponentEditor(TIdxUtl,TTutilityComponentEditor); }
{  RegisterComponentEditor(TRepairDialog,TTutilityComponentEditor); }

  RegisterPropertyEditor(TypeInfo(TFileName), TRepairDialog, 'SourceDBName', TDatabaseNameProperty);
  RegisterPropertyEditor(TypeInfo(TFileName), TRepairDialog, 'BorrowDBName', TDatabaseNameProperty);
end;

end.


