{----------------------------------------------------------------------

  URL Label - very simple component, that lets you run URL or file
  by clicking on it. See UrlLabel.txt for more details and note about
  internet shortcuts mailto, ftp, http etc.

  Freeware - created by Ahto Tanner (www.estpak.ee/~ahto)
  Special thanks to Chad Z. Hower from Phoenix Business Enterprises

   Version 1.1, July 21, 1996 -- code corrected :)

   Version 1.0, June 21, 1996 -- initial release

-----------------------------------------------------------------------}

unit UrlLabel;

interface

uses
  Windows, SysUtils, Classes, Forms, StdCtrls, ShellAPI, buttons;

const
  crPoint = 5;

type
  TUrlLabel = class(TLabel)

  private
    fURL : string;
  protected
    procedure Click; override;
  public
    constructor Create( AOwner : TComponent ); override;
  published
    property URL: string read fURL write fURL;

end;

procedure Register;

implementation

{$R UrlLabel.res}

constructor TUrlLabel.Create( AOwner : TComponent );
begin
   inherited Create( AOwner );
   Screen.Cursors[ crDefault ] := LoadCursor( HInstance, 'POINT' );
   Cursor := crPoint;
end;

procedure TUrlLabel.Click;
var
   TempURL : string;

begin
   inherited Click;
   if Trim( fURL ) = '' then TempURL := Caption else TempUrl := fURL;
   if Trim( TempURL ) <> '' then
      ShellExecute( Application.Handle, 'open', PChar( TempURL ), nil, nil, SW_NORMAL );
end;

procedure Register;
begin
   RegisterComponents( 'Moon', [ TUrlLabel ] );
end;

end.
