unit Demo1s;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Vimsend, VimSess,
  vim,demo1s1;

type
  TForm1 = class(TForm)
    eMessage: TMemo;
    VimSession1: TVimSession;
    VimSendMessage1: TVimSendMessage;
    eSubject: TEdit;
    Memo2: TMemo;
    Label1: TLabel;
    Button1: TButton;
    Label2: TLabel;
    gPriority: TRadioGroup;
    eTO: TEdit;
    lTO: TListBox;
    eCC: TEdit;
    lCC: TListBox;
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure eTOExit(Sender: TObject);
    procedure eCCExit(Sender: TObject);
  private
    { Private declarations }
    procedure errShow;
  public

    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
begin
  gPriority.itemindex :=1;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  { be lazy and force the login dialog box to pop up }
    vimsession1.active := true;
    if not vimsession1.active then
      errshow;
    if vimsession1.vimerror <> 0 then
      errShow
    else with vimSendMessage1 do begin
      subject := eSubject.text;
      messageLines.clear;
      messageLines.assign(eMessage.lines);{ := eMessage.lines;}
      recipients.assign(lTO.items);
      {recipients := lTO.items;}
      cc := lCC.items;
      case gPriority.itemIndex of
        0 : priority := low;
        1 : priority := normal;
        2 : priority := urgent;
      end;
      send;
      if vimsession1.vimError <> 0 then
        errShow;
    end;
  {end;}

end;

procedure TForm1.errShow;
begin
  with Vimsession1 do begin
    errorDlg.errorMessage.text := errorMessage;
    errorDlg.extendedError.text := extendedError;
    errorDlg.applicationError.text := applicationError;
    errorDlg.showModal;
  end;
end;

procedure TForm1.eTOExit(Sender: TObject);
begin
  if lTO.items.indexof(eTO.text) = -1 then
    lTO.items.add(eTO.text);
end;

procedure TForm1.eCCExit(Sender: TObject);
begin
  if lCC.items.indexof(eCC.text) = -1 then
    lCC.items.add(eCC.text);
end;

end.
