unit Uexamp;

{   Web Document Retriever Ver 1.0                          }
{                                                           }
{   This application Require the WEB component developed    }
{   by Emanuele Cipolloni at Leviathan@dlep1.itg.ti.com     }
{                                                           }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Web, Gauges;

type
  TMain = class(TForm)
    Web1: TWeb;
    Container: TMemo;
    Retrieve: TButton;
    URL: TEdit;
    UseStream: TCheckBox;
    UseProxy: TCheckBox;
    Progress: TGauge;
    MimeInfo: TGroupBox;
    DocClass: TLabel;
    DocType: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    DocumentInfo: TGroupBox;
    Label12: TLabel;
    DocLen: TLabel;
    Label14: TLabel;
    DocSize: TLabel;
    Label15: TLabel;
    BytesLeft: TLabel;
    Label16: TLabel;
    Status: TLabel;
    DateAndTime: TGroupBox;
    Label17: TLabel;
    Label18: TLabel;
    ServerTime: TLabel;
    DocTime: TLabel;
    Proxy: TEdit;
    StreamName: TEdit;
    FDialog: TButton;
    SaveDialog1: TSaveDialog;
    ProxyPort: TEdit;
    Label19: TLabel;
    Abort: TButton;
    procedure RetrieveClick(Sender: TObject);
    procedure Web1Disconnect(Sender: TObject);
    procedure Web1Connect(Sender: TObject);
    procedure Web1Read(Sender: TObject);
    procedure Web1Info(Sender: TObject);
    procedure UseProxyClick(Sender: TObject);
    procedure FDialogClick(Sender: TObject);
    procedure UseStreamClick(Sender: TObject);
    procedure AbortClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Main: TMain;

implementation

{$R *.DFM}

procedure TMain.RetrieveClick(Sender: TObject);
begin
     Main.Status.Caption := 'Reaching Host';

     Main.Progress.Progress := 0;
     Main.Web1.Method := 'GET';
     Main.Web1.URL := Main.URL.Text;

     if Main.UseProxy.Checked then
     begin
        Main.Web1.UseProxy := True;
        Main.Web1.Proxy := Main.Proxy.Text;
        Main.Web1.ProxyPort := StrToInt(Main.ProxyPort.Text);
     end
     else
        Main.Web1.UseProxy := False;

     Main.Web1.UseStream := Main.UseStream.Checked;
     Main.Web1.UseFileStream := Main.UseStream.Checked;

     if Main.UseStream.Checked then
        if Main.StreamName.Text <> '' then
           Main.Web1.FileStreamName := Main.StreamName.Text;

     Main.Web1.Retrieve;
end;

procedure TMain.Web1Disconnect(Sender: TObject);
begin

     Main.Status.Caption := 'Ready';

     if not Main.UseStream.Checked then
     begin
          Main.Container.Clear;
          Main.Container.Lines.AddStrings(Main.Web1.Page);
          Main.Web1.PageClear;
     end;

     Main.Progress.Progress := 0;
end;

procedure TMain.Web1Connect(Sender: TObject);
begin
     Main.Status.Caption := 'Connecting';
end;

procedure TMain.Web1Read(Sender: TObject);
begin
     Main.Status.Caption := 'Reading';
     Main.DocSize.Caption := IntToStr(Main.Web1.Size);
     Main.BytesLeft.Caption := IntToStr(Main.Web1.BytesLeft);
     Main.Progress.Progress := Main.Web1.Completed;
end;

procedure TMain.Web1Info(Sender: TObject);
begin
     Main.DocClass.Caption := Main.Web1.DocClass;
     Main.DocType.Caption := Main.Web1.DocType;
     Main.DocLen.Caption := IntToStr(Main.Web1.DocLen);
     Main.ServerTime.Caption := Main.Web1.ServerDateTime;
     Main.DocTime.Caption := Main.Web1.DocDateTime;
end;

procedure TMain.UseProxyClick(Sender: TObject);
begin
     Main.Proxy.enabled := Main.UseProxy.Checked;
     Main.ProxyPort.enabled := Main.UseProxy.Checked;

end;

procedure TMain.FDialogClick(Sender: TObject);
begin
     Main.SaveDialog1.Execute;
     Main.StreamName.Text := Main.SaveDialog1.FileName;
     if Main.StreamName.Text = '' then
        Main.UseStream.State := cbUnchecked;
end;

procedure TMain.UseStreamClick(Sender: TObject);
begin
     Main.StreamName.Enabled := Main.UseStream.Checked;
     Main.FDialog.ENabled := Main.UseStream.Checked;
     if Main.UseStream.State = cbChecked then
        FDialogClick(Self);
end;

procedure TMain.AbortClick(Sender: TObject);
begin
     Main.web1.abort;
end;

end.
