unit Retrieve;

{   Wall Weather Ver 1.0                                    }
{                                                           }
{   This application Require the WEBGIF component developed }
{   by Emanuele Cipolloni at Leviathan@dlep1.itg.ti.com     }
{                                                           }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, INIFiles, Web, Globals,
  Setting, WebGif;

type
  TWeather = class(TForm)
    Timer1: TTimer;
    Panel1: TPanel;
    DoRetrieve: TButton;
    DCounter: TLabel;
    DTitle: TLabel;
    Label3: TLabel;
    Status: TLabel;
    Panel2: TPanel;
    Monitor: TImage;
    RetAbort: TButton;
    Config: TButton;
    Quit: TButton;
    WebGif1: TWebGif;
    procedure Timer1Timer(Sender: TObject);
    procedure WebGif1Connect(Sender: TObject);
    procedure WebGif1Read(Sender: TObject);
    procedure WebGif1Disconnect(Sender: TObject);
    procedure DoRetrieveClick(Sender: TObject);
    procedure ConfigClick(Sender: TObject);
    procedure QuitClick(Sender: TObject);
    procedure RetAbortClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Weather: TWeather;
  TimeCounter : integer;

procedure GetImage;
procedure Transform;

implementation

{$R *.DFM}

procedure TWeather.Timer1Timer(Sender: TObject);
begin
     { Wait 'til fixed Idle time elapsed then trigger image retrieving}
     Inc(TimeCounter);
     if TimeCounter > Idle then
     begin
        Weather.RetAbort.Enabled := True;
        GetImage;
     end;
end;

procedure TWeather.WebGif1Connect(Sender: TObject);
begin
     Status.Caption := 'Connecting...';
end;

procedure TWeather.WebGif1Read(Sender: TObject);
begin
     { Update retrieving info }
     DTitle.Caption := 'Size:';
     Status.Caption := 'Retrieving...';
     DCounter.Caption := IntToStr(WebGif1.size);
end;

procedure TWeather.WebGif1Disconnect(Sender: TObject);
begin
     Weather.RetAbort.Enabled := False;
     Transform;
end;

procedure TWeather.DoRetrieveClick(Sender: TObject);
begin
     Weather.RetAbort.Enabled := True;
     GetImage;
end;

procedure Transform;
var
   buffer : array[0..255] of char;
begin
     if Weather.WebGif1.Size > 0 then
          if Stamp then
          begin
               Weather.Status.Caption := 'Saving...';
               Weather.WebGif1.Bitmap.SaveToFile(WorkDir + 'europe.bmp');
               StrPCopy(Buffer,WorkDir + 'europe.bmp');
               SystemParametersInfo(SPI_SETDESKWALLPAPER,0,@Buffer,0);
          end;

     Weather.Monitor.Picture.Bitmap := Weather.WebGif1.Bitmap;
     Weather.Status.Caption := 'Waiting';
     Weather.Timer1.Enabled := True;
     Weather.DoRetrieve.Enabled := True;
end;

procedure GetImage;
begin
     TimeCounter := 0;

     with Weather do
     begin
          Timer1.Enabled := False;
          DoRetrieve.Enabled := False;
          Status.Caption := 'Initializing...';
     end;

     with Weather.WebGif1 do
     begin

          if UProxy then
          begin
               Proxy := ProxyName;
               ProxyPort := StrToInt(ProxyPortNumber);
               UseProxy := UProxy;
          end;

          URL := ImageURL;
     end;

     Weather.WebGif1.Retrieve;
end;

procedure TWeather.ConfigClick(Sender: TObject);
begin
     with Settings, WIni do
     begin
          UseProxy.Checked := ReadBool('Settings','UseProxy',False);
          PName.Text := ReadString('Settings','Proxy','');
          PPort.Text := ReadString('Settings','ProxyPort','');
          WDir.Text := ReadString('Settings','WorkDir','C:\');
          IURL.Text := ReadString('Settings','ImageURL','http://www.meteo.fr/tpsreel/images/satt0.gif');
          ICount.Value := ReadInteger('Settings','Idle',30);
          DoStamp.Checked := ReadBool('Settings','Stamp',True);
     end;

     Settings.ShowModal;
end;

procedure TWeather.QuitClick(Sender: TObject);
begin
     Application.Terminate;
end;

procedure TWeather.RetAbortClick(Sender: TObject);
begin
     Weather.WebGif1.Abort;
     Weather.RetAbort.Enabled := False;
end;

initialization
TimeCounter := 0;
with WIni do
begin
     UProxy := ReadBool('Settings','UseProxy',False);
     ProxyName := ReadString('Settings','Proxy','');
     ProxyPortNumber := ReadString('Settings','ProxyPort','');
     WorkDir := ReadString('Settings','WorkDir','C:\');
     ImageURL := ReadString('Settings','ImageURL','http://www.meteo.fr/tpsreel/images/satt0.gif');
     Idle := ReadInteger('Settings','Idle',30);
     Stamp := ReadBool('Settings','Stamp',True);
end;

end.
