unit Setting;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, IniFiles, Globals, ExtCtrls;

type
  TSettings = class(TForm)
    PName: TEdit;
    PPort: TEdit;
    Label2: TLabel;
    UseProxy: TCheckBox;
    Label1: TLabel;
    ICount: TSpinEdit;
    Label3: TLabel;
    Label4: TLabel;
    WDir: TEdit;
    DoStamp: TCheckBox;
    OK: TButton;
    Button2: TButton;
    Bevel1: TBevel;
    IURL: TEdit;
    Label5: TLabel;
    procedure OKClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Settings: TSettings;

implementation

{$R *.DFM}

procedure TSettings.OKClick(Sender: TObject);
begin
     with Settings, WIni do
     begin
          WriteBool('Settings','UseProxy',UseProxy.Checked);
          WriteString('Settings','Proxy',PName.Text);
          WriteString('Settings','ProxyPort',PPort.Text);
          WriteString('Settings','WorkDir',WDir.Text);
          WriteString('Settings','ImageURL',IURL.Text);
          WriteInteger('Settings','Idle',ICount.Value);
          WriteBool('Settings','Stamp',DoStamp.Checked);

          UProxy := ReadBool('Settings','UseProxy',False);
          ProxyName := ReadString('Settings','Proxy','');
          ProxyPortNumber := ReadString('Settings','ProxyPort','');
          WorkDir := ReadString('Settings','WorkDir','');
          ImageURL := ReadString('Settings','ImageURL','http://www.meteo.fr/tpsreel/images/satt0.gif');
          Idle := ReadInteger('Settings','Idle',30);
          Stamp := ReadBool('Settings','Stamp',True);
     end;

     ModalResult := mrOk;
end;

procedure TSettings.Button2Click(Sender: TObject);
begin
     ModalResult := mrCancel;
end;

end.
