unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, AaWizStd, AaWiz, StdCtrls;

type
  TForm1 = class(TForm)
    LoopWizard: TAAWizard;
    LoopQuestion: TAAOptionQuestion;
    StartQuestion: TAAPromptQuestion;
    AddQuestion: TAATextQuestion;
    EndQuestion: TAAPromptQuestion;
    RemoveQuestion: TAAPromptQuestion;
    ListBox1: TListBox;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure AddQuestionNext(Sender: TObject);
    procedure RemoveQuestionDataLoading(Sender: TObject);
    procedure RemoveQuestionNext(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  LoopWizard.Run;
end;

{ add a list item }
procedure TForm1.AddQuestionNext(Sender: TObject);
begin
  Listbox1.Items.Add(AddQuestion.Text);
end;

{ before the remove question is displayed, retrieve the listbox item that
  we can delete.  If there is no item that can be deleted, disable the
  wizard's Next button by setting the CanProceed property to false.  Note
  that this property is reset to true when the next question is loaded }
procedure TForm1.RemoveQuestionDataLoading(Sender: TObject);
begin
  if ListBox1.Items.Count > 0 then
    RemoveQuestion.PromptDetail := ListBox1.Items[ListBox1.Items.Count-1]
  else begin
    RemoveQuestion.PromptDetail := '<no item exists that can be removed>';
    LoopWizard.CanProceed := false;
  end;
end;

{ remove the last item in the listbox when after the user clicks "Next" for
  the remove question }
procedure TForm1.RemoveQuestionNext(Sender: TObject);
begin
  if ListBox1.Items.Count > 0 then
    ListBox1.Items.Delete(ListBox1.Items.Count-1);
end;

end.
