unit samdlg;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Menus, SysUtils,
  StdCtrls, Buttons,  Dialogs, ExtCtrls, AdDialog,
  AdRegSnd,  { This code handles the registry sound routines }
  MMSystem,  
  {$ifDef Win32}
  Registry,
  {$endif}
  Spin;


type
  TAdrockDialogSample = class(TForm)
    y: TBitBtn;
    AdrockDLG: TBitBtn;
    ButtonsGroupBox: TGroupBox;
    ButtonYes: TCheckBox;
    ButtonNo: TCheckBox;
    ButtonCancel: TCheckBox;
    ButtonAbort: TCheckBox;
    ButtonRetry: TCheckBox;
    ButtonIgnore: TCheckBox;
    ButtonOK: TCheckBox;
    ButtonALL: TCheckBox;
    ButtonHelp: TCheckBox;
    TimerGroupBox: TGroupBox;
    AutoTimer: TEdit;
    SoundGroupBox: TGroupBox;
    SoundNone: TRadioButton;
    SoundICONAsterisk: TRadioButton;
    SoundIconExclamation: TRadioButton;
    MouseGroupBox: TGroupBox;
    CursorDoNotMove: TRadioButton;
    CursorMove: TRadioButton;
    SoundIconHand: TRadioButton;
    SoundIconQuestion: TRadioButton;
    SoundOK: TRadioButton;
    Label1: TLabel;
    StyleGroupBox: TGroupBox;
    StylemtInformation: TRadioButton;
    StylemtConfimation: TRadioButton;
    StylemtWarning: TRadioButton;
    StyleMtError: TRadioButton;
    GetMessage: TEdit;
    WaveFileName: TEdit;
    SpeedButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    WaveFileRadioButton: TRadioButton;
    PositionGroupBox: TGroupBox;
    CenterOfScreenRadioButton: TRadioButton;
    CenterOfApplicationRadioButton: TRadioButton;
    BitBtn1: TBitBtn;
    FontDialog1: TFontDialog;
    DialogCaptions: TBitBtn;
    Button2: TBitBtn;
    SpinEdit1: TSpinEdit;
    Label2: TLabel;
    BitBtn2: TBitBtn;
    Bevel1: TBevel;
    Button1: TBitBtn;
    ButtonNoToAll: TCheckBox;
    ButtonYesToAll: TCheckBox;
    AdrockGroupBox1: TGroupBox;
    RegistrySounds: TComboBox;
    PlaySoundButton: TSpeedButton;
    Label3: TLabel;
    Label4: TLabel;
    NewEventButton: TBitBtn;
    RegistryFileName: TLabel;
    WindowsSoundsCheckBox: TRadioButton;
    AdrockSoundsCheckBox: TRadioButton;
    DeleteEventButton: TBitBtn;
    ChangeSoundButton: TBitBtn;
    OpenDialog2: TOpenDialog;
    RegistryButton: TRadioButton;
    Label5: TLabel;
    Label6: TLabel;
    DefaultYes: TRadioButton;
    DefaultCancel: TRadioButton;
    DefaultAbort: TRadioButton;
    DefaultRetry: TRadioButton;
    DefaultIgnore: TRadioButton;
    DefaultOK: TRadioButton;
    DefaultALL: TRadioButton;
    DefaultNoToAll: TRadioButton;
    DefaultYestoAll: TRadioButton;
    DefaultNo: TRadioButton;
    procedure yClick(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure AdrockDLGClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure WaveFileNameChange(Sender: TObject);
    procedure CenterOfScreenRadioButtonClick(Sender: TObject);
    procedure CenterOfApplicationRadioButtonClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure DialogCaptionsClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PlaySoundButtonClick(Sender: TObject);
    procedure RegistrySoundsChange(Sender: TObject);
    procedure WindowsSoundsCheckBoxClick(Sender: TObject);
    procedure AdrockSoundsCheckBoxClick(Sender: TObject);
    procedure ChangeSoundButtonClick(Sender: TObject);
    procedure NewEventButtonClick(Sender: TObject);
    procedure DeleteEventButtonClick(Sender: TObject);
  private
    { Private declarations }
    Procedure ShowMessageResult(Result : TAdrockMessageDialogModalResult);
  public
    { Public declarations }
    ShortRegistryKey, RegistryKey : String;
    Function GetButtons : TAdMsgDlgButtons;
    Function GetDefaultButton : TAdMsgDlgBtn;
    Function GetSound:Integer;
    Function GetStyle : TAdMsgDlgType;

    procedure RefreshRegistryDetails;
  end;

var
  AdrockDialogSample: TAdrockDialogSample;

implementation

{$R *.DFM}
{$R DLGTEST.RES}

procedure TAdrockDialogSample.yClick(Sender: TObject);
begin
     MessageDlg(getmessage.Text, mtInformation {GetStyle} , [mbNo] {GetButtons}, 0);
end;

procedure TAdrockDialogSample.BitBtn2Click(Sender: TObject);
begin
     FontDialog1.Font.Assign(TAdrockMessageDialogButtonFont);
     if (FontDialog1.Execute = TRUE) then
       TAdrockMessageDialogButtonFont.Assign(FontDialog1.Font);
end;

procedure TAdrockDialogSample.BitBtn4Click(Sender: TObject);
begin
     ShowMessageResult(MessageDialog('#4, Are you sure that you want to format your hard drive?',
     AdmtConfirmation, [AdmbAll, AdMbYes, AdMbNo, AdMbCancel, AdmbAbort, AdmbOK, AdmbRetry, AdmbIgnore, AdmbHelp],
     AdMbNo, MB_ICONEXCLAMATION, 5000, 0));
end;

procedure TAdrockDialogSample.AdrockDLGClick(Sender: TObject);
begin
  SetMessageDialogCursor((CursorDoNotMove.Checked = FALSE), FALSE);
  { This is the old way of playing a wave file you now can do this directly
  if (WaveFileRadioButton.Checked= TRUE)then
    ShowMessageResult(MessageDialogWave(getmessage.Text, getStyle,
      GetButtons, GetDefaultButton, WaveFileName.Text, StrToInt(AutoTimer.Text), 0))
  else
    ShowMessageResult(MessageDialog(getmessage.Text, getStyle,
        GetButtons, GetDefaultButton, GetSound, StrToInt(AutoTimer.Text), 0));
}
  if (WaveFileRadioButton.Checked= TRUE)then
    begin
      TAdrockMessageDialogPlayWaveFile := TRUE;
      TAdrockMessageDialogWaveFile := WaveFileName.Text;
      ShowMessageResult(MessageDialog(getmessage.Text, getStyle,
           GetButtons, GetDefaultButton, -1, StrToInt(AutoTimer.Text), 0));
    end
  else
    begin
      if (RegistryButton.Checked = TRUE) then
        SetupAdrockMessageDialogSound(TRUE, TRUE, 'Adrock\MessageDialog\'+RegistrySounds.Text);
      ShowMessageResult(MessageDialog(getmessage.Text, getStyle,
          GetButtons, GetDefaultButton, GetSound, StrToInt(AutoTimer.Text), 0));
    end;
end;

Function TAdrockDialogSample.GetStyle : TAdMsgDlgType;
begin
 if (StylemtInformation.Checked = TRUE) then
    Result := admtInformation
 else if (StylemtConfimation.Checked = TRUE) then
    Result := adMtConfirmation
 else if (StylemtWarning.Checked = TRUE) then
    Result := admtWarning
 else
    Result := admtError;
end;

Function TAdrockDialogSample.GetButtons : TAdMsgDlgButtons;
Var
  Res : TAdMsgDlgButtons;
begin
  Res := [];
  if (ButtonYes.Checked = TRUE) then
    Res := Res + [AdmbYes];
  if (ButtonNo.Checked = TRUE) then
    Res := Res + [AdmbNo];
  if (ButtonCancel.Checked = TRUE) then
    Res := Res + [AdmbCancel];
  if (ButtonAbort.Checked = TRUE) then
    Res := Res + [AdmbAbort];
  if (ButtonRetry.Checked = TRUE) then
    Res := Res + [AdmbRetry];
  if (ButtonIgnore.Checked = TRUE) then
    Res := Res + [AdmbIgnore];
  if (ButtonOK.Checked = TRUE) then
    Res := Res + [AdmbOK];
  if (ButtonAll.Checked = TRUE) then
    Res := Res + [AdmbAll];
  if (ButtonHelp.Checked = TRUE) then
    Res := Res + [AdmbHelp];
  if (ButtonYesToAll.Checked = TRUE) then
    Res := Res + [AdmbYesToAll];
  if (ButtonNoToAll.Checked = TRUE) then
    Res := Res + [AdmbNoToAll];
  Result := RES;
end;

Function TAdrockDialogSample.GetDefaultButton : TAdMsgDlgBtn;
begin
     if (DefaultYes.Checked = TRUE) then
      result := AdmbYes
     else if (DefaultNo.Checked = TRUE) then
      result := AdmbNo
     else if (DefaultCancel.Checked = TRUE) then
      result := AdmbCancel
     else if (DefaultAbort.Checked = TRUE) then
      result := AdmbAbort
     else if (DefaultRetry.Checked = TRUE) then
      result := AdmbRetry
     else if (DefaultIgnore.Checked = TRUE) then
      result := AdmbIgnore
     else if (DefaultOK.Checked = TRUE) then
      result := AdmbOK
     else if (DefaultALL.Checked = TRUE) then
      result := AdmbAll
     else if (DefaultYesToAll.Checked = TRUE) then
      result := AdmbYesToAll
     else if (DefaultNoToAll.Checked = TRUE) then
      result := AdmbNoToAll;
end;


Function TAdrockDialogSample.GetSound:Integer;
begin
  if (SoundNone.Checked = TRUE) or (RegistryButton.Checked = TRUE) then
   result := -1
  else if (SoundICONAsterisk.Checked = TRUE) then
    Result := MB_ICONASTERISK
  else if (SoundIconExclamation.Checked = TRUE) then
    Result := MB_ICONEXCLAMATION
  else if (SoundIconhAND.Checked = TRUE) then
    Result := MB_ICONHAND
  else if (SoundIconQuestion.Checked = TRUE) then
    Result := MB_ICONQuestion
  else
    Result := MB_OK;
end;

Procedure TAdrockDialogSample.ShowMessageResult(Result : TAdrockMessageDialogModalResult);
begin
   Case Result of
     AdmrYes      : informationBox('AdmrYes');
     AdmrNo       : informationBox('AdmrNo');
     AdmrOK       : informationBox('AdmrOK');
     AdmrCancel   : informationBox('AdmrCancel');
     AdmrAbort    : informationBox('AdmrAbort');
     AdmrRetry    : informationBox('AdmrRetry');
     AdmrIgnore   : informationBox('AdmrIgnore');
     AdmrAll      : informationBox('AdmrAll');
     AdmrYesToAll : informationBox('AdmrYesToAll');
     AdmrNoToAll  : informationBox('AdmrNoToAll');
   end;
end;

procedure TAdrockDialogSample.SpeedButton1Click(Sender: TObject);
begin
  OpenDialog1.FileName := WaveFileName.Text;
  if (OpenDialog1.Execute = TRUE) then
   begin
     WaveFileRadioButton.Checked := TRUE;
     WaveFileName.Text := OpenDialog1.FileName;
   end;
end;

procedure TAdrockDialogSample.WaveFileNameChange(Sender: TObject);
begin
       WaveFileRadioButton.Checked := TRUE;
end;

procedure TAdrockDialogSample.CenterOfScreenRadioButtonClick(Sender: TObject);
begin
     ModifyTAdrockMessageDialogPopupPosition(TRUE, AdrockMessageDialogCenterToScreen);
end;

procedure TAdrockDialogSample.CenterOfApplicationRadioButtonClick(Sender: TObject);
begin
     ModifyTAdrockMessageDialogPopupPosition(TRUE, AdrockMessageDialogCenterToApplication);
end;

procedure TAdrockDialogSample.BitBtn1Click(Sender: TObject);
begin
     FontDialog1.Font.Assign(TAdrockMessageDialogFont);
     if (FontDialog1.Execute = TRUE) then
       TAdrockMessageDialogFont.Assign(FontDialog1.Font);
end;

procedure TAdrockDialogSample.DialogCaptionsClick(Sender: TObject);
Var
  fglyph : TBitmap;
begin
     { Modify the dialog caption for the next ,tConfirmation Dialog that gets opened }
     ModifyTAdrockMessageDialogCaption(FALSE, AdmtConfirmation, 'Please confirm...');

     { Modify the caption for the buttons }
     ModifyTAdrockMessageDialogButtonCaption(FALSE, AdmbYes, 'Backup');
     ModifyTAdrockMessageDialogButtonCaption(FALSE, AdmbNo,  'Exit');

     ModifyTAdrockMessageDialogButtonGlyphFromResource(AdmbNo, 'TEST_BITMAP', 2);
     ModifyTAdrockMessageDialogButtonGlyphFromResource(AdmbYes, 'TEST_BITMAP1', 2);

     if (TAdrockMessageDialogModalResult(QueryBox('As you can see, we have modified the captions of the two buttons below and the caption of the Dialog!'+
        #13+#13+'We have also changed the button glyphs!'+
        #13+#13+'Please make a selection?', admbYes)) = admrNo) then
       InformationBox('Your selection was AdmrNo, AdmrNo had the caption "Exit"')
     else
       InformationBox('Your selection was AdmrYes, AdmrYes had the caption "Backup"');

     { So with very simple code you can make simple dialogs with better button captions }
end;

procedure TAdrockDialogSample.Button2Click(Sender: TObject);
begin
  BuildTAdrockMessageDialogLine('The TAdrockMessageDialog now supports large dialogs, that is dialogs with more than ');
  BuildTAdrockMessageDialogLine('255 characters of text. The dialog supports up to 16000 bytes of text in the dialog, ');
  BuildTAdrockMessageDialogLine('probally more than would display on the screen.'+#13);

  BuildTAdrockMessageDialogLine(#13);

  BuildTAdrockMessageDialogLine('When using the large dialogs you must call BuildTAdrockMessageDialogLine() ');
  BuildTAdrockMessageDialogLine('passing a string of text to add to the dialog. You must include a #13 or chr(13) to ');
  BuildTAdrockMessageDialogLine('force a line break, as all lines are concatinated together.'+#13);

  BuildTAdrockMessageDialogLine(#13);

  BuildTAdrockMessageDialogLine('You can do a lot of things with a large dialog, display someones details and prompt for ');
  BuildTAdrockMessageDialogLine('the user to do something.'+#13);

  BuildTAdrockMessageDialogLine(#13);

  BuildTAdrockMessageDialogLine('Adrock Software : '+#13#13);
  BuildTAdrockMessageDialogLine(#9+'P.O. Box 13-155'+#13#9+'Christchurch'+#13#9+'New Zealand'+#13#13#13);
  BuildTAdrockMessageDialogLine('Phone'+#9+'64 3 3651-112'+#13);
  BuildTAdrockMessageDialogLine('Fax'+#9+'64 3 3651-112'+#13);

  BuildTAdrockMessageDialogLine(#13);

  BuildTAdrockMessageDialogLine('You will notice that this dialog has two buttons, but the buttons are not standard, they ');
  BuildTAdrockMessageDialogLine('have had their captions modified, and their widths changed. The dialog has been set to ');
  BuildTAdrockMessageDialogLine('open with its width set to '+IntToStr(SpinEdit1.Value)+'% of the Screen Width'+#13);

  BuildTAdrockMessageDialogLine(#13);

  BuildTAdrockMessageDialogLine('Well you must be a keen reader if you got here, please contact us at Sales@Adrock.COM ');
  BuildTAdrockMessageDialogLine('(Internet) or 770135,110 (CompuServe) if you have any queries.');

  { Modify the mbYes button Caption }
  ModifyTAdrockMessageDialogButtonCaption(FALSE, AdMbYes, 'Source');

  { Modify the mbNo button Caption }
  ModifyTAdrockMessageDialogButtonCaption(FALSE, AdMbNo, 'Continue');

  { Resize the Dialog Button Widths }
  TAdrockMessageDialogBtnSize.X := 85;
  BuildTAdrockMessageDialogShow('Please Read On...', AdmtConfirmation, [AdmbYes, AdmbNo], admbYes, -1,-1,-1);
end;

procedure TAdrockDialogSample.Button3Click(Sender: TObject);
begin
  InformationBox('Well since it stinks, tell us why, please Email us at : DHMCC@IBM.Net'+#13#13+
           'Thanks in advance, Chris'+#13+'Adrock Software Development Team');
end;

procedure TAdrockDialogSample.SpinEdit1Change(Sender: TObject);
begin
   { Modify the width of the dialog as a percentage of the screen width }
   ModifyTAdrockMessageDialogOpeningPercentage(TRUE, (Sender as TSpinEdit).Value);
end;



procedure TAdrockDialogSample.Button1Click(Sender: TObject);
begin
   BuildTAdrockMessageDialogLine('{ Modify the dialog caption for the next ,tConfirmation Dialog that gets opened }'+#13);
   BuildTAdrockMessageDialogLine('ModifyTAdrockMessageDialogCaption(FALSE, mtConfirmation, ''Please confirm...'');'+#13);
   BuildTAdrockMessageDialogLine(''+#13);
   BuildTAdrockMessageDialogLine('{ Modify the caption for the buttons }'+#13);
   BuildTAdrockMessageDialogLine('ModifyTAdrockMessageDialogButtonCaption(FALSE, mbYes, ''Backup'');'+#13);
   BuildTAdrockMessageDialogLine('ModifyTAdrockMessageDialogButtonCaption(FALSE, mbNo,  ''Exit'');'+#13);
   BuildTAdrockMessageDialogLine(''+#13);
   BuildTAdrockMessageDialogLine('ModifyTAdrockMessageDialogButtonGlyphFromResource(mbNo, ''TEST_BITMAP'', 2);'+#13);
   BuildTAdrockMessageDialogLine('ModifyTAdrockMessageDialogButtonGlyphFromResource(mbYes, ''TEST_BITMAP1'', 2);'+#13);
   BuildTAdrockMessageDialogLine(#13);
   BuildTAdrockMessageDialogLine('if (QueryBox(''As you can see, we have modified the captions of the two buttons below and the caption of the Dialog!''+'+#13);
   BuildTAdrockMessageDialogLine('  #13+#13+''We have also changed the button glyphs!''+'+#13);
   BuildTAdrockMessageDialogLine('  #13+#13+''Please make a selection?'', mbYes) = mrNo) then'+#13);
   BuildTAdrockMessageDialogLine('  InformationBox(''Your selection was AdmrNo, AdmrNo had the caption "Exit"'')'+#13);
   BuildTAdrockMessageDialogLine('else'+#13);
   BuildTAdrockMessageDialogLine('   InformationBox(''Your selection was AdmrYes, AdmrYes had the caption "Backup"'');'+#13);
   BuildTAdrockMessageDialogLine(''+#13);
   BuildTAdrockMessageDialogShow('Please Read On...', AdmtConfirmation, [AdmbYes, AdmbNo], AdmbYes, -1,-1,-1);
end;




procedure TAdrockDialogSample.RefreshRegistryDetails;
{$ifdef WIN32}
Var
  fRegistry : TRegistry;
  Pos       : INteger;
  fList     : TStrings;
begin
  RegistrySounds.ITems.Clear;
  fList := TStringList.create;
  fRegistry := TRegistry.Create;
  try
    RegistrySounds.Items.AddObject('(None)',tobject(0));
    if (WindowsSoundsCheckBox.Checked = TRUE) then
      ShortRegistryKey := '.Default'
    else
      ShortRegistryKey := 'Adrock\MessageDialog';
    RegistryKey := 'AppEvents\Schemes\Apps\'+ShortRegistryKey;
    if (fRegistry.OpenKey(RegistryKey, False) = TRUE) then
      begin
         fRegistry.GetKeynames(fList);
         for Pos := 0 to fList.Count-1 do
           RegistrySounds.Items.AddObject(fList.Strings[Pos],tobject(Pos));
      end;
  finally;
    fRegistry.Free;
    fList.Free;
  end;
end;
{$else}
begin
  RegistrySounds.ITems.Clear;
  RegistrySounds.Items.AddObject('(None)',tobject(0));
end;
{$endif}


procedure TAdrockDialogSample.FormCreate(Sender: TObject);
begin
  RefreshRegistryDetails;

  if (ReturnRegistrySoundPath('Adrock\MessageDialog\Open') = '') then
    SetRegistrySoundPath('Adrock\MessageDialog\Open', '');
  if (ReturnRegistrySoundPath('Adrock\MessageDialog\Close') = '') then
    SetRegistrySoundPath('Adrock\MessageDialog\Close', '');
  if (ReturnRegistrySoundPath('Adrock\MessageDialog\DialogOpen') = '') then
    SetRegistrySoundPath('Adrock\MessageDialog\DialogOpen', '');
  if (ReturnRegistrySoundPath('Adrock\MessageDialog\DialogClose') = '') then
    SetRegistrySoundPath('Adrock\MessageDialog\DialogClose', '');
  if (ReturnRegistrySoundPath('Adrock\MessageDialog\DatabaseError') = '') then
    SetRegistrySoundPath('Adrock\MessageDialog\DatabaseError', '');
  if (ReturnRegistrySoundPath('Adrock\MessageDialog\PrinterError') = '') then
    SetRegistrySoundPath('Adrock\MessageDialog\PrinterError', '');
  if (ReturnRegistrySoundPath('Adrock\MessageDialog\ReportStarted') = '') then
    SetRegistrySoundPath('Adrock\MessageDialog\ReportStarted', '');
  if (ReturnRegistrySoundPath('Adrock\MessageDialog\ReportComplete') = '') then
    SetRegistrySoundPath('Adrock\MessageDialog\ReportComplete', '');
  if (ReturnRegistrySoundPath('Adrock\MessageDialog\BackupStarted') = '') then
    SetRegistrySoundPath('Adrock\MessageDialog\BackupStarted', '');
  if (ReturnRegistrySoundPath('Adrock\MessageDialog\BackupComplete') = '') then
    SetRegistrySoundPath('Adrock\MessageDialog\BackupComplete', '');
end;

procedure TAdrockDialogSample.PlaySoundButtonClick(Sender: TObject);
Var
  fName : String;
begin
  if (RegistrySounds.ItemIndex < 1) then
    WarningBox('Unable to play nothing!, please select a registry entry!')
  else
    begin
       fName := RegistrySounds.Items.Strings[RegistrySounds.ItemIndex];
       PlayRegistrySound(ShortRegistryKey+'\'+fName, snd_ASync);
    end;
end;

procedure TAdrockDialogSample.RegistrySoundsChange(Sender: TObject);
Var
  fpath, fName : String;
begin

  if (RegistrySounds.ItemIndex = -1) then
    exit;
  fName := RegistrySounds.Items.Strings[RegistrySounds.ItemIndex];
  fpath := ReturnRegistrySoundPath(ShortRegistryKey+'\'+fName);
  PlaySoundButton.Enabled := (fPath > '');
  if (fPath = '') then
   fpath := '(Not Specified)';
  RegistryFileName.Caption := fPath;
end;

procedure TAdrockDialogSample.WindowsSoundsCheckBoxClick(Sender: TObject);
begin
  RegistryFileName.Caption := '';
  DeleteEventButton.Enabled := FALSE;
  ChangeSoundButton.Enabled := FALSE;
  NewEventButton.Enabled := FALSE;
  RefreshRegistryDetails;
  RegistrySoundsChange(Sender);
end;

procedure TAdrockDialogSample.AdrockSoundsCheckBoxClick(Sender: TObject);
begin
  RegistryFileName.Caption := '';
  DeleteEventButton.Enabled := TRUE;
  ChangeSoundButton.Enabled := TRUE;
  NewEventButton.Enabled := TRUE;
  RefreshRegistryDetails;
  RegistrySoundsChange(Sender);
end;

procedure TAdrockDialogSample.ChangeSoundButtonClick(Sender: TObject);
Var
 Key : String;
 fpath, fname : String;
begin
     fName := RegistrySounds.Items.Strings[RegistrySounds.ItemIndex];
     fpath := ReturnRegistrySoundPath(ShortRegistryKey+'\'+fName);
     OpenDialog2.FileName := fPath;
     if (OpenDialog2.Execute = TRUE) then
       begin
         Key := 'Adrock\MessageDialog\'+RegistrySounds.Items.Strings[RegistrySounds.ItemIndex];
         SetRegistrySoundPath(Key, OpenDialog2.FileName);
         RegistrySoundsChange(Sender);
       end;
end;

procedure TAdrockDialogSample.NewEventButtonClick(Sender: TObject);
Var
  NewEventName : String;
begin
  if (InputQuery('New Event','Name of New Event', NewEventName) = TRUE) and (NewEventname <> '') then
    begin
      if (RegistrySounds.Items.IndexOf(newEventName) <> -1) then
        begin
          WarningBox('That event name already exists!');
          exit;
        end;

      SetRegistrySoundPath('Adrock\MessageDialog\'+NewEventName, '');
      RefreshRegistryDetails;
      RegistrySounds.ItemIndex := RegistrySounds.Items.IndexOf(newEventName);
      RegistrySoundsChange(Sender);
    end;
end;

procedure TAdrockDialogSample.DeleteEventButtonClick(Sender: TObject);
Var
  EventName : String;
begin
  EventName := RegistrySounds.Items.Strings[RegistrySounds.ItemIndex];
  if (QueryBox('Are you sure that you want to delete event "'+EventName+'"', admbNo) = admrYes) then
     if (DeleteRegistrySoundPath('Adrock\MessageDialog\'+EventName) = TRUE) then
       begin
        RefreshRegistryDetails;
        RegistrySoundsChange(Sender);
      end;
end;

end.

