unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  audio, StdCtrls, ExtCtrls, mmsystem;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Panel1: TPanel;
    WaveIn1: TWaveIn;
    WaveOut1: TWaveOut;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure WaveIn1WaveInData(Data: PChar; Size: Integer);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure WaveOut1WaveOutDone(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure WaveIn1BeforeOpen(var WaveFormat: Pointer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses msacm32;

Var
 i : integer;
 PAudioBuf, AudioBuf : PChar;

{$R *.DFM}

 pafd  : TACMFORMATDETAILSA;
// GSMWaveFormat : TGSM610WaveFormat;
 GSMWaveFormat : TTRUESPEECHWAVEFORMAT ;

function acmFormatEnumCallback(hadid : THANDLE;pafd : PACMFORMATDETAILSA; dwInstance, fdwSupport : DWORD ):BOOL; stdcall;
begin
  Result := True;             {WAVE_FORMAT_DIGISTD}
  if pafd.pwfx^.wFormatTag = WAVE_FORMAT_GSM610 then begin
     move(pafd.pwfx^, GSMWaveFormat, sizeof(GSMWaveFormat));
     Result := False;
  end;

end;

procedure TForm1.WaveIn1BeforeOpen(var WaveFormat: Pointer);
var
 i,
 MaxSizeFormat : integer;
begin
  acmMetrics(0, ACM_METRIC_MAX_SIZE_FORMAT, @MaxSizeFormat);
  pafd.cbStruct := sizeof(pafd);
  pafd.dwFormatTag := 0;
  getmem(pafd.pwfx, MaxSizeFormat);
  pafd.cbWfx := MaxSizeFormat;
  with PWaveFormatEx(pafd.pwfx)^ do begin
   wFormatTag := WAVE_FORMAT_PCM;
   nChannels := 1;
   nSamplesPerSec := WaveIn1.Samples;
   nAvgBytesPerSec:= WaveIn1.Samples; { for buffer estimation }
   nBlockAlign:=1;      { block size of data }
   wbitspersample := 8;
   //cbSize := 0;
  end;


  move(PWaveFormatEx(pafd.pwfx)^, GSMWaveFormat, sizeof(GSMWaveFormat));

  i := acmFormatEnumA(0, @pafd, acmFormatEnumCallback, hInstance, ACM_FORMATENUMF_CONVERT);

  if i = 0 then begin
     // Open the audio device with the GSM Wave Format structure
     // You must open the waveout component with the same WaveFormat structure
     // WRITE YOUR CODE FOR THE ABOVE
     // I'm always here for questions
     //
     WaveFormat := @GSMWaveFormat;
  end;

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 GetMem(AudioBuf, 200000);
 PAudioBuf := AudioBuf;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 FreeMem(AudioBuf);
end;

procedure TForm1.WaveIn1WaveInData(Data: PChar; Size: Integer);
begin
  inc(I, Size);
  Panel1.Caption := Format('%d Bytes recorded', [i]);
  move(Data^, PAudioBuf^, size);
  inc(PAudioBuf, Size);
end;

procedure TForm1.Button3Click(Sender: TObject);
Var
 Size : Integer;
begin
  Size := Abs(Integer(PAudioBuf) - Integer(AudioBuf) ) ;
  PAudioBuf := AudioBuf;
  WaveOut1.Open;
  WaveOut1.PlayBack(AudioBuf, Size);
end;

procedure TForm1.WaveOut1WaveOutDone(Sender: TObject);
begin
  WaveOut1.Close;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 i := 0;
 // You may use WaveIn1.Open method also 
 wavein1.Recording := True;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 wavein1.Recording := False;
end;


end.
