unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Shlobj,
  StdCtrls, BrowseFolder, ExtCtrls;

type
  TMainForm = class(TForm)
    Button1: TButton;
    DirectoryEdit: TEdit;
    BrowseFolder1: TBrowseFolder;
    Label1: TLabel;
    Button2: TButton;
    RadioGroup1: TRadioGroup;
    procedure Button1Click(Sender: TObject);
    procedure BrowseFolder1CustomButtonClick(Sender: TBrowseFolder;
      DialogHandle: Integer);
    procedure Button2Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.Button1Click(Sender: TObject);
begin
	if BrowseFolder1.Execute then
		DirectoryEdit.Text:=BrowseFolder1.Directory;
end;

procedure TMainForm.BrowseFolder1CustomButtonClick(Sender: TBrowseFolder; DialogHandle: Integer);
begin
	MessageDlg('This is a custom button that lets you control its type, width, enabled state, caption, and action taken when pressed.'+#13#10#13#10+'Current directory is '+Sender.SelectedDirectory,mtInformation,[mbOK],0);
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
	Close;
end;

procedure TMainForm.RadioGroup1Click(Sender: TObject);
begin
  case RadioGroup1.ItemIndex of
    0:
      begin
        BrowseFolder1.CustomButtonType:=btPushButton;
        BrowseFolder1.CustomButtonCaption:='&Path';
        BrowseFolder1.CustomButtonWidth:=75;
      end;

    1:
      begin
        BrowseFolder1.CustomButtonType:=btCheckBox;
        BrowseFolder1.CustomButtonCaption:='&This is a check box';
        BrowseFolder1.CustomButtonWidth:=125;
      end;
  end;
end;

end.
