unit Ctdemou;

{EXAMPLES OF USING CenTree TO CONTROL ACCESS}
{
{ {RUTHLESS! ----------------------------------------------------------------}
{procedure MainForm.FormCreate(Sender: TObject);
{begin
{  if not CenTree1.Execute then application.terminate;
{end;
{
{ {CRIPPLEWARE : ------------------------------------------------------------}
{procedure MainForm.FormCreate(Sender: TObject);
{begin
{  CenTree1.Execute;
{end;
{procedure MainForm.FormShow(Sender: TObject);
{begin
{  addbtn.enabled:=CenTree1.OK;
{  deletebtn.enabled:=CenTree1.OK;
{  checkbox1.enabled:=CenTree1.OK;
{  checkbox2.enabled:=CenTree1.OK;
{end;
{
{ {MULTI-LEVEL LOCKING : ----------------------------------------------------}
{procedure TCTdemoF.Button5Click(Sender: TObject);
{begin
{  centree2.execute;   {Status of second CenTree lock not tested until now}
{  setregstatus;       {Routine to reset buttons etc as result of test}
{end;

{
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Spin, Menus, Centree;

type
  TCTdemoF = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Button1: TButton;
    Panel4: TPanel;
    Panel5: TPanel;
    Button2: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    Panel6: TPanel;
    Button3: TButton;
    MainMenu1: TMainMenu;
    Exit1: TMenuItem;
    SubMenu1: TMenuItem;
    Deregister1: TMenuItem;
    CenTree1: TCenTree;
    CenTree2: TCenTree;
    Panel7: TPanel;
    Panel8: TPanel;
    Button4: TButton;
    CheckBox3: TCheckBox;
    GroupBox3: TGroupBox;
    RadioButton7: TRadioButton;
    RadioButton8: TRadioButton;
    RadioButton9: TRadioButton;
    Button5: TButton;
    Unlock: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  CTdemoF: TCTdemoF;

implementation

uses Inifiles;

{$R *.DFM}
procedure setregstatus;
begin
 with CTdemoF do
 begin
  radiobutton1.checked:=true;
  radiobutton3.checked:=false;
  radiobutton3.checked:=false;
  radiobutton4.checked:=false;
  radiobutton5.checked:=false;
  radiobutton6.checked:=false;
  radiobutton7.checked:=false;
  radiobutton8.checked:=false;
  radiobutton9.checked:=false;
  case CenTree1.OK of
  true : begin
           radiobutton7.checked:=true;
           panel1.color:=clGreen;
           panel1.caption:='Registered';
           submenu1.caption:='Enabled';
           panel8.caption:='Unlocked at level 1';
           if Centree2.OK then
             panel5.caption:='Unlocked at level 2'
           else
             panel5.caption:='Locked at level 2';

         end;
  false: begin
           radiobutton4.checked:=false;
           radiobutton7.checked:=false;
           panel1.color:=clRed;
           panel1.caption:='Unregistered';
           submenu1.caption:='Disabled';
           panel8.caption:='Locked at level 1';
           panel5.caption:='Locked at level 2';
         end;
  end;
  button4.enabled:=CenTree1.OK;
  button2.enabled:=CenTree1.OK and CenTree2.OK;
  checkbox3.enabled:=CenTree1.OK;
  checkbox2.enabled:=CenTree1.OK and CenTree2.OK;
  groupbox3.enabled:=CenTree1.OK;
  groupbox2.enabled:=CenTree1.OK and CenTree2.OK;
  button3.visible:=CenTree1.OK;   {Deregister button}
  button5.visible:=CenTree1.OK;   {Level 2 button}
  submenu1.enabled:=CenTree1.OK;
  deregister1.visible:=CenTree1.OK;
  unlock.visible:=CenTree1.OK and not CenTree2.OK;
 end;
end;



procedure TCTdemoF.FormCreate(Sender: TObject);
begin
  CenTree1.execute;
end;

procedure TCTdemoF.FormShow(Sender: TObject);
begin
  setregstatus;
end;

procedure TCTdemoF.Button3Click(Sender: TObject);
var
  Ini: TIniFile;
begin
 try
   Ini := TIniFile.Create('CTDEMO.INI');
   Ini.WriteString('CenTree', 'CenTree1', '00000000');
   Ini.WriteString('CenTree', 'CenTree2', '00000000');
 finally
   Ini.Free;
 end;
 CenTree1.execute;
 setregstatus;
end;


procedure TCTdemoF.Exit1Click(Sender: TObject);
begin
   Application.terminate;
end;

procedure TCTdemoF.Button5Click(Sender: TObject);
begin
  centree2.execute;
  setregstatus;
end;

end.
