unit Cybparnt;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, dsgnintf, cybabout, Cfrminfo;

type
  tCYBAboutParentInfoedit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;


  tCYBParentInfoedit = class(tAboutpropedit)
public
    procedure Edit;  override;
  end;

  tCyborgParentInfo = class(TGraphicControl)
  private
    { Private declarations }
   cbmp : tbitmap;

  protected
    { Protected declarations }
   Function GetAbout : string;
   Function GetParentage : tcontrol;
   procedure setabout(anystr : string);
   procedure setParentage(aParentage : tcontrol) ;
   procedure Paint; override;

  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

  published
    { Published declarations }
   Property About : string Read GetAbout write setabout;
   Property Parentage : tcontrol Read GetParentage Write SetParentage ;

  end;

procedure register;

implementation

constructor tCyborgParentInfo.Create(AOwner: TComponent);
begin
  inherited create(aowner);
  parent := twincontrol(aowner);
  cbmp := tbitmap.create;
  cbmp.Handle := LoadBitmap(HInstance, 'TCYBORGPARENTINFO');
  width := 24;
  height := 24;
end;

destructor tCyborgParentInfo.Destroy;
begin
  deleteobject(cbmp.handle);
  cbmp.free;
  inherited destroy;
end;

procedure tCyborgParentInfo.Paint;

begin
   if (componentstate = [csdesigning]) then
    with (owner as tform).canvas do begin
      draw(left, top, cbmp);
   end;
end;

Function tCyborgParentInfo.GetAbout : string;
Begin
End;

procedure tCyborgParentInfo.setabout(anystr : string);
Begin
End;

Function tCyborgParentInfo.GetParentage : tcontrol;
Begin
   Result := (self.owner as tcontrol);
End;

procedure tCyborgParentInfo.setParentage(aParentage : tcontrol) ;
Begin
End;


procedure tCYBAboutParentInfoedit.Edit;
var
  tbmp : tbitmap;
  dum : bool;

begin
   AboutBox := TAboutBox.create(application);
   tbmp := tbitmap.create;
   with aboutbox do begin
try
      prodnametext := 'CybParentInfo';
      yeartext := '';
      Boxcaptiontext := 'About CybParentInfo';
      versiontext := 'Freeware Nov 1995';
      vercommenttext := 'No Owner Draw';
      tbmp.handle := LoadBitmap(HInstance, 'TCYBORGPARENTINFO');
      ICONBMP := tbmp;
      execute;
finally
      free;
      dum := deleteobject(tbmp.handle);
      tbmp.free;
end;
  end;
end;

procedure tCYBParentInfoedit.Edit;

begin
   showparentage(tcontrol(getordvalue));
end;


procedure register;

begin
   RegisterComponents('Boris', [tCyborgParentInfo]);
   RegisterPropertyEditor( typeinfo(STRING), tCyborgParentInfo, 'About', tCYBAboutParentInfoedit);
   RegisterPropertyEditor( typeinfo(tcontrol), tCyborgParentInfo, 'Parentage', tCYBParentInfoedit);
end;

end.
