unit Ddetest1;

{*
** This projects demonstrates the use of the DDEAuto visual component.
** Each of DDEAuto's Ten functions are demonstrated in this project.
** To register DDEAuto on Compuserve GO SWREG 9278 or Visit our Web
** site at http://users.aol.com/branhamtch/main.htm and look at our product
** catalog.
*}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DdeMan, Ddeauto,DDeTest2,DDeTest3;

type
  TfmMain = class(TForm)
    cbGroups: TComboBox;
    cbItems: TComboBox;
    mcAuditMemo: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    btDeleteGroup: TButton;
    btCreateGroup: TButton;
    GroupBox2: TGroupBox;
    btAddItem: TButton;
    btDeleteItem: TButton;
    btChangeItem: TButton;
    btMoveItem: TButton;
    Label3: TLabel;
    btShowGroup: TButton;
    DDEAuto1: TDDEAuto;
    procedure btCreateGroupClick(Sender: TObject);
    procedure btDeleteGroupClick(Sender: TObject);
    procedure btAddItemClick(Sender: TObject);
    procedure btDeleteItemClick(Sender: TObject);
    procedure cbGroupsChange(Sender: TObject);
    procedure btChangeItemClick(Sender: TObject);
    procedure btMoveItemClick(Sender: TObject);
    procedure cbItemsChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btShowGroupClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation

{$R *.DFM}

procedure TfmMain.btCreateGroupClick(Sender: TObject);
var
   groupName: string;
begin
{*
** Let's create a group! This project has a form named fmGroupMan, This is NOT
** part of the DDEAuto component!  This form was created for this project.
** Anyway, let's get the user's input for what the new group name should be
** named.
*}
 fmGroupMan.GetGroupName(groupName);

{*
** If the user pressed OK rather than CANCEL, let's use the DDEAuto function
** DDECreateGroup and pass it the group name to be created.
** Specifyu the following:
**                     The name of the group to create
*}
 if fmGroupMan.ModalResult=mrOK then
     DDEAuto1.DDECreateGroup(groupName);
end;

procedure TfmMain.btDeleteGroupClick(Sender: TObject);
begin
{*
** Let's ask the user if they are sure they want to delete this group
*}
     if MessageDlg('Are you sure you want to delete this group ['+cbGroups.Text+']?',
                   mtConfirmation,[mbYes,mbNo],1)=mrYes then
     begin
     {*
     ** If the user is sure this group should be deleted, use the DDEAuto function
     ** DDEDeleteGroup to delete the group from progman.
     ** Specify the following:
     **                       The name of the group to delete
     *}
       DDEAuto1.DDEDeleteGroup(cbGroups.Text);
       {*
       ** Just for grins and giggles, let's redisplay our group and item list.
       *}
       cbGroups.Items.Clear;
       DDEAuto1.DDEGetGroups(cbGroups.Items);
       cbGroups.ItemIndex:=0;

       {*
       ** Redisplay the Item List
       *}
       cbItems.Items.Clear;
       DDEAuto1.DDEGetItems(cbGroups.Text,cbItems.Items);
       cbItems.ItemIndex:=0;
     end;

end;

procedure TfmMain.btAddItemClick(Sender: TObject);
var
   myItemInfo: TGroupInfo_t;
begin
{*
** Let's add an item to progman!  This project contains a form named
** fmChangeProgman which has a function titled ChangeItem. ChangeItem
** accepts two parameters, a TGroupInfo_t structure and a TRUE/FALSE
** flag. TRUE indicates we are in ADD mode, FALSE indicates we are in
** change mode.  The mode doesn't really matter because all it really
** does is tell fmChangeProgman to change it's title from ADD to Maintain.
** fmChangeProgman is NOT belong to DDEAuto, it is a form created for this
** project.
*}
  fmChangeProgman.ChangeItem(myItemInfo,TRUE);

{*
** If the user pressed OK, then they want to add this item to Progman.
** Let's use the DDEAuto function DDEAddItem to add it!
** Specify the following:
**                       The group to add the item to, the TGroupInfo_t
**                           strcutre containing the item information
*}
if fmChangeProgman.ModalResult=mrOK then
    DDEAuto1.DDEAddItem(cbGroups.Text,myItemInfo);
end;

procedure TfmMain.btDeleteItemClick(Sender: TObject);
begin
{*
** Let's ask the user if they are sure they want to delete this group
*}
     if MessageDlg('Are you sure you want to delete this item ['+cbItems.Text+']?',
                   mtConfirmation,[mbYes,mbNo],1)=mrYes then
     begin
     {*
     ** If the user is sure this item should be deleted, use the DDEAuto function
     ** DDEDeleteItem to delete the group from progman.
     ** Specify the following:
     **                       The group to delete the Item from
     **                       The item to be deleted
     *}
       DDEAuto1.DDEDeleteItem(cbGroups.Text,cbItems.Text);
       {*
       ** Just for grins and giggles, let's redisplay our item list.
       *}
       cbItems.Items.Clear;
       DDEAuto1.DDEGetItems(cbGroups.Text,cbItems.Items);
       cbItems.ItemIndex:=0;
     end;
end;

procedure TfmMain.cbGroupsChange(Sender: TObject);
begin
{*
** The group has changed, we will use the DDEAuto function DDEGetItems to
** refresh our Item List.
** Specify the Following:
**                        The group to retrieve a list of items for
**                        Any TList type object
*}
  cbItems.Items.Clear;
  DDEAuto1.DDEGetItems(cbGroups.Text,cbItems.Items);
  cbItems.ItemIndex:=0;
end;

procedure TfmMain.btChangeItemClick(Sender: TObject);
var
   myItemInfo: TGroupInfo_t;
begin
{*
** Let's change an item in progman!  This project contains a form named
** fmChangeProgman which has a function titled ChangeItem. ChangeItem
** accepts two parameters, a TGroupInfo_t structure and a TRUE/FALSE
** flag. TRUE indicates we are in ADD mode, FALSE indicates we are in
** change mode.  The mode doesn't really matter because all it really
** does is tell fmChangeProgman to change it's title from ADD to Maintain.
** fmChangeProgman is NOT belong to DDEAuto, it is a form created for this
** project.
*}
  {*
  ** First, let's use the DDEAuto function DDEGetItemInfo to fill our
  ** TGroupInfo_t [mytItemInfo] structure with this item's current
  ** properties.
  ** Specify the following:
  **                       The Group the Item Belongs to
  **                       The Item Name
  **                       A TGroupInfo_t structure
  *}
  DDEAuto1.DDEGetItemInfo(cbGroups.Text,cbItems.Text,myItemInfo);
  {*
  ** After we have the current properties, let's pass the myItemInfo
  ** structure to the fmChangeProgman [again, this is NOT a part of
  ** DDEAuto, it is only a form in this project] and see what the user
  ** wants to change
  *}
  fmChangeProgman.ChangeItem(myItemInfo,FALSE);

  {*
  ** If the user pressed OK, then they want to make the change. Let's use
  ** the DDEAuto function DDEChangeItem to change the Item's Properties.
  ** For this we pass in the Item's Group Name, The Item's CURRENT name and
  ** the myItemInfo structure that contains the item's new information.
  ** Specify the following:
  **                       The group the item belongs to
  **                       The Item Name
  **                       a TGroupinfo_t structure
  *}
  if fmChangeProgman.ModalResult=mrOK then
    DDEAuto1.DDEChangeItem(cbGroups.Text,cbItems.Text,myItemInfo);
end;

procedure TfmMain.btMoveItemClick(Sender: TObject);
begin
{*
** Let's move the item to a different group using the DDEMoveItem
** function.  Specify the following:
**                        The Current Group Name
**                        The New Group Name
**                        The Item Name
*}
 DDEAuto1.DDEMoveItem(cbGroups.Text,'DDE Auto Group',cbItems.Text);
end;

procedure TfmMain.cbItemsChange(Sender: TObject);
var
   myItem: TGroupInfo_t;
begin
{*
** The Item has changed, let's see what the item's current
** properties are with the DDEGetItemInfo function.
** function.  Specify the following:
**                        The Group Name
**                        The Item Name
**                        The TGroupInfo_t structure to fill in
*}
   DDEAuto1.DDEGetItemInfo(cbGroups.Text,cbItems.Text,myItem);

   {*
   ** For grins and giggles, let's show what the properties of the
   ** item are in the mcAuditMemo.
   *}
   mcAuditMemo.Lines.Clear;
   mcAuditMemo.Lines.Add('Item Name . . . . : '+myItem.ItemName);
   mcAuditMemo.Lines.Add('Executable Name . : '+myItem.ExeFileName);
   mcAuditMemo.Lines.Add('Command Line. . . : '+myItem.CmdLine);
   mcAuditMemo.Lines.Add('Icon File Name. . : '+myItem.IconFile);
   mcAuditMemo.Lines.Add('Icon File Index . : '+InttoStr(myItem.IconIndex));
   mcAuditMemo.Lines.Add('Working Directory : '+myItem.WorkingDir);
end;

procedure TfmMain.FormCreate(Sender: TObject);
begin
{*
** Let's retrieve a list of groups from progman with the DDEGetGroups function.
** Specify the following:
**                        A List Variable such as a Combobox, Listbox, or other
**                          TList type object.
*}
    DDEAuto1.DDEGetGroups(cbGroups.Items);

    {*
    ** Let's set the index to 0
    *}
    cbGroups.ItemIndex:=0;
end;

procedure TfmMain.btShowGroupClick(Sender: TObject);
begin
{*
** We will show the group specified by using the DDEShowGroup function
** Specify the following:
**                       The Group Name
**                       The State to show the group in
** Valid values are as follows:
**   gssShowOriginal
**               Show the group in it's original state
**   gssShowIcon
**              Show the Groups as an Icon
**   gssShowMaximized
**             Maximize the Group
**   gssShowRecent
**             Show the group in it's most recent Size and Position
**   gssShowCurrent
**            Show the group in it's current size and position
**   gssShowMinimized
**              Show the group Minimized
**   gssShowIconStayActive
**              Show the group as an icon, the current stays active
**   gssShowCurrentStayActive
**             Show the group in it's current size and position,
**             the current windo stays active.
}
    DDEAuto1.DDEShowGroup(cbGroups.Text,gssShowIconStayActive);
end;

end.
