{ ****************************************************************** }
{                                                                    }
{   Delphi component TDice                                           }
{                                                                    }
{                                                                    }
{   Copyright  1995 by Indigo Software                              }
{                                                                    }
{ ****************************************************************** }

(*------------------------------------------------------------------|
This is a free 'Dice' VCL created by Indigo Software.  

Properties:

BackColor: TColor
	Specifies the backbround color behind the 'Die' (ie the form color)

DiceColor: TColor
	Specifies the actual color of the 'Die'

Value: Integer
	Specifies the number of dots on the 'Die' (0-6)


Methods:

Roll:	Assigns a random value to the 'Die' (ie Dice1.roll)
	The random number generator should be seeded before
	calling this method.
|-------------------------------------------------------------------*)
unit Dice;

interface

{$IFDEF WIN32}
uses Messages, Windows, SysUtils, Classes, Controls, 
     Forms, Menus, Graphics;
{$ELSE}
uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Menus, Graphics;
{$ENDIF}

     { Unit-wide declarations }
type
    TDSize = (dsLarge,dsMedium,dsSmall);
     { type }
     { . . . }
     { var }
     { . . . }

type
  TDice = class(TGraphicControl)
    private
        FValue : Integer;
        FBackColor : TColor;
        FDiceColor : TColor;
        FSize : TDSize;
        FDotColor : TColor;
        Dwidth : Integer;
        Dotsize : Integer;

        procedure AutoInitialize;
        procedure AutoDestroy;
        procedure SetValue(Value : Integer);
        procedure SetBackColor(Value : TColor);
        procedure SetDiceColor(Value : TColor);
        procedure SetSize(Value : TDSize);
        procedure SetDotColor(Value : TColor);
        procedure WMSize(var Message: TWMSize); message WM_PAINT;

    protected
        procedure Click; override;
        procedure Paint; override;

    public
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        procedure Roll;

    published
        property OnClick;
        property OnDblClick;
        property OnDragDrop;
        property OnDragOver;
        property OnEndDrag;
        property OnMouseDown;
        property OnMouseMove;
        property OnMouseUp;
        property Value : Integer read FValue write SetValue default 1;
        property BackColor : TColor
             read FBackColor write SetBackColor
             default clsilver;
        property DiceColor : TColor
             read FDiceColor write SetDiceColor
             default clwhite;
        property Size : TDSize read FSize write SetSize default dsSmall;
        property DotColor : TColor read FDotColor write SetDotColor;

  end;

procedure Register;

implementation

procedure Register;
begin
     RegisterComponents('Indigo Widgets', [TDice]);
end;

{ Method to set variable and property values and create objects }
procedure TDice.AutoInitialize;
begin
     FValue := 1;
     FBackColor := clsilver;
     FDiceColor := clwhite;
     FSize := dsSmall;
     Dwidth := 32;
     Dotsize := 3;
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TDice.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
end; { of AutoDestroy }

{ Write method for property Value }
procedure TDice.SetValue(Value : Integer);
begin
     FValue := Value;
     if fvalue< 0 then fvalue:=0;
     if fvalue > 6 then fvalue :=6;
     Paint;
end;

{ Write method for property BackColor }
procedure TDice.SetBackColor(Value : TColor);
begin
     FBackColor := Value;
      Paint;
end;

{ Write method for property DiceColor }
procedure TDice.SetDiceColor(Value : TColor);
begin
     FDiceColor := Value;
     Paint;
end;

{ Write method for property Size }
procedure TDice.SetSize(Value : TDSize);
begin
   FSize := Value;
   case fsize of
   dsSmall:
      begin
         dwidth:=32 ;
         dotsize:=3;
      end;
   dsMedium:
      begin
         dwidth:=48;
         dotsize:=5;
      end;
   dsLarge:
      begin
         dwidth:=64;
         dotsize:=7;
      end;
   end;
   width:=dwidth;
   height:=dwidth;
   Paint;
end;

{ Write method for property DotColor }
procedure TDice.SetDotColor(Value : TColor);
begin
     FDotColor := Value;
     Paint;
end;

{ Override OnClick handler from TGraphicControl }
procedure TDice.Click;
begin
     inherited Click;
end;

constructor TDice.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;
     width:=dwidth;
     height:=dwidth;
end;

destructor TDice.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

procedure TDice.WMSize(var Message: TWMSize);
begin
     inherited;
     Width:=dwidth;
     Height:=dwidth;
end;

{ This is where the actual die is painted }
procedure TDice.Paint;
var
mybitmap:tbitmap;
begin
     {fill die with backcolor}
     mybitmap:=tbitmap.create;
     mybitmap.width:=dwidth;
     mybitmap.height:=dwidth;
     mybitmap.canvas.brush.color:=fbackcolor;
     mybitmap.canvas.pen.color:=fbackcolor;
     mybitmap.canvas.rectangle(0,0,dwidth,dwidth);

     {draw die outline}
     mybitmap.canvas.pen.color:=clblack;
     mybitmap.canvas.brush.color:=fdicecolor;
     mybitmap.canvas.roundrect(0,0,dwidth,dwidth,6,6);

     {draw dots}
     mybitmap.canvas.pen.color:=dotcolor;
     mybitmap.canvas.brush.color:=dotcolor;
     case fvalue of
     1: mybitmap.canvas.ellipse(dwidth div 2 -dotsize,dwidth div 2 -dotsize,
          dwidth div 2 +dotsize,dwidth div 2 +dotsize);
     2: begin
        mybitmap.canvas.ellipse(dwidth div 4 -dotsize,dwidth div 4 -dotsize,
          dwidth div 4 +dotsize,dwidth div 4 +dotsize);
        mybitmap.canvas.ellipse((dwidth div 4) * 3 -dotsize,(dwidth div 4) * 3 -dotsize,
          (dwidth div 4) * 3 + dotsize,(dwidth div 4) * 3 +dotsize);
        end;
     3: begin
        mybitmap.canvas.ellipse(dwidth div 2 -dotsize,dwidth div 2 -dotsize,
          dwidth div 2 +dotsize,dwidth div 2 +dotsize);
        mybitmap.canvas.ellipse(dwidth div 4 -dotsize,dwidth div 4 -dotsize,
          dwidth div 4 +dotsize,dwidth div 4 +dotsize);
        mybitmap.canvas.ellipse((dwidth div 4) * 3 -dotsize,(dwidth div 4) * 3 -dotsize,
          (dwidth div 4) * 3 + dotsize,(dwidth div 4) * 3 +dotsize);
        end;
     4: begin
        mybitmap.canvas.ellipse(dwidth div 4 -dotsize,dwidth div 4 -dotsize,
          dwidth div 4 +dotsize,dwidth div 4 +dotsize);
        mybitmap.canvas.ellipse((dwidth div 4) * 3 -dotsize,(dwidth div 4) * 3 -dotsize,(
          dwidth div 4) * 3 + dotsize,(dwidth div 4) * 3 +dotsize);
        mybitmap.canvas.ellipse(dwidth div 4 -dotsize,(dwidth div 4) * 3 -dotsize,
          dwidth div 4 +dotsize,(dwidth div 4) * 3 +dotsize);
        mybitmap.canvas.ellipse((dwidth div 4) * 3 -dotsize,dwidth div 4 -dotsize,
          (dwidth div 4) * 3 + dotsize,dwidth div 4 + dotsize);
        end;
     5: begin
        mybitmap.canvas.ellipse(dwidth div 4 -dotsize,dwidth div 4 -dotsize,
          dwidth div 4 +dotsize,dwidth div 4 +dotsize);
        mybitmap.canvas.ellipse((dwidth div 4) * 3 -dotsize,(dwidth div 4) * 3 -dotsize,
          (dwidth div 4) * 3 + dotsize,(dwidth div 4) * 3 +dotsize);
        mybitmap.canvas.ellipse(dwidth div 4 -dotsize,(dwidth div 4) * 3 -dotsize,
          dwidth div 4 +dotsize,(dwidth div 4) * 3 +dotsize);
        mybitmap.canvas.ellipse((dwidth div 4) * 3 -dotsize,dwidth div 4 -dotsize,
          (dwidth div 4) * 3 + dotsize,dwidth div 4 + dotsize);
        mybitmap.canvas.ellipse(dwidth div 2 -dotsize,dwidth div 2 -dotsize,
          dwidth div 2 +dotsize,dwidth div 2 +dotsize);
        end;
     6: begin
        mybitmap.canvas.ellipse(dwidth div 4 -dotsize,dwidth div 4 -dotsize,
          dwidth div 4 +dotsize,dwidth div 4 +dotsize);
        mybitmap.canvas.ellipse((dwidth div 4) * 3 -dotsize,(dwidth div 4) * 3 -dotsize,
          (dwidth div 4) * 3 + dotsize,(dwidth div 4) * 3 +dotsize);
        mybitmap.canvas.ellipse(dwidth div 4 -dotsize,(dwidth div 4) * 3 -dotsize,
          dwidth div 4 +dotsize,(dwidth div 4) * 3 +dotsize);
        mybitmap.canvas.ellipse((dwidth div 4) * 3 -dotsize,dwidth div 4 -dotsize,
          (dwidth div 4) * 3 + dotsize,dwidth div 4 + dotsize);
        mybitmap.canvas.ellipse(dwidth div 4 -dotsize,dwidth div 2 -dotsize,
          dwidth div 4 +dotsize,dwidth div 2 +dotsize);
        mybitmap.canvas.ellipse((dwidth div 4) * 3 -dotsize,dwidth div 2 -dotsize,
          (dwidth div 4) * 3 +dotsize,dwidth div 2 +dotsize);
        end;
     end;
     canvas.copyrect(rect(0,0,dwidth,dwidth),mybitmap.canvas,rect(0,0,dwidth,dwidth));
     mybitmap.free;
end;

{ Selects a random number for the die }
procedure TDice.Roll;
begin
     setvalue(random(6)+1);
end;



end.
