(*
   TdkwInheritForm

   The InheritForm class allows a single form to borrow
   design aspects from several other forms.

   (c) 1995 by DKW Systems Corporation, All Rights Reserved.

   Change History:

     Sept 20, 1995
       BWS - Original version written by Blake Stone
*)

unit DKWIForm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TdkwInheritForm = class(TComponent)
  private
    { Private declarations }
    FFormClass: String ;
    FTempForm: TForm ;
    procedure SetFormClass ( Value: String ) ;
    destructor Destroy ; override ;
  protected
    { Protected declarations }
  public
    { Public declarations }
    property Form: TForm read FTempForm ;
  published
    { Published declarations }
    property FormClass: String read FFormClass write SetFormClass ;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents ( 'DKW', [ TdkwInheritForm ] ) ;
end;

(* Change the form we're 'inheriting' components from *)

procedure TdkwInheritForm.SetFormClass ( Value: String ) ;
begin
  if FFormClass <> Value then
  begin
    (* Clean up after prior inheritance *)

    FTempForm.Free ;
    FTempForm := nil ;
    FFormClass := Value ;

    (* Inherit from a form if specified *)

    if Value <> '' then
    begin
      try

        (* Provide visual feedback in design mode *)

        if csDesigning in ComponentState then
        begin
          FTempForm := TForm.Create ( nil ) ;
          with TPanel.Create ( FTempForm ) do
          begin
            Parent := FTempForm ;
            Caption := 'This form inherits from ' + Value ;
            Align := alBottom ;
            Color := clBlack ;
            Font.Color := clWhite ;
          end ;
        end
        else
        begin
          FTempForm := TFormClass ( FindClass ( Value ) ).Create ( nil ) ;
        end ;

        (* Migrate controls *)

        while FTempForm.ControlCount > 0 do
        begin
          FTempForm.Controls [ 0 ].Parent := Owner as TForm ;
        end ;
      except
        on EClassNotFound do
          MessageDlg ( 'Class ' + Value + ' not registered', mtError, [ mbOK ], 0 ) ;
      end ;
    end ;
  end ;
end ;

(* Clean up safely on destruction *)

destructor TdkwInheritForm.Destroy ;
begin
  if Owner <> nil then
  begin
    if csDestroying in Owner.ComponentState then
    begin
      while FTempForm.ComponentCount > 0 do
      begin
        FTempForm.RemoveComponent ( FTempForm.Components [ 0 ] ) ;
      end ;
    end ;
  end ;
  FTempForm.Free ;
  FTempForm := nil ;
  inherited Destroy ;
end ;

end.

