unit SRCMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Speech, SR, ComCtrls, StdCtrls, AuDevDlg, ModeDlg, ExtCtrls, Grammar,
  GmRuleFm,
  {$IFDEF VER90} //Delphi 2.0
  OLE2,
  {$ENDIF}
  {$IFDEF VER100}  //Delphi 3.0
  {$ENDIF}
  MMSystem,
  Gauges;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet4: TTabSheet;
    btActive: TButton;
    lbActiveStatus: TLabel;
    btAudioDevice: TButton;
    btPause: TButton;
    lbAudioDevice: TLabel;
    cbxAttributesActive: TCheckBox;
    SR1: TSR;
    AuDevDlg1: TAuDevDlg;
    Panel4: TPanel;
    lbFileTime: TLabel;
    btFileTime: TButton;
    Panel3: TPanel;
    lbPosnGet: TLabel;
    btPosnGet: TButton;
    TabSheet5: TTabSheet;
    btGrammar: TButton;
    OpenDialog1: TOpenDialog;
    lbGrammar: TLabel;
    btRules: TButton;
    reWordsSaid: TRichEdit;
    btActivateGram: TButton;
    lbGramActiveStatus: TLabel;
    Grammar1: TGrammar;
    ModeDlg1: TModeDlg;
    btEngineMode: TButton;
    lbEngineMode: TLabel;
    Dialogs: TTabSheet;
    cbxDialogsActive: TCheckBox;
    GroupBox1: TGroupBox;
    btAbout: TButton;
    btGeneral: TButton;
    btTrainMic: TButton;
    btLexicon: TButton;
    btTrainGeneral: TButton;
    GroupBox3: TGroupBox;
    cbxOnAttribChangedEvent: TCheckBox;
    cbxOnInterferenceEvent: TCheckBox;
    cbxOnSoundEvent: TCheckBox;
    cbxUtteranceBeginEvent: TCheckBox;
    cbxUtteranceEndEvent: TCheckBox;
    cbxVUMeterEvent: TCheckBox;
    cbxEngineNotificaitons: TCheckBox;
    cbxEcho: TCheckBox;
    edMicrophone: TEdit;
    Label8: TLabel;
    edSpeaker: TEdit;
    Label9: TLabel;
    Label1: TLabel;
    TrackBarAutoGain: TTrackBar;
    lbAutoGain: TLabel;
    lbAutoGainMin: TLabel;
    lbAutoGainMax: TLabel;
    Label13: TLabel;
    Label7: TLabel;
    Label6: TLabel;
    lbRealTime: TLabel;
    lbEnergyFloor: TLabel;
    lbThreshold: TLabel;
    lbTimeOutIncomplete: TLabel;
    lbTimeOutComplete: TLabel;
    lbTimeOutCompleteMin: TLabel;
    lbTimeOutIncompleteMin: TLabel;
    lbThresholdMin: TLabel;
    lbEnergyFloorMin: TLabel;
    lbRealTimeMin: TLabel;
    lbRealTimeMax: TLabel;
    lbEnergyFloorMax: TLabel;
    lbThresholdMax: TLabel;
    lbTimeOutIncompleteMax: TLabel;
    lbTimeOutCompleteMax: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label15: TLabel;
    TrackBarTimeOutComplete: TTrackBar;
    TrackBarTimeOutIncomplete: TTrackBar;
    TrackBarThreshold: TTrackBar;
    TrackBarEnergyFloor: TTrackBar;
    TrackBarRealTime: TTrackBar;
    GaugeVUMeter: TGauge;
    lbxEngineNotifications: TListBox;
    Label10: TLabel;
    lbxGrammarNotifications: TListBox;
    Label11: TLabel;
    GroupBox2: TGroupBox;
    cbxOnUnArchive: TCheckBox;
    cbxOnTraining: TCheckBox;
    cbxOnReEvaluate: TCheckBox;
    cbxOnPhraseStart: TCheckBox;
    cbxOnPhraseHypothesis: TCheckBox;
    cbxOnPhraseFinish: TCheckBox;
    cbxOnPaused: TCheckBox;
    cbxOnBookMark: TCheckBox;
    PageControl2: TPageControl;
    TabSheet3: TTabSheet;
    TabSheet6: TTabSheet;
    lbxLists: TListBox;
    lbxWords: TListBox;
    Label12: TLabel;
    lbxListWords: TListBox;
    Label14: TLabel;
    edListWord: TEdit;
    btListAppend: TButton;
    btListRemove: TButton;
    btListSet: TButton;
    btArchive: TButton;
    btLoadArchive: TButton;
    btReleaseInfo: TButton;
    lbxInfo: TListBox;
    btResume: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btActiveClick(Sender: TObject);
    procedure btEngineModeClick(Sender: TObject);
    procedure btAudioDeviceClick(Sender: TObject);
    procedure btPauseClick(Sender: TObject);
    procedure cbxAttributesActiveClick(Sender: TObject);
    procedure cbxEchoClick(Sender: TObject);
    procedure TrackBarAutoGainChange(Sender: TObject);
    procedure edSpeakerChange(Sender: TObject);
    procedure cbxDialogsActiveClick(Sender: TObject);
    procedure btAboutClick(Sender: TObject);
    procedure btPosnGetClick(Sender: TObject);
    procedure btFileTimeClick(Sender: TObject);
    procedure btGrammarClick(Sender: TObject);
    procedure btRulesClick(Sender: TObject);
    procedure Grammar1PhraseFinishEvent(Sender: TObject; dwFlags: Integer;
      qTimeStampBegin, qTimeStampEnd: Comp; aPSRPhrase: PSRPHRASE;
      IUnknownResult: IUnknown);
    procedure btActivateGramClick(Sender: TObject);
    procedure cbxEngineNotificaitonsClick(Sender: TObject);
    procedure SR1AttribChangedEvent(Sender: TObject; dwAttribute: Integer);
    procedure SR1InterferenceEvent(Sender: TObject; TimeStampBegin,
      TimeStampEnd: Comp; InterferenceType: Integer);
    procedure SR1SoundEvent(Sender: TObject; TimeStampBegin,
      TimeStampEnd: Comp);
    procedure SR1UtteranceBeginEvent(Sender: TObject;
      TimeStampBegin: Comp);
    procedure SR1UtteranceEndEvent(Sender: TObject; TimeStampBegin,
      TimeStampEnd: Comp);
    procedure SR1VUMeterEvent(Sender: TObject; TimeStampBegin: Comp;
      level: Word);
    procedure Grammar1BookmarkEvent(Sender: TObject; BookMarkID: Integer);
    procedure Grammar1PausedEvent(Sender: TObject);
    procedure Grammar1PhraseHypothesisEvent(Sender: TObject;
      dwFlags: Integer; qTimeStampBegin, qTimeStampEnd: Comp;
      aPSRPhrase: PSRPHRASE; IUnknownResult: IUnknown);
    procedure Grammar1PhraseStartEvent(Sender: TObject;
      TimeStampBegin: Comp);
    procedure Grammar1ReEvaluateEvent(Sender: TObject; IUnk: IUnknown);
    procedure Grammar1TrainingEvent(Sender: TObject; TrainFlag: Integer);
    procedure Grammar1UnArchiveEvent(Sender: TObject; IUnk: IUnknown);
    procedure btListAppendClick(Sender: TObject);
    procedure lbxListsClick(Sender: TObject);
    procedure btListRemoveClick(Sender: TObject);
    procedure btListSetClick(Sender: TObject);
    procedure btArchiveClick(Sender: TObject);
    procedure btReleaseInfoClick(Sender: TObject);
    procedure btLoadArchiveClick(Sender: TObject);
    procedure btResumeClick(Sender: TObject);
  private
    { Private declarations }
    fLastFileTime : Comp;
    fLastDir : TFileName;
  public
    { Public declarations }
    Procedure UpdateAttributes;
    function TryFunc(HR : HResult; FuncStr : String) : Boolean;
    procedure TestGraphResult(IUnknownResult : IUnknown);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  fLastFileTime := 0;
end;

procedure TForm1.FormActivate(Sender: TObject);
  Function SetupTrackBar(TrackBar : TTrackBar; Min, Current, Max : Integer) : Boolean;
  {Go to all this trouble so track bar doesn't give range error if min> max or max < min}
  {Note that the seemly insane code below doesnt actually do the same thing for the if and else
  parts of the if then statement. It's the order of setting the max and the min that is
  important. The problem is that setting a min > than the max causes an error and setting
  a max < than a min does the same.}
  Begin
    result := False;
    TrackBar.Position := TrackBar.Min;
    TrackBar.Max := TrackBar.Min;
    If TrackBar.Min < 100 then
    begin
      TrackBar.Max := 100;
      TrackBar.Min := 0;
    end
    else
    begin
      TrackBar.Min := 0;
      TrackBar.Max := 100
    end;
    TrackBar.Position := 50;
    if (Min <= Current) and (Current <= Max) then
    begin
      If (TrackBar.Max > Min) or ((Max > TrackBar.Max) and (Min > TrackBar.Min)) then
      begin
        TrackBar.Max := Max;
        TrackBar.Min := Min;
      end
      else
      begin
        TrackBar.Min := Min;
        TrackBar.Max := Max;
      end;
      TrackBar.Position := Current;
      result := True;
    end
    else
      TrackBar.Enabled := False;
  end;
begin
  if SR1.Active then
  begin
    GroupBox2.Enabled := True;
    TrackBarAutoGain.Enabled := False;
    Label1.Enabled := False;
    Try
      if SR1.AutoGainEnableSupported and

         SetupTrackBar(TrackBarAutoGain, SR1.MinAutoGainEnable,
                       SR1.AutoGainEnable, SR1.MaxAutoGainEnable) then
      begin
        TrackBarAutoGain.Frequency := (TrackBarAutoGain.Max - TrackBarRealTime.Min) div 8;
        lbAutoGain.Caption := IntToStr(TrackBarAutoGain.Position);
        lbAutoGainMin.Caption := IntToStr(TrackBarAutoGain.Min);
        lbAutoGainMax.Caption := IntToStr(TrackBarAutoGain.Max);
        TrackBarAutoGain.Enabled := True;
        Label1.Enabled := True;
      end;
    Except
    end;

    if (SR1.EchoSupported) then
    begin
      cbxEcho.Checked := SR1.Echo;
      cbxEcho.Enabled := True;
    end
    else
    begin
      cbxEcho.Enabled := false;
    end;

    TrackBarEnergyFloor.Enabled := False;
    Label3.Enabled := False;
    Try
      if SR1.EnergyFloorSupported and
         SetupTrackBar(TrackBarEnergyFloor, SR1.MinEnergyFloor,
                       SR1.EnergyFloor, SR1.MaxEnergyFloor) then
      begin
        TrackBarEnergyFloor.Frequency := (TrackBarEnergyFloor.Max -
                       TrackBarEnergyFloor.Min) div 8;
        lbEnergyFloor.Caption := IntToStr(TrackBarEnergyFloor.Position);
        lbEnergyFloorMin.Caption := IntToStr(TrackBarEnergyFloor.Min);
        lbEnergyFloorMax.Caption := IntToStr(TrackBarEnergyFloor.Max);
        TrackBarEnergyFloor.Enabled := True;
        Label3.Enabled := True;
      end
    except
    end;

    if (SR1.MicrophoneSupported) then
    begin
      edMicrophone.Text := SR1.Microphone;
      edMicrophone.Enabled := True;
      Label8.Enabled := True;
    end
    else
    begin
      edMicrophone.Enabled := False;
      Label8.Enabled := false;
    end;

    TrackBarRealTime.Enabled := False;
    Label2.Enabled := False;
    Try
      if SR1.RealTimeSupported and
      
         SetupTrackBar(TrackBarRealTime, SR1.MinRealTime,
                       SR1.RealTime, SR1.MaxRealTime) then
      begin
        TrackBarRealTime.Frequency := (TrackBarRealTime.Max - TrackBarRealTime.Min) div 8;
        lbRealTime.Caption := IntToStr(TrackBarRealTime.Position);
        lbRealTimeMin.Caption := IntToStr(TrackBarRealTime.Min);
        lbRealTimeMax.Caption := IntToStr(TrackBarRealTime.Max);
        TrackBarRealTime.Enabled := True;
        Label2.Enabled := True;
      end;
    Except
    end;

    if (SR1.SpeakerSupported) then
    begin
      edSpeaker.Text := SR1.Speaker;
      edSpeaker.Enabled := True;
      Label9.Enabled := True;
    end
    else
    begin
      edSpeaker.Enabled := False;
      Label9.Enabled := false;
    end;

    TrackBarThreshold.Enabled := False;
    Label4.Enabled := False;
    Try
      if SR1.ThresholdSupported and
         SetupTrackBar(TrackBarThreshold, SR1.MinThreshold,
                       SR1.Threshold, SR1.MaxThreshold) then
      begin
        TrackBarThreshold.Frequency := (TrackBarThreshold.Max - TrackBarThreshold.Max) div 8;
        lbThreshold.Caption := IntToStr(TrackBarThreshold.Position);
        lbThresholdMin.Caption := IntToStr(TrackBarThreshold.Min);
        lbThresholdMax.Caption := IntToStr(TrackBarThreshold.Max);
        TrackBarThreshold.Enabled := True;
        Label4.Enabled := True;
      end;
    Except
    end;

    TrackBarTimeOutIncomplete.Enabled := False;
    Label5.Enabled := False;
    Try
      if SR1.TimeOutSupported and
         SetupTrackBar(TrackBarTimeOutIncomplete, SR1.MinTimeOutIncomplete,
                       SR1.TimeOutIncomplete, SR1.MaxTimeOutIncomplete) then
      begin
        TrackBarTimeOutIncomplete.Frequency :=
          (TrackBarTimeOutIncomplete.Max - TrackBarTimeOutIncomplete.Max) div 8;
        lbTimeOutIncomplete.Caption := IntToStr(TrackBarTimeOutIncomplete.Position);
        lbTimeOutIncompleteMin.Caption := IntToStr(TrackBarTimeOutIncomplete.Min);
        lbTimeOutIncompleteMax.Caption := IntToStr(TrackBarTimeOutIncomplete.Max);
        TrackBarTimeOutIncomplete.Enabled := True;
        Label5.Enabled := True;
      end;
    Except
    end;

    TrackBarTimeOutComplete.Enabled := False;
    Label15.Enabled := False;
    Try
      if SR1.TimeOutSupported and
         SetupTrackBar(TrackBarTimeOutComplete, SR1.MinTimeOutComplete,
                       SR1.TimeOutComplete, SR1.MaxTimeOutComplete) then
      begin
        TrackBarTimeOutComplete.Frequency :=
          (TrackBarTimeOutComplete.Max - TrackBarTimeOutComplete.Max) div 8;
        lbTimeOutComplete.Caption := IntToStr(TrackBarTimeOutComplete.Position);
        lbTimeOutCompleteMin.Caption := IntToStr(TrackBarTimeOutComplete.Min);
        lbTimeOutCompleteMax.Caption := IntToStr(TrackBarTimeOutComplete.Max);
        TrackBarTimeOutComplete.Enabled := True;
        Label15.Enabled := True;
      end;
    except
    end;

    btActive.Caption := 'DeActivate';
  end
  else
  begin
    TrackBarAutoGain.Enabled    := False;
    cbxEcho.Enabled := false;
    TrackBarEnergyFloor.Enabled := False;
    edMicrophone.Enabled := False;
    TrackBarRealTime.Enabled := False;
    edSpeaker.Enabled := False;
    TrackBarThreshold.Enabled := False;
    TrackBarTimeOutIncomplete.Enabled := False;
    TrackBarTimeOutComplete.Enabled := False;

    Label1.enabled := False;
    Label2.enabled := False;
    Label3.enabled := False;
    Label4.enabled := False;
    Label5.enabled := False;
    Label8.enabled := False;
    Label9.enabled := False;
    Label15.enabled := False;
    GroupBox2.enabled := False;
    btActive.Caption := 'Activate'
  end;

  if isAttributes in SR1.Interfaces then
    cbxAttributesActive.checked := True
  else
    cbxAttributesActive.checked := False;

  if isDialogs in SR1.Interfaces then
    cbxDialogsActive.checked := True
  else
    cbxDialogsActive.checked := False;

  btAbout.enabled := SR1.AboutDlgSupported;
  btGeneral.enabled := SR1.GeneralDlgSupported;
  btLexicon.enabled := SR1.LexiconDlgSupported;
  btTrainMic.enabled := SR1.TrainMicDlgSupported;
  btTrainGeneral.enabled := SR1.TrainGeneralDlgSupported;

  If SR1.Active then
    lbActiveStatus.caption := 'Engine is running . . .'
  else
    lbActiveStatus.caption := 'Engine is stopped';

  lbEngineMode.caption := SR1.ModeName;
  lbAudioDevice.caption := String(SR1.DeviceInfo.szPname);

  If Grammar1.Active then
    lbGramActiveStatus.caption := 'Grammar is active . . .'
  else
    lbGramActiveStatus.caption := 'Grammar is inactive';
end;

procedure TForm1.btActiveClick(Sender: TObject);
begin
  SR1.Active := Not(SR1.Active);
  FormActivate(Self);
  if SR1.Active then
  begin
    if SR1.ILexPronounceSupported then
      lbxInfo.Items.Add('ILexPronounce supported')
    else
      lbxInfo.Items.Add('ILexPronounce not supported');
    if SR1.ISRSpeakerSupported then
      lbxInfo.Items.Add('ISRSpeaker supported')
    else
      lbxInfo.Items.Add('ISRSpeaker not supported');
  end;
end;

procedure TForm1.btEngineModeClick(Sender: TObject);
var
  Old : Boolean;
begin
  Old := SR1.Active;
  SR1.Active := False;
  ModeDlg1.execute;    {The dialog automatically sets ModeInfo through its TTS property }
  SR1.Active := Old;
  FormActivate(Self);
end;

procedure TForm1.btAudioDeviceClick(Sender: TObject);
begin
  AuDevDlg1.execute; {The dialog automatically sets AudioDeviceID through its TTS property }
  lbAudioDevice.caption := String(SR1.DeviceInfo.szPname);
end;

procedure TForm1.btPauseClick(Sender: TObject);
begin
  SR1.Pause;
end;

procedure TForm1.btResumeClick(Sender: TObject);
begin
  SR1.Resume;
end;


Procedure TForm1.UpdateAttributes;
begin
  if SR1.Active then
  begin
    if (SR1.EchoSupported) then
    begin
      cbxEcho.checked := SR1.Echo;
    end;

    if (SR1.AutoGainEnableSupported) then
    begin
      TrackBarAutoGain.Position := SR1.AutoGainEnable;
      lbAutoGain.Caption := IntToStr(SR1.AutoGainEnable);
    end;

    if (SR1.RealTimeSupported) then
    begin
      TrackBarRealTime.Position := SR1.Realtime;
      lbRealTime.Caption := IntToStr(SR1.Realtime);
    end;

    if (SR1.EnergyFloorSupported) then
    begin
      TrackBarEnergyFloor.Position := SR1.EnergyFloor;
      lbEnergyFloor.Caption := IntToStr(SR1.EnergyFloor);
    end;

    if (SR1.MicrophoneSupported) then
    begin
      edMicrophone.Text := SR1.Microphone;
    end;

    if (SR1.SpeakerSupported) then
    begin
      edSpeaker.Text := SR1.Speaker;
    end;

    if SR1.ThresholdSupported then
    begin
      TrackBarThreshold.Position := SR1.Threshold;
    end;

    if SR1.TimeOutSupported then
    begin
      TrackBarTimeOutIncomplete.Position := SR1.TimeOutIncomplete;
    end;

    if SR1.TimeOutSupported then
    begin
      TrackBarTimeOutComplete.Position := SR1.TimeOutComplete;
    end;

  end;
end;

procedure TForm1.cbxAttributesActiveClick(Sender: TObject);
begin
  if cbxAttributesActive.checked then
    SR1.Interfaces := SR1.Interfaces + [isAttributes]
  else
    SR1.Interfaces := SR1.Interfaces - [isAttributes];
end;

procedure TForm1.cbxEchoClick(Sender: TObject);
begin
  if SR1.EchoSupported then
  begin
    SR1.Echo := cbxEcho.checked;
    UpdateAttributes;
  end;

end;


procedure TForm1.TrackBarAutoGainChange(Sender: TObject);
begin
  if SR1.AutoGainEnableSupported then
  begin
    SR1.AutoGainEnable := TrackBarAutoGain.Position;
    UpdateAttributes;
  end;
end;

procedure TForm1.edSpeakerChange(Sender: TObject);
begin
  SR1.Speaker := edSpeaker.text;
end;

procedure TForm1.cbxDialogsActiveClick(Sender: TObject);
begin
  if cbxDialogsActive.checked then
    SR1.Interfaces := SR1.Interfaces + [isDialogs]
  else
    SR1.Interfaces := SR1.Interfaces - [isDialogs];
end;


procedure TForm1.btAboutClick(Sender: TObject);
begin
  case TButton(Sender).Caption[1] of
   'A' : SR1.ShowAboutDlg(Handle, '');
   'G' : SR1.ShowGeneralDlg(Handle, '');
   'L' : SR1.ShowLexiconDlg(Handle, '');
   'T' : begin
           if TButton(Sender).Caption = 'Train Mic' then
            SR1.ShowTrainMicDlg(Handle, '')
           else
            SR1.ShowTrainGeneralDlg(Handle, '');
          end;
  end; {case}
  UpdateAttributes;
end;


procedure TForm1.btPosnGetClick(Sender: TObject);
begin
  lbPosnGet.Caption := FloatToStr(SR1.PosnGet);
end;

procedure TForm1.btFileTimeClick(Sender: TObject);
var
  TmpDate : TDateTime;
begin
  Try
    TmpDate := SR1.SpeechTimeToDateTime(fLastFileTime);
    lbFileTime.Caption := DateTimeToStr(TmpDate);
  except
    lbFileTime.caption := 'Not Supported by this engine'
  end;
end;

procedure TForm1.btGrammarClick(Sender: TObject);
begin
  if Grammar1.GrammarFile <> '' then
  begin
    OpenDialog1.InitialDir := ExtractFileDir(Grammar1.GrammarFile);
    OpenDialog1.FileName := ExtractFileName(Grammar1.GrammarFile);
  end
  else if fLastDir <> '' then
    OpenDialog1.InitialDir := fLastDir;

  if OpenDialog1.execute then
  begin
    if uppercase(ExtractFileExt(OpenDialog1.FileName)) = '.GRM' then
      Grammar1.Format := CFG
{    else if uppercase(ExtractFileExt(OpenDialog1.FileName)) = '.GAF' then
      Grammar1.Format := CFGNative }
    else
      messagebeep(1);
    Grammar1.GrammarFile := OpenDialog1.FileName;
    fLastDir := ExtractFileDir(OpenDialog1.FileName);
    {Show lists for the selected grammar}
    if Grammar1.AvailableLists <> nil then
      lbxLists.items := Grammar1.AvailableLists
    else
      lbxLists.clear;
    {Show the words in the selected grammar}
    if Grammar1.AvailableWords <> nil then
      lbxWords.items := Grammar1.AvailableWords
    else
      lbxWords.clear;
    if Grammar1.TrainPhraseSupported then
      lbxInfo.items.add('Grammar supports TrainPhrases')
    else
      lbxInfo.items.add('Grammar doesn''t support TrainPhrases');
    if Grammar1.TrainDlgSupported then
      lbxInfo.items.add('Grammar supports TrainDlg')
    else
      lbxInfo.items.add('Grammar doesn''t support TrainDlg');
    if Grammar1.TrainQuerySupported then
      lbxInfo.items.add('Grammar supports TrainQuery')
    else
      lbxInfo.items.add('Grammar doesn''t support TrainQUery');
  end;
end;

procedure TForm1.btRulesClick(Sender: TObject);
begin
  EditRules(Grammar1.Rules, Grammar1);
end;

procedure TForm1.btActivateGramClick(Sender: TObject);
begin
  Grammar1.Active := Not(Grammar1.Active);
  FormActivate(Self);
end;

procedure TForm1.cbxEngineNotificaitonsClick(Sender: TObject);
begin
  if cbxEngineNotificaitons.checked then
    SR1.Interfaces := SR1.Interfaces + [isNotifySink]
  else
    SR1.Interfaces := SR1.Interfaces - [isNotifySink];
end;

procedure TForm1.SR1AttribChangedEvent(Sender: TObject;
  dwAttribute: Integer);
begin
  if cbxOnAttribChangedEvent.Checked then
  begin
    Case dwAttribute of
      ISRNSAC_AUTOGAINENABLE :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Attribute Changed Event - AutoGainEnable');
      ISRNSAC_ECHO           :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Attribute Changed Event - Echo');
      ISRNSAC_ENERGYFLOOR    :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Attribute Changed Event - EnergyFloor');
      ISRNSAC_MICROPHONE     :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Attribute Changed Event - Microphone');
      ISRNSAC_REALTIME	     :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Attribute Changed Event - RealTime');
      ISRNSAC_SPEAKER        :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Attribute Changed Event - Speaker');
      ISRNSAC_THRESHOLD      :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Attribute Changed Event - Threshold');
      ISRNSAC_TIMEOUT     :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Attribute Changed Event - Timeout');
    end; {case}
  end;
end;

procedure TForm1.SR1InterferenceEvent(Sender: TObject; TimeStampBegin,
  TimeStampEnd: Comp; InterferenceType: Integer);
begin
  if cbxOnInterferenceEvent.Checked then
  begin
    Case InterferenceType of
      SRMSGINT_AUDIODATA_STARTED :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Interference Event - AudioData Restarted');
      SRMSGINT_AUDIODATA_STOPPED :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Interference Event - AudioData Stopped');
      SRMSGINT_IAUDIO_STARTED :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Interference Event - Audio Device Opened');
      SRMSGINT_IAUDIO_STOPPED :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Interference Event - Audio Device Closed');
      SRMSGINT_NOISE :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Interference Event - Background Noise');
      SRMSGINT_NOSIGNAL :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Interference Event - No Signal Detected');
      SRMSGINT_TOOLOUD :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Interference Event - User is to loud');
      SRMSGINT_TOOQUIET :
        lbxEngineNotifications.ItemIndex :=
           lbxEngineNotifications.Items.Add('Interference Event - User is to quiet');
    end;{case}
  end;
  fLastFileTime := TimeStampEnd;
end;

procedure TForm1.SR1SoundEvent(Sender: TObject; TimeStampBegin,
  TimeStampEnd: Comp);
begin
  if cbxOnSoundEvent.Checked then
  begin
    lbxEngineNotifications.ItemIndex :=
      lbxEngineNotifications.Items.Add('Sound Event');
  end;
  fLastFileTime := TimeStampBegin;
end;

procedure TForm1.SR1UtteranceBeginEvent(Sender: TObject;
  TimeStampBegin: Comp);
begin
  if cbxUtteranceBeginEvent.Checked then
  begin
    lbxEngineNotifications.ItemIndex :=
      lbxEngineNotifications.Items.Add('UtteranceBegin Event');
  end;
  fLastFileTime := TimeStampBegin;
end;

procedure TForm1.SR1UtteranceEndEvent(Sender: TObject; TimeStampBegin,
  TimeStampEnd: Comp);
begin
  if cbxUtteranceEndEvent.Checked then
  begin
    lbxEngineNotifications.ItemIndex :=
      lbxEngineNotifications.Items.Add('UtteranceEnd Event');
  end;
  fLastFileTime := TimeStampEnd;
end;

procedure TForm1.SR1VUMeterEvent(Sender: TObject; TimeStampBegin: Comp;
  level: Word);
begin
  if cbxVUMeterEvent.Checked then
  begin
    lbxEngineNotifications.ItemIndex :=
      lbxEngineNotifications.Items.Add('VUMeter Event');
  end;
  GaugeVUMeter.Progress := level;
  fLastFileTime := TimeStampBegin;
end;

procedure TForm1.Grammar1BookmarkEvent(Sender: TObject;
  BookMarkID: Integer);
begin
  if cbxOnBookmark.Checked then
  begin
    lbxGrammarNotifications.ItemIndex :=
      lbxGrammarNotifications.Items.Add('BookMark Event');
  end;
end;

procedure TForm1.Grammar1PausedEvent(Sender: TObject);
begin
  if cbxOnPaused.Checked then
  begin
    lbxGrammarNotifications.ItemIndex :=
      lbxGrammarNotifications.Items.Add('Grammar Paused Event');
  end;
end;

  function TForm1.TryFunc(HR : HResult; FuncStr : String) : Boolean;
  begin
    If HR = S_OK then
    begin
      lbxInfo.items.add(FuncStr + ' - OK');
      result := True;
    end
    else
    begin
      result := False;
      Case HR of
        E_INVALIDARG : lbxInfo.items.add(FuncStr + ' - Invalid Arg');
        E_OUTOFMEMORY : lbxInfo.items.add(FuncStr + ' - Out of Memory');
        SRERR_NOTENOUGHDATA : lbxInfo.items.add(FuncStr + ' - Not Enough Data');
        SRERR_NOTSUPPORTED : lbxInfo.items.add(FuncStr + ' - Not Supported');
        SRERR_VALUEOUTOFRANGE : lbxInfo.items.add(FuncStr + ' - Value out of Range');
      else
        lbxInfo.items.add(FuncStr + ' - Unknown failure');
      end; {case}
    end;
  end;

  procedure TForm1.TestGraphResult(IUnknownResult : IUnknown);
  var
    SRResGraph : ISRResGraph;
    Score : LongInt;
    SizeNeeded : Integer;
    NodeData : Array[0..50] of Integer;
    PNodeData : Pointer;
    RespPhoNode : SRRESPHONEMENODE;
    RespWordNode : SRRESWORDNODE;
    I : Integer;
  begin
    if IsGraphResult(IUnknownResult, SRResGraph) then
    begin
      lbxInfo.items.add('Graph Result Object - Supported');
      PNodeData := addr(NodeData);
      For I := 0 to 50 do NodeData[I] := 0;
      TryFunc(SRResGraph.BestPathPhoneme(1, PNodeData, Sizeof(NodeData), SizeNeeded), 'SRResGraph.BestPathPhoneme');
      TryFunc(SRResGraph.BestPathWord(0, PNodeData, Sizeof(NodeData), SizeNeeded), 'SRResGraph.BestPathWord');
      TryFunc(SRResGraph.GetPhonemeNode(1, addr(RespPhoNode), Nil, Nil), 'SRResGraph.GetPhonemeNode');
      TryFunc(SRResGraph.GetWordNode(1, addr(RespWordNode), Nil, 0, SizeNeeded), 'SRResGraph.GetWordNode');
      TryFunc(SRResGraph.PathScorePhoneme(PNodeData, SizeNeeded, Score), 'SRResGraph.PathScorePhoneme');
      TryFunc(SRResGraph.PathScoreWord(PNodeData, SizeNeeded, Score), 'SRResGraph.PathScoreWord');
    end
    else
      lbxInfo.items.add('Graph Result Object - Not Supported')
  end;


procedure TForm1.Grammar1PhraseFinishEvent(Sender: TObject;
  dwFlags: Integer; qTimeStampBegin, qTimeStampEnd: Comp;
  aPSRPhrase: PSRPHRASE; IUnknownResult: IUnknown);

  procedure TestAudioResult;
  var
    SRResAudio : ISRResAudio;
    Data : TSData;
  begin
    if IsAudioResult(IUnknownResult, SRResAudio) then
    begin
      lbxInfo.items.add('Audio Result Object - Supported');
      if TryFunc(SRResAudio.GetWav(Data), 'SRResAudio.GetWav') then
        sndPlaySound(Data.pData, SND_MEMORY);
    end
    else
      lbxInfo.items.add('Audio Result Object - Not Supported')
  end;

  procedure TestBasicResult;
  var
    SRResBasic : ISRResBasic;
    I, SizeNeeded : Integer;
    Guid : TGuid;
    DataBlob : Array[0..500] of byte;
    pPhrase : PSRPHRASE;
    C1, C2 : Comp;
  begin
    if IsBasicResult(IUnknownResult, SRResBasic) then
    begin
      lbxInfo.items.add('Basic Result Object - Supported');
      TryFunc(SRResBasic.FlagsGet(0, I), 'SRResBasic.FlagsGet');
      TryFunc(SRResBasic.Identify(Guid), 'SRResBasic.Identify');
      pPhrase := addr(DataBlob);
      TryFunc(SRResBasic.PhraseGet(1, pPhrase, sizeof(DataBlob)-Sizeof(Integer),
              SizeNeeded), 'SRResBasic.PhraseGet');
      TryFunc(SRResBasic.TimeGet(C1, C2), 'SRResBasic.TimeGet');
    end
    else
      lbxInfo.items.add('Basic Result Object - Not Supported')
  end;

  procedure TestCorrectionResult;
  var
    SRResCorrection : ISRResCorrection;
  begin
    if IsCorrectionResult(IUnknownResult, SRResCorrection) then
    begin
      lbxInfo.items.add('Correction Result Object - Supported');
      TryFunc(SRResCorrection.Correction(SingleWordStringToPhrase('Help', 89), SRCORCONFIDENCE_SOME),
         'SRResCorrection.Correction');
      TryFunc(SRResCorrection.Validate(SRCORCONFIDENCE_SOME), 'SRResCorrection.Validate');
    end
    else
      lbxInfo.items.add('Correction Result Object - Not Supported')
  end;

  procedure TestEvalResult;
  var
    SRResEval : ISRResEval;
    Changed : Bool;
  begin
    if IsEvalResult(IUnknownResult, SRResEval) then
    begin
      lbxInfo.items.add('Eval Result Object - Supported');
      TryFunc(SRResEval.ReEvaluate(Changed), 'SRResEval.ReEvaluate');
    end
    else
      lbxInfo.items.add('Eval Result Object - Not Supported')
  end;


  procedure TestMemoryResult;
  var
    SRResMemory : ISRResMemory;
    Size : Integer;
    Locked : Bool;
    Kind : Integer;
  begin
    if IsMemoryResult(IUnknownResult, SRResMemory) then
    begin
      lbxInfo.items.add('Memory Result Object - Supported');
      TryFunc(SRResMemory.Get(Kind, Size), 'SRResMemory.Get');
      TryFunc(SRResMemory.LockSet(False), 'SRResMemory.Lockset');
      TryFunc(SRResMemory.LockGet(Locked), 'SRResMemory.LockGet');
      TryFunc(SRResMemory.Free(SRRESMEMKIND_AUDIO), 'SRResMemory.Free');
    end
    else
      lbxInfo.items.add('Memory Result Object - Not Supported')
  end;

  procedure TestMergeResult;
  var
    SRResMerge : ISRResMerge;
  begin
    if IsMergeResult(IUnknownResult, SRResMerge) then
    begin
      lbxInfo.items.add('Merge Result Object - Supported');
    end
    else
      lbxInfo.items.add('Merge Result Object - Not Supported')
  end;

  procedure TestModifyGUIResult;
  var
    SRResModifyGUI : ISRResModifyGUI;
  begin
    if IsModifyGUIResult(IUnknownResult, SRResModifyGUI) then
    begin
      lbxInfo.items.add('ModifyGUI Result Object - Supported');
    end
    else
      lbxInfo.items.add('ModifyGUI Result Object - Not Supported')
  end;

  procedure TestSpeakerResult;
  var
    SRResSpeaker : ISRResSpeaker;
    speaker : array[0..100] of SChar;
    Needed : Integer;
    Score : LongInt;
  begin
    if IsSpeakerResult(IUnknownResult, SRResSpeaker) then
    begin
      lbxInfo.items.add('Speaker Result Object - Supported');
      TryFunc(SRResSpeaker.Identify(0, addr(speaker), 101, Needed, Score), 'SRResSpeaker.Identify');
    end
    else
      lbxInfo.items.add('Speaker Result Object - Not Supported')
  end;

begin
  if (ISRNOTEFIN_RECOGNIZED + ISRNOTEFIN_THISGRAMMAR) = dwFlags then
  reWordsSaid.text := PhraseToString(aPSRPhrase);
  if cbxOnPhraseFinish.Checked then
  begin
    lbxGrammarNotifications.ItemIndex :=
      lbxGrammarNotifications.Items.Add('Phrase Finish Event');
    TestAudioResult;
    TestBasicResult;
    TestCorrectionResult;
    TestEvalResult;
    TestGraphResult(IUnknownResult);
    TestMemoryResult;
    TestMergeResult;
    TestModifyGUIResult;
    TestSpeakerResult;
  end;
end;

procedure TForm1.Grammar1PhraseHypothesisEvent(Sender: TObject;
  dwFlags: Integer; qTimeStampBegin, qTimeStampEnd: Comp;
  aPSRPhrase: PSRPHRASE; IUnknownResult: IUnknown);
begin
  if cbxOnPhraseHypothesis.Checked then
  begin
    lbxGrammarNotifications.ItemIndex :=
      lbxGrammarNotifications.Items.Add('Phrase Hypothesis Event');
    TestGraphResult(IUnknownResult);

  end;
  fLastFileTime := qTimeStampEnd;
end;

procedure TForm1.Grammar1PhraseStartEvent(Sender: TObject;
  TimeStampBegin: Comp);
begin
  if cbxOnPhraseStart.Checked then
  begin
    lbxGrammarNotifications.ItemIndex :=
      lbxGrammarNotifications.Items.Add('Phrase Start Event');
  end;
  fLastFileTime := TimeStampBegin;
end;

procedure TForm1.Grammar1ReEvaluateEvent(Sender: TObject; IUnk: IUnknown);
begin
  if cbxOnReEvaluate.Checked then
  begin
    lbxGrammarNotifications.ItemIndex :=
      lbxGrammarNotifications.Items.Add('ReEvaluate Event');
  end;
end;

procedure TForm1.Grammar1TrainingEvent(Sender: TObject;
  TrainFlag: Integer);
begin
  if cbxOnTraining.Checked then
  begin
    lbxGrammarNotifications.ItemIndex :=
      lbxGrammarNotifications.Items.Add('Tranning Event');
  end;
end;

procedure TForm1.Grammar1UnArchiveEvent(Sender: TObject; IUnk: IUnknown);
begin
  if cbxOnUnArchive.Checked then
  begin
    lbxGrammarNotifications.ItemIndex :=
      lbxGrammarNotifications.Items.Add('UnArchive Event');
  end;
end;

procedure TForm1.btListAppendClick(Sender: TObject);
begin
  if (edListWord.text <> '') and (lbxLists.itemindex >= 0) then
  begin
    Grammar1.ListAppend(lbxLists.items.Strings[lbxLists.itemindex], edListWord.text);
    lbxListWords.clear;
    Grammar1.ListGet(LbxLists.items.Strings[lbxLists.itemindex], lbxListWords.Items);
    edListWord.text := '';
  end;
end;

procedure TForm1.lbxListsClick(Sender: TObject);
begin
  if (lbxLists.itemindex >= 0) then
  begin
    lbxListWords.clear;
    if not Grammar1.ListQuery(LbxLists.items.Strings[lbxLists.itemindex]) then
      lbxListWords.items.add('No items')
    else
      Grammar1.ListGet(LbxLists.items.Strings[lbxLists.itemindex], lbxListWords.Items);
  end;
end;

procedure TForm1.btListRemoveClick(Sender: TObject);
begin
  if (edListWord.text <> '') and (lbxLists.itemindex >= 0) then
  begin
    Grammar1.ListRemove(lbxLists.items.Strings[lbxLists.itemindex], edListWord.text);
    lbxListWords.clear;
    Grammar1.ListGet(LbxLists.items.Strings[lbxLists.itemindex], lbxListWords.Items);
  end;
end;

procedure TForm1.btListSetClick(Sender: TObject);
var
  list : TStringList;
begin
  List := TStringList.create;
  list.add('Apples');
  list.add('Bananas');
  list.add('Oranges');
  Grammar1.ListSet(LbxLists.items.Strings[lbxLists.itemindex], List);
  lbxListWords.clear;
  Grammar1.ListGet(LbxLists.items.Strings[lbxLists.itemindex], lbxListWords.Items);
  list.free;
end;

procedure TForm1.btArchiveClick(Sender: TObject);
var
  Buf : Pointer;
  Size : Integer;
begin
  Grammar1.Archive(False, Buf, Size);
end;

procedure TForm1.btReleaseInfoClick(Sender: TObject);
begin
  Grammar1.ReleaseGrammarInfo;
end;

procedure TForm1.btLoadArchiveClick(Sender: TObject);
begin
  Grammar1.ReloadArchivedGrammar;
end;


end.
