unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, DynArray;

type
  RMyRec = record
    Name   : string[97];
    Age    : smallint;
    end;

  TMyArray = array[0..625] of RMyRec;

  TForm1 = class(TForm)
    btnCreate: TButton;
    ListBox1: TListBox;
    editName: TEdit;
    Label1: TLabel;
    btnDestroy: TButton;
    Bevel1: TBevel;
    btnAdd: TButton;
    btnDel: TButton;
    btnIns: TButton;
    btnMove: TButton;
    Label2: TLabel;
    btnSave: TButton;
    btnLoad: TButton;
    Label3: TLabel;
    Label4: TLabel;
    labSize: TLabel;
    labCount: TLabel;
    btnSwap: TButton;
    btnSortName: TButton;
    editAge: TEdit;
    Label5: TLabel;
    btnSortAge: TButton;
    procedure btnCreateClick(Sender: TObject);
    procedure btnDestroyClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnDelClick(Sender: TObject);
    procedure btnInsClick(Sender: TObject);
    procedure btnMoveClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure btnLoadClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnSwapClick(Sender: TObject);
    procedure btnSortNameClick(Sender: TObject);
    procedure btnSortAgeClick(Sender: TObject);
  private
  public
    procedure RefreshList;
  end;

var
  Form1: TForm1;

  MyArray   : ^TMyArray;
  DynArray1 : TDynArray;
  TmpRec    : RMyRec;

implementation

{$R *.DFM}

{Create array}
procedure TForm1.btnCreateClick(Sender: TObject);
begin
  DynArray1:= TDynArray.Create( sizeof( RMyRec) );
  btnDestroy.enabled   := true;
  btnAdd.enabled       := true;
  btnDel.enabled       := true;
  btnIns.enabled       := true;
  btnMove.enabled      := true;
  btnSave.enabled      := true;
  btnLoad.enabled      := true;
  btnSortName.enabled  := true;
  btnSortAge.enabled   := true;
  btnSwap.enabled      := true;
  labCount.Visible     := true;
  labSize.Visible      := true;
  btnCreate.enabled    := false;
  labcount.caption:= '0';
  labsize.caption:=  '0';
end;

{exit}
procedure TForm1.btnDestroyClick(Sender: TObject);
begin
  DynArray1.Free;
  btnDestroy.enabled   := false;
  btnAdd.enabled       := false;
  btnDel.enabled       := false;
  btnIns.enabled       := false;
  btnMove.enabled      := false;
  btnSave.enabled      := false;
  btnLoad.enabled      := false;
  btnSortName.enabled  := false;
  btnSortAge.enabled   := false;
  btnSwap.enabled      := false;
  labCount.Visible     := false;
  labSize.Visible      := false;
  btnCreate.enabled    := true;
  listbox1.items.clear;
end;

{close form and make sure array gets freed}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if btnDestroy.enabled then DynArray1.Free;
end;

{Add array}
procedure TForm1.btnAddClick(Sender: TObject);
begin
  tmprec.Name:= editName.text;
  tmprec.Age:= strtoint(editAge.text);
  MyArray:= DynArray1.Add( @TmpRec );
  RefreshList;
end;

{Delete array}
procedure TForm1.btnDelClick(Sender: TObject);
begin
  MyArray:= DynArray1.Delete( ListBox1.ItemIndex );
  RefreshList;
end;

{Insert array}
procedure TForm1.btnInsClick(Sender: TObject);
begin
  tmprec.Name:= editName.text;
  tmprec.Age:= strtoint(editAge.text);
  MyArray:= DynArray1.Insert( ListBox1.ItemIndex, @TmpRec );
  RefreshList;
end;

{Move array}
procedure TForm1.btnMoveClick(Sender: TObject);
var
  tmpstr : String;
  tmpint : smallint;
begin
  tmpstr:= inputbox('Move Array Item', 'Move to #', '0');
  tmpint:= strtoint(tmpstr);
  MyArray:= DynArray1.Shift( ListBox1.ItemIndex, tmpint );
  RefreshList;
end;

{save array}
procedure TForm1.btnSaveClick(Sender: TObject);
begin
  MyArray:= DynArray1.Savetofile( 'DYNARRAY.DAT' );
  RefreshList;
end;

{load array}
procedure TForm1.btnLoadClick(Sender: TObject);
begin
  MyArray:= DynArray1.Loadfromfile( 'DYNARRAY.DAT' );
  RefreshList;
end;

{refresh listbox}
procedure TForm1.RefreshList;
var i : smallint;
begin
  listbox1.items.clear;
  for i:= 0 to DynArray1.Count - 1 do
    listbox1.items.add( MyArray^[i].Name+' / '+inttostr(MyArray^[i].Age) );
  labcount.caption:= inttostr( DynArray1.Count );
  labsize.caption:= inttostr( DynArray1.Size );
end;

procedure TForm1.btnSwapClick(Sender: TObject);
var
  tmpstr : String;
  tmpint : smallint;
begin
  tmpstr:= inputbox('Swap Array Items', 'Swap with #', '0');
  tmpint:= strtoint(tmpstr);
  MyArray:= DynArray1.swap( ListBox1.ItemIndex, tmpint );
  RefreshList;
end;

{ Sort DatType:   0-String 1-PChar     2-shortint  3-byte/char }
{     4-smallint  5-word   6-longint   7-single    8-double    }
procedure TForm1.btnSortNameClick(Sender: TObject);
begin
  DynArray1.Sort (  0, 'string' );
  RefreshList;
end;

procedure TForm1.btnSortAgeClick(Sender: TObject);
begin
  DynArray1.Sort ( 97, 'smallint' );
  RefreshList;
end;

end.
