/* Modified Version for Delphi project, Eric W. Engler, Mar 5, 1997 */
/*---------------------------------------------------------------------------
  globals.c
  Routines to allocate and initialize globals, with or without threads.
  Contents:  registerGlobalPointer()
             deregisterGlobalPointer()
             getGlobalPointer()
             globalsCtor()
  ---------------------------------------------------------------------------*/
#ifndef UNZIP_INTERNAL
#define UNZIP_INTERNAL
#endif

#include "unzip.h"

char *fnames[2] = {"*", NULL};   /* default filenames vector */

// EWE: REENTRANT is not defined for this version

struct Globals G;

// initialize global fields
struct Globals *globalsCtor()
{
    memzero(&G, sizeof(struct Globals));

    G.lflag=(-1);
    G.wildzipfn = "";
    G.pfnames = fnames;
    G.pxnames = &fnames[1];
    G.pInfo = G.info;
    G.sol = TRUE;          /* at start of line */
    G.local_hdr_sig[1] = G.central_hdr_sig[1] = G.end_central_sig[1] = '\0';

    return &G;
}
