/* Modified Version for Delphi project, Eric W. Engler, Mar 5, 1997 */
// EWE NOTE:  Everything in this file is critical!
/*---------------------------------------------------------------------------
  unzip.h 
  This header file contains the public macros and typedefs required by
  both the UnZip sources and by any application using the UnZip API.  If
  UNZIP_INTERNAL is defined, it includes unzpriv.h, which then includes
  globals.h.
 ---------------------------------------------------------------------------*/
// EWE Note: see also UNZPRIV.H

#ifndef __unzip_h   /* prevent multiple inclusions */
#define __unzip_h

#include "unzerr.h"

#define nmalloc malloc
#include <stdio.h>

/* added by E. Engler; these are in dllmain.c */
extern int __cdecl MyTrace(FILE *, const char *, ...); // see Trace macro in unzcomp.h
extern void user_callback(long action, long error_code, long fsize, char *name_or_msg);
extern void msgbox(char *msg);
extern void diag(char *msg);
extern void unzerr(int c);
extern char ewemsg[2048];
extern int  global_trace_opt;
extern int  global_abort_sw;
extern int  global_error_code;
extern int  files_acted_on;
extern int  dll_handles_errors;
extern int  user_notified_of_abort;

/*****************************************/
/*  Predefined, Machine-specific Macros  */
/*****************************************/
#if (!defined(WIN32))
#  define WIN32
#endif

#if (!defined(WIZDLL))
#  define WIZDLL
#endif

#if (!defined(DOSWILD))
#  define DOSWILD
#endif

#if (!defined(DLL))
#  define DLL
#endif

#if (!defined(NO_ZIPINFO))
#  define NO_ZIPINFO
#endif

#if (!defined(WIZUNZIPDLL))
#  define WIZUNZIPDLL
#endif

#if (!defined(MSDOS))
#  define MSDOS
#endif

#if (!defined(UNZIP_INTERNAL))
#  define UNZIP_INTERNAL   // EWE
#endif

// By defining COPYRIGHT_CLEAN, we lose support for these 2 compression
// types: tokenizing (which was never popular)
//   and  reducing   (which was only used in pre-v1 beta releases of PKZIP
#ifndef COPYRIGHT_CLEAN
#  define COPYRIGHT_CLEAN
#endif

#ifndef NO_MULTIPART
#define NO_MULTIPART
#endif

#ifndef TRUE
#  define TRUE      1   /* sort of obvious */
#endif
#ifndef FALSE
#  define FALSE     0
#endif


#ifdef REENTRANT
#undef REENTRANT   // EWE - REENTRANT is not defined in this version
#endif

#ifdef SFX
#undef SFX  // EWE: this is only for compiling the actual SFX binary code
#endif

#if (defined ASM_INFLATECODES)
#undef ASM_INFLATECODES
#endif

#if (defined ASM_CRC)
#undef ASM_CRC
#endif

#ifndef PROTO
#  define PROTO
#endif

#ifndef MODERN
#  define MODERN
#endif

/* used to remove arguments in function prototypes for non-ANSI C */
#ifdef PROTO
#  define OF(a) a
#else
#  define OF(a) ()
#endif

/* Be cautious and disable the "const" keyword if in doubt. */
#if (!defined(MODERN) && !defined(NO_CONST))
#  define NO_CONST
#endif /* !MODERN && !NO_CONST */

/* Avoid using const if compiler does not support it */
#ifdef NO_CONST
#  ifdef const
#    undef const
#  endif
#  define const
#endif

#define SSTAT stat
#define STRNICMP zstrnicmp

// EWE note: All platforms need this VMS version:
#define VMS_UNZIP_VERSION 42

/***************************/
/*  OS-Dependent Includes  */
/***************************/
#define LONGINT long

#ifdef MODERN
#  ifndef NO_STDDEF_H
#    include <stddef.h>
#  endif
#  ifndef NO_STDLIB_H
#    include <stdlib.h>  /* standard library prototypes, malloc(), etc. */
#  endif
   typedef size_t extent;
   typedef void zvoid;
#else /* !MODERN */
#  ifndef AOS_VS         /* mostly modern? */
#    ifndef CMS_MVS
       LONGINT lseek();
#    endif
#    ifdef VAXC          /* not fully modern, but does have stdlib.h and void */
#      include <stdlib.h>
#    else
       char *malloc();
#      define void int
#    endif /* ?VAXC */
#  endif /* !AOS_VS */
   typedef unsigned int extent;
   typedef char zvoid;
#endif /* ?MODERN */

typedef unsigned char   uch;    /* code assumes unsigned bytes; these type-  */
typedef unsigned short  ush;    /*  defs replace byte/UWORD/ULONG (which are */
typedef unsigned long   ulg;    /*  predefined on some systems) & match zip  */

/* InputFn is not yet used and is likely to change: */
#ifdef PROTO
   typedef int   (MsgFn)    (zvoid *pG, uch *buf, ulg size, int flag);
   typedef int   (InputFn)  (zvoid *pG, uch *buf, int *size, int flag);
   typedef void  (PauseFn)  (zvoid *pG, const char *prompt, int flag);
#else
   typedef int   (MsgFn)    ();
   typedef int   (InputFn)  ();
   typedef void  (PauseFn)  ();
#endif

typedef struct _UzpBuffer {   /* rxstr */
    ulg   strlength;          /* length of string  */
    char  *strptr;            /* pointer to string */
} UzpBuffer;

typedef struct _UzpInit {
    ulg structlen;            /* length of the struct being passed */

    /* GRR: can we assume that each of these is a 32-bit pointer?  if not,
     * does it matter? add "far" keyword to make sure? */
    MsgFn *msgfn;
    InputFn *inputfn;
    PauseFn *pausefn;

    void (*userfn)();   /* user init function to be called after globals */
                        /*  constructed and initialized */

    /* pointer to program's environment area or something? */
    /* hooks for performance testing? */
    /* hooks for extra unzip -v output? (detect CPU or other hardware?) */
    /* anything else?  let me (Greg) know... */
} UzpInit;

#ifdef NEVER
/* intended to be a private struct: */
typedef struct _ver {
    uch major;              /* e.g., integer 5 */
    uch minor;              /* e.g., 2 */
    uch patchlevel;         /* e.g., 0 */
    uch not_used;
} _version_type;

typedef struct _UzpVer {
    ulg structlen;          /* length of the struct being passed */
    ulg flag;               /* bit 0: is_beta   bit 1: uses_zlib */
    char *betalevel;        /* e.g., "g BETA" or "" */
    char *date;             /* e.g., "4 Sep 95" (beta) or "4 September 1995" */
    char *zlib_version;     /* e.g., "0.95" or NULL */
    _version_type unzip;
    _version_type zipinfo;
    _version_type os2dll;
    _version_type windll;
} UzpVer;
#endif

typedef struct central_directory_file_header { /* CENTRAL */
    uch version_made_by[2];
    uch version_needed_to_extract[2];
    ush general_purpose_bit_flag;
    ush compression_method;
    ush last_mod_file_time;
    ush last_mod_file_date;
    ulg crc32;
    ulg csize;
    ulg ucsize;
    ush filename_length;
    ush extra_field_length;
    ush file_comment_length;
    ush disk_number_start;
    ush internal_file_attributes;
    ulg external_file_attributes;
    ulg relative_offset_local_header;
} cdir_file_hdr;


#define UZPINIT_LEN   sizeof(UzpInit)
// #define UZPVER_LEN    sizeof(UzpVer)
#define cbList(func)  int (*func)(char *filename, cdir_file_hdr *crec)

/*---------------------------------------------------------------------------
    Prototypes for public UnZip API (DLL) functions.
  ---------------------------------------------------------------------------*/
int      UzpMain            OF((int argc, char **argv));
int      UzpAltMain         OF((int argc, char **argv, UzpInit *init));
// UzpVer  *UzpVersion         OF((void));
int      UzpUnzipToMemory   OF((char *zip, char *file, UzpBuffer *retstr));
int      UzpFileTree        OF((char *name, cbList(callBack),
                                char *cpInclude[], char *cpExclude[]));

/* default I/O functions (can be swapped out via UzpAltMain() entry point): */
int      UzpMessagePrnt     OF((zvoid *pG, uch *buf, ulg size, int flag));
int      UzpMessageNull     OF((zvoid *pG, uch *buf, ulg size, int flag));
int      UzpInput           OF((zvoid *pG, uch *buf, int *size, int flag));
// void     UzpMorePause       OF((zvoid *pG, const char *prompt, int flag));

/*---------------------------------------------------------------------------
    Remaining private stuff for UnZip compilation.
  ---------------------------------------------------------------------------*/
#ifdef UNZIP_INTERNAL    // should always be defined for the DLL code
#include "unzpriv.h"
#endif

#endif /* !__unzip_h */
