/* wizunzip.h    This is the main UNZIP DLL interface descriptions. */
/* Based on Windows Info-ZIP Unzip, version 3.0.
 * Authors: Robert A. Heath, M. White
 * Modified Version for Delphi project, Eric W. Engler, Mar 5, 1997 
 */
/* WARNING: Although there is much support in this C code for
   Windows 3.1, I have not attempted to validate this code with
   3.1, and I am pretty sure more work is needed to back port
   this code completely.

   I used Microsoft Visual C++, v4.0 for this port, but I
   understand it is easy to port to Borland C++, v4.5 or up.
   Do not use Borland C++,v5.0 (it's buggy), but 5.01 may work.
   Some Borland-specific code is conditionally used in this
   project, but this version of UNZIP hasn't been tested under
   a Borland C++ compiler.

   No use is made of C++ features in any of the code modules, so
   if you're only familier with C, you will feel right at home.
   Of course, this also means that we aren't using any
   vendor-specific class libraries (MFC, OWL, etc.).
  - Eric W. Engler */

#ifndef __wizunzip_h   /* prevent multiple inclusions */
#define __wizunzip_h

#include <windows.h>

#define STDIO_BUF_SIZE 16384

/* Allow compilation under Borland C++ also */
#ifndef __based
#define __based(A)
#endif

/* Porting definations between Win 3.1x and Win32 */

#ifdef WIN32
#  define far
#  define _far
#  define __far
#  define near
#  define _near
#  define __near
#endif

/* The following is to take care of some of the porting problems between
 * Win 3.1 and Win32 for WM_COMMAND notifications.
*/
#ifdef WIN32
#define GET_WM_COMMAND_CMD(wp, lp) HIWORD(wp)
#else
#define GET_WM_COMMAND_CMD(wp, lp) HIWORD(lp)
#endif

#define WIZUNZIP_MAX_PATH  255  /* max length of directory & fname path */

#ifndef NDEBUG
#define WinAssert(exp) \
        {\
        if (!(exp))\
            {\
            char szBuffer[40];\
            sprintf(szBuffer, "File %s, Line %d",\
                    __FILE__, __LINE__) ;\
            if (IDABORT == MessageBox((HWND)NULL, szBuffer,\
                "Assertion Error",\
                MB_ABORTRETRYIGNORE|MB_ICONSTOP))\
                    FatalExit(-1);\
            }\
        }
#else
#define WinAssert(exp)
#endif

/* define the data passed back to the Delphi callback function */
typedef struct {
   HWND handle;
   long caller;
   long version;
   BOOL isoperationzip; // true=zip, false=unzip
   long actioncode;
   long error_code;
   long fsize;
   char filenameormsg[512]; /* NOTE: NOT a pointer - data is here */
} callbackstruct;

// We can't use BOOL as return type in the following typedef, so we use "long".
// typedef __declspec(dllimport) long (CALLBACK *DLLCALLBK) (callbackstruct *);
typedef long (CALLBACK *DLLCALLBK) (callbackstruct *);

/* Unzip Miscellaneous Buffers (UMB) */
typedef struct
{
  /* fully-qualified archive file name in OEM char set */
  char szFileName[WIZUNZIP_MAX_PATH];

  /* directory of archive file in ANSI char set */
  char szDirName[WIZUNZIP_MAX_PATH];  

  /* extraction ("unzip to") directory name in ANSI */
  char szUnzipToDirName[WIZUNZIP_MAX_PATH];

  /* temp extraction ("unzip to") directory name in ANSI */
  char szUnzipToDirNameTmp[WIZUNZIP_MAX_PATH]; 

  /* extraction ("unzip from") directory name in ANSI */
  char szUnzipFromDirName[WIZUNZIP_MAX_PATH]; 
 
  /* text for totals of zip archive */
  char szTotalsLine[80];                       

  char szPassword[81];  /* not yet supported */
  LPSTR lpPassword;

  OPENFILENAME ofn;                   /* name of open file */
  MSG msg;
  OFSTRUCT of;                        /* archive open file struct */
} UMB, __far *LPUMB;

extern UMB Buffers;
extern LPUMB lpumb;

// DLL Command Line (DCL)
typedef struct {
   HWND handle;        /* handle of calling pgm's active Window */
   long caller;        /* object instance ("self") of calling Delphi form
                     (not used in DLL; returned to Delphi via callback) */
   long version;       /* version no. that Delphi Applic. expects */
   DLLCALLBK callback;
   BOOL fTraceEnabled;
   /*===================================================*/
   /* regular switches */
   BOOL fPromptToOverwrite; // not supported yet
   BOOL fDecrypt;           // not supported yet
   BOOL fTest;              // if true, test zipfile (not supported yet)
   BOOL fComments;           // show zip comment (not supported yet)
   BOOL fConvert;           // if true, do ASCII/EBCDIC or EOL translation

   BOOL fQuiet;          // DLL be quiet!
   BOOL fVerbose;        // verbose flag
   BOOL fUpdate;         // "update" (extract only newer files & brand new files)
   BOOL fFreshen;        // "freshen" (extract only newer files that already exist)
   BOOL fDirectories;    // if true, recreate dir structure
   BOOL fOverwrite;      // if true, overwrite existing (no asking)

   long argc;          //  Count of filespecs to extract
   LPSTR lpszZipFN;    // ptr to zip filename
   int seven;          // stick a 7 in here to validate the struct offsets
   char *FNV[];        // array of filespec args to extract
} DCL, _far *LPDCL;

extern LPDCL lpDCL;

BOOL WizUnzipInit(HANDLE hInst);
int win_fprintf(FILE *file, unsigned int, char *);
void GetDirectory(LPSTR lpDir);
BOOL MakeDirectory(char *path, BOOL fileAttached);
LPSTR lstrrchr(LPSTR lpszSrc, char chFind);

/* Exports from the DLL */
long WINAPI UnzDllExec(DCL *C);
long WINAPI GetUnzDllVersion(void);
#endif
