/* dllmain.c
 Copyright (C) 1997 Mike White and Eric W. Engler
 Permission is granted to any individual or institution to use, copy, or
 redistribute this software so long as all of the original files are included,
 that it is not sold for profit, and that this copyright notice is retained.
*/

#include <windows.h>
#include "zip.h"
#include "crypt.h"
#include <process.h>
#include <signal.h>
#include <stdarg.h>

#include "wizzip.h"
#include "version.h"


// see wizzip.h
DLLCALLBK callb;
callbackstruct  callbackdata;

/* These are DLL specific globals. */
char ewemsg[2048];
char ewetmp[2048];  
int  global_trace_opt;
int  global_abort_sw;
int  global_error_code;
int  files_acted_on;
int  dll_handles_errors;
long global_caller;
HWND global_handle;

int user_notified_of_abort;

/* DLL Entry Point */
#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL WINAPI DllEntryPoint( HINSTANCE hinstDll,
                           DWORD fdwRreason,
                           LPVOID plvReserved)
{
   return 1;   /* Indicate that the DLL was initialized successfully. */
}

#ifdef __BORLANDC__
#pragma warn .par
#endif
extern int  zipmain OF((int, char **));

/* Add, update, freshen, move, or delete zip entries in a zip file.  
   SEE THE FILE "SWITCHES.TXT" FOR MORE INFO. ON PROCESSING */
long WINAPI ZipDllExec(ZCL *C)
{
   int argCee, i, k;
   char **argVee;

   global_abort_sw=0;
   global_error_code=0;
   files_acted_on=0;
   dll_handles_errors=1; // By dflt, this DLL will generate error msg boxes
   user_notified_of_abort=0;
   
   /* Copy the window handle and context of caller to our global vars */
   global_handle=C->handle;
   global_caller=C->caller;

   // Uncomment the following line to quickly validate the
   // window handle passed in.
   // msgbox("Test of ZIPDLL");

   /* point to the Delphi callback function */
   callb=C->callback;

   global_trace_opt=C->fTraceEnabled;
   diag("trace is on in ZIPDLL.DLL");

   /*----------------------------------------------------------------*/
   if (C->lpszZipFN == NULL) /* Something screwed up, we don't have a filename */
      {
      diag("no zip filename received");
      return -1;
      }
   if (C->seven != 7)
      {
      diag("struct size mismatch");
      return -2;
      }
   if (C->version != ZIPVERS) // see version.h
      {
      // This message won't appear if user didn't pass us a nonzero 
      // Window handle
      msgbox("Warning: ZIPDLL.DLL version may be incorrect");
      // "fprintf" will report the error via the Delphi callback
      fprintf(stderr,"Warning: ZIPDLL.DLL version may be incorrect");
      }
   /*----------------------------------------------------------------*/
   /* malloc 26 vectors more than the no. of filenames - allows for
      max no. of command line arguments */
   argVee = (char **)malloc((C->argc + 26)*sizeof(char *));

   i=0;
   argVee[i] = (char *) malloc( sizeof(char) * strlen("zipdll.dll")+1 );
   strcpy(argVee[i++], "zipdll.dll");

   /* allocate room for compression level switch */
   argVee[i] = (char *) malloc( sizeof(char) * strlen("-0")+1 );
   switch (C->fLevel) {
      case 9: strcpy(argVee[i], "-9"); break;
      case 8: strcpy(argVee[i], "-8"); break;
      case 7: strcpy(argVee[i], "-7"); break;
      case 6: strcpy(argVee[i], "-6"); break;
      case 5: strcpy(argVee[i], "-5"); break;
      case 4: strcpy(argVee[i], "-4"); break;
      case 3: strcpy(argVee[i], "-3"); break;
      case 2: strcpy(argVee[i], "-2"); break;
      case 1: strcpy(argVee[i], "-1"); break;
      case 0: strcpy(argVee[i], "-0"); break;
      default: strcpy(argVee[i], "-9");
   }
   i++;  // Don't forget to point to next arg location!

   sprintf(ewemsg,"in %s; at fLevel, which is: %d", argVee[0], C->fLevel);
   diag(ewemsg);

   /* build the conventional cmd line switches */
   if (C->fDeleteEntries)    /* Delete files from zip file -d */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-d")+1 );
      strcpy( argVee[i++], "-d" );
      }
   if (C->fNoDirEntries) /* Do not add directory entries -D */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-D")+1 );
      strcpy( argVee[i++], "-D" );
      }
   if (C->fFreshen) /* Freshen zip file--overwrite only -f */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-f")+1 );
      strcpy( argVee[i++], "-f" );
      }
   if (C->fGrow) /* Allow appending to a zip file -g   Normally TRUE */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-g")+1 );
      strcpy( argVee[i++], "-g" );
      }
   if (C->fJunkDir) /* Junk directory names -j */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-j")+1 );
      strcpy( argVee[i++], "-j" );
      }
   if (C->fJunkSFX) /* Junk sfx prefix */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-J")+1 );
      strcpy( argVee[i++], "-J" );
      }
   if (C->fForce) /* Make entries using DOS names (k for Katz) -k */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-k")+1 );
      strcpy( argVee[i++], "-k" );
      }
   if (C->fCRLF_LF) /* Translate end-of-line -l */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-l")+1 );
      strcpy( argVee[i++], "-l" );
      }
   if (C->fMove) /* Delete files added or updated in zip file -m */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-m")+1 );
      strcpy( argVee[i++], "-m" );
      }
   if (C->fLatestTime) /* Set zip file time to time of latest file in it -o */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-o")+1 );
      strcpy( argVee[i++], "-o" );
      }
   if ((C->fQuiet) || (C->handle == 0)) /* quiet operation -q */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-q")+1 );
      strcpy( argVee[i++], "-q" );
      dll_handles_errors=0;  // All error msgs passed to caller via callback function
      }
   if (C->fRecurse) /* recurse into subdirectories -r */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-r")+1 );
      strcpy( argVee[i++], "-r" );
      }
   if (C->fSystem)  /* include system and hidden files -S */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-S")+1 );
      strcpy( argVee[i++], "-S" );
      }
   if (C->fDate)    /* Exclude files earlier than specified date -t */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-t")+1 );
      strcpy( argVee[i++], "-t" );

      /* date must follow the -t switch */
      argVee[i] = (char *) malloc( sizeof(char) * strlen(C->Date)+1);
      strcpy( argVee[i++], C->Date);
      }
   if (C->fUpdate) /* Update zip file--overwrite only if newer -u */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-u")+1 );
      strcpy( argVee[i++], "-u" );
      }
   if ((C->fVerbose) || (global_trace_opt))  /* verbose messages -v */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-v")+1 );
      strcpy( argVee[i++], "-v" );
      }
   if (C->fVolume)  /* Include volume label -$ */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-$")+1 );
      strcpy( argVee[i++], "-$" );
      }
   if (C->fExtra)  /* Include extra attributes -X */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-X")+1 );
      strcpy( argVee[i++], "-X" );
      }
   if (C->fComprSpecial) /* try to compress files that are alreay compressed */
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen("-!")+1 );
      strcpy( argVee[i++], "-!" );
      }

   /* Malloc space for the name of the zip file, and copy the name in */
   argVee[i] = (char *) malloc( sizeof(char) * strlen(C->lpszZipFN)+1 );
   strcpy( argVee[i++], C->lpszZipFN );

   /* malloc space for each filename to add, and copy the names in */
   /* FNV = filename vector in param struct:   char *FNV[];  */
   /* Note: "i" points to next free loc in the array we will send to ZipMain. */
   /* We should already have some items in this array (cmd line sw's). */
   for (k = 0; k < C->argc; k++)
      {
      argVee[i] = (char *) malloc( sizeof(char) * strlen(C->FNV[k])+1 );
      strcpy( argVee[i++], C->FNV[k] );
      }

   /* we won't malloc space for last one - it's just a null pointer */
   argVee[i] = NULL; /* no more filename args */
   argCee=i;  /* no. of args for ZipMain (1 based) */

   for (k = 0; k < argCee; k++)
      {
      sprintf(ewemsg,"Arg: %d for zipmain:  %s ", k, argVee[k]);
      diag(ewemsg);
      }

   diag("*** READY TO CALL ZIPMAIN IN DLLZIP.C ***");
   zipmain(argCee, argVee);
   diag("*** BACK FROM CALL TO ZIPMAIN ***");

   /* Free the arguments in the array */
   for (i = 0; i < argCee; i++)
      {
      free (argVee[i]);
      argVee[i] = NULL;
      }

   /* Then free the array itself */
   free(argVee);
   if (C->fVerbose)
      printf("Files acted on = %ld", files_acted_on);
   return (long)files_acted_on;
}

#define STDIO_BUF_SIZE 16384

/* printf buffers the current output and counts the number of lines
 * within it.  It makes sure there is enough space in the global
 * buffer, then copies the buffered data to the global buffer.
 * It then triggers a repaint of the status buffer.
 */
int __far __cdecl printf(const char *format, ...)
{
   va_list argptr;
   HANDLE hMemory;
   PSTR pszBuffer;
   int len;

   va_start(argptr, format);
   hMemory = GlobalAlloc(GMEM_MOVEABLE, STDIO_BUF_SIZE);
   WinAssert(hMemory);
   if (!hMemory)
      {
      return 0;
      }
   pszBuffer = (PSTR)GlobalLock(hMemory);
   WinAssert(pszBuffer);
   len = wvsprintf(pszBuffer, format, argptr);
   va_end(argptr);
   WinAssert(strlen(pszBuffer) < STDIO_BUF_SIZE);

   // This isn't an important error, it's just a status msg
   user_callback(4, 0, 0, pszBuffer); 

   GlobalUnlock(hMemory);
   GlobalFree(hMemory);
   return len;
}

#ifdef __BORLANDC__
#pragma argsused
#endif

/* fprintf clone for code in dllzip.c, etc. */
int __far __cdecl fprintf(FILE *file, const char *format, ...)
{
   va_list argptr;
   HANDLE hMemory;
   LPSTR pszBuffer;
   int len;

   va_start(argptr, format);
   hMemory = GlobalAlloc(GMEM_MOVEABLE, STDIO_BUF_SIZE);
   WinAssert(hMemory);
   if (!hMemory)
      return 0;
   pszBuffer = GlobalLock(hMemory);
   WinAssert(pszBuffer);
   len = wvsprintf(pszBuffer, format, argptr);
   va_end(argptr);
   WinAssert(strlen(pszBuffer) < STDIO_BUF_SIZE);

   // warning msg, or info msg only
   user_callback(4, 0, 0, pszBuffer);

   GlobalUnlock(hMemory);
   GlobalFree(hMemory);
   return len;
}

/*=====================================================
  Do NOT use this type of declaration: 
  Despite what Microsoft advises, this usu causes the 
  wrong calling convention to be used (you end up with cdecl 
  instead of stdcall).
   __declspec(dllexport) long GetZipDllVersion(void)  BAD BAD BAD!!!
 =====================================================*/
long WINAPI GetZipDllVersion(void)
{  /* see version.h */
   return ZIPVERS;
}

// ziperr() is the preferred error msg function!!!
void msgbox(char *msg)
{
    if (global_handle == 0)
       // user didn't pass us a good window handle - we can't pop-up a box
       exit;
    /* bring up a dialog box */
    strcpy(ewetmp, "Msg From ZIP DLL: ");
    strcat(ewetmp, msg);
    MessageBox(global_handle, ewetmp, "Msg From ZIP DLL", MB_OK);
}

void diag(char *msg)
{
   if (global_trace_opt)
      {
      /* log the message through the routine msg callback */
      strcpy(ewetmp, "Trace Msg: ");
      strcat(ewetmp, msg);
      /* specify a 0 error code to prevent a dialog box from coming 
         up in the Delphi applic pgm */
      user_callback(4, 0, 0, ewetmp);  
      }
}

#ifdef NEVER
   This provides the calling program with updated info on what the DLL 
   is doing.  Regardless of the type of call being made, the user's
   function must have a spin of the Windows message loop.  In fact, even
   if user isn't using a progress bar, he should still spin the msg 
   loop upon getting these callbacks (but he doesn't need to do anything 
   else).  In Delphi, "Application.ProcessMessages;" spins the loop.
   Here are the types of calls:

     ActionCode = 1, we're starting a zip operation on a new file
        error_code = N/A
        fsize = filesize of file we're going to operate on
        name_or_msg = pathname of file 
     IMPORTANT: The user's function must do the math for the progress
     bar upon getting this call.  See the Delphi sample application.

     ActionCode = 2, increment the progress bar
        These calls will occur after every 32K of input file has been
        processed. One additional call is made at the end of each file, 
        just to make sure the progress bar is max'ed out - this is also
        critical for files less than 32K in size (this last one will be 
        their only one).
        error_code = N/A
        fsize = N/A
        name_or_msg = N/A 

     ActionCode = 3, we're done with a batch of files - program flow
     will quickly return to the user's program.
     NOTE: the end of a every file will always be followed by an
           action of 1 or 3, so a separate call for end of one file
           isn't needed.
        error_code = N/A
        fsize = N/A 
        name_or_msg = N/A 

     ActionCode = 4, a routine message is being passed
        error_code = code corresponding to message (not widely used yet)
        fsize = N/A 
        name_or_msg = text of message
#endif

// This calls the application program and passes status info
void user_callback(long action, long error_code, long fsize, char *name_or_msg)
{
   callbackdata.handle=global_handle;  /* Window handle of caller */
   callbackdata.caller=global_caller;  /* object instance pointer of caller */
                            /* (from the initial call to DllZipUpFiles)*/
   callbackdata.version=ZIPVERS;
   callbackdata.isoperationzip=TRUE; // true=zip, false=unzip
   callbackdata.actioncode=action;
   callbackdata.error_code=error_code; 
   callbackdata.fsize=fsize;
   if (name_or_msg == NULL)
      callbackdata.filenameormsg[0]=0;
   else
      strcpy(callbackdata.filenameormsg, name_or_msg);

   /* make the call and check the return code.  If true is returned, user
      wants to abort the current batch job */
   global_abort_sw=callb(&callbackdata);  // call user's program 

   // don't bother looking at the global_abort_sw here!
}
