unit Testfrm;

interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, StdCtrls, Enhlbox, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    MCEnhancedListBox1: TMCEnhancedListBox;
    Label1: TLabel;
    Label2: TLabel;
    MCEnhancedListBox2: TMCEnhancedListBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure MCEnhancedListBox1DrawItem(Control: TWinControl;
      Index: Integer; Rect: TRect; State: TOwnerDrawState);
  private
    { Private declarations }
	public
    { Public declarations }
  end;

var
	Form1: TForm1;
	Bmp: array[1..100] of TBitmap;
	Bmps: integer;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
const
	NoGlyphs: PChar =
		'Couldn''t find any glyphs for my list in C:\DELPHI\IMAGES\BUTTONS\ -' + #13#10 +
		'you have to change the FormCrate procedure to include the correct path!';
var
	Res: integer;
	SR: TSearchRec;
begin
	Res := FindFirst('C:\DELPHI\IMAGES\BUTTONS\ARR*.BMP', 0, SR);
	while Res = 0 do
		begin
			inc(Bmps);
			Bmp[Bmps] := TBitmap.Create;
			Bmp[Bmps].LoadFromFile('C:\DELPHI\IMAGES\BUTTONS\' + SR.Name);
			MCEnhancedListBox1.Items.Add(SR.Name + #9 + IntToStr(SR.Size));
			Res := FindNext(SR);
		end;
	FindClose(SR);
	if MCEnhancedListBox1.Items.Count = 0 then
		Application.MessageBox(NoGlyphs, 'Error', MB_APPLMODAL or MB_ICONEXCLAMATION or MB_OK);
end;

procedure TForm1.FormDestroy(Sender: TObject);
var
	i: integer;
begin
	for i := 1 to Bmps do
		Bmp[i].Free;
end;

procedure TForm1.MCEnhancedListBox1DrawItem(Control: TWinControl;
	Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
	with Control as TMCEnhancedListBox, (Control as TMCEnhancedListBox).Canvas do
		begin
			FillRect(Rect);
			Draw(Rect.Left + 10, Rect.Top, Bmp[Index + 1]);
			TextOut(PartX[1], Rect.Top, PartString[Index, 1]);
			TextOut(PartX[2], Rect.Top, PartString[Index, 2]);
		end;
end;

end.
