{+--------------------------------------------------------------------------+
 | Component: TShellTreeView
 | Author: Jeff Kinzer
 |         102413.3557@compuserve.com
 | Copyright 1996, all rights reserved.
 | Description: Displays a hierarchial view of the user's Computer, such as
 |              that used in the Windows 95 Explorer.
 | Version: 1.0 Beta
 +--------------------------------------------------------------------------+}

unit ShellView;

//  NOTE:  
//    This code was edited heavily to remove all top secret proprietory 
//    code and functionality.  This is not the complete component.

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ShellApi, ShellObj, ShellUtl, OLE2, CommCtrl;

type
  TShellTreeView = class(TCustomTreeView)
  private
    { Private declarations }
    FTreeChanged: TNotifyEvent;
    FImages: TImageList;
    FDeskFolder: IShellFolder;
    FDeskItems: PItemIDList;
    FShellMalloc: IMalloc;
    procedure WMCreate(var Msg: TWMCreate); message WM_CREATE;
  protected
    { Protected declarations }
    function DeskFolder: IShellFolder;
    procedure CreateWnd; override;
    procedure BuildTree; virtual;
    procedure FillTree(AFolder: IShellFolder; AItemList: PItemIDList; AParent: TTreeNode);
    function CanExpand(Node: TTreeNode): Boolean; override;
  public
    { Public declarations }
  published
    { Published declarations }
  end;

  PItemData = ^TItemData;
  TItemData = record
    sfParent: IShellFolder;
    idItemList: PItemIDList;
  end;

implementation

function GetIcon(FileID: Pointer; Flags: Word; RetIcon: Boolean): Integer;
var
  AFileInfo: TSHFileInfo;
begin
  Result := SHGetFileInfo(FileID, 0, AFileInfo, SizeOf(AFileInfo), Flags);
  if RetIcon then
    Result := AFileInfo.iIcon;
end;

function GetNameOf(AFolder: IShellFolder; AItemList: PItemIDList; Flags: LongInt): PChar;
var
  AStr: TStrRet;
begin
  if AFolder.GetDisplayNameOf(AItemList, Flags, @AStr) = 0 then
  begin
    case AStr.uType of
      STRRET_WSTR: WideCharToMultiByte(CP_ACP, 0, AStr.pOleStr, -1,
        Result, SizeOf(Result), nil, PBool(0));
      STRRET_OFFSET: Result := PChar(LongInt(AItemList) + AStr.uOffset);
      STRRET_CSTR: Result := AStr.cStr;
    end;
  end;
end;

function CopyItemID(AMalloc: IMalloc; AItemList: PItemIDList): PItemIDList;
var
  ASize: Integer;
begin
  ASize := AItemList^.mkID.cb + SizeOf(AItemList^.mkID.cb);
  Result := AMalloc.Alloc(ASize);
  CopyMemory(Result, AItemList, ASize);
end;

procedure TShellTreeView.WMCreate(var Msg: TWMCreate);
begin
  inherited;
  SHGetMalloc(FShellMalloc);
  Update;
end;

function TShellTreeView.CanExpand(Node: TTreeNode): Boolean;
var
  NewData: PItemData;
  AFolder: IShellFolder;
begin
  Result := inherited CanExpand(Node);
  if Node.Count = 0 then
  begin
    NewData := PItemData(Node.Data);
    Result := Succeeded(NewData^.sfParent.BindToObject(NewData^.idItemList, nil, IID_IShellFolder, Pointer(AFolder)));
    if Result then
      FillTree(AFolder, NewData^.idFullList, Node);
  end;
end;

procedure TShellTreeView.BuildTree;
var
  DeskInfo: TSHFileInfo;
begin
  Items.Clear;
  SHGetSpecialFolderLocation(Handle, CSIDL_DESKTOP, FDeskItems);
  if not Assigned(FImages) then
  begin
    FImages := TImageList.Create(Self);
    FImages.ShareImages := True;
    Images := FImages;
  end;
  Images.Handle := GetIcon(FDeskItems, SHGFI_PIDL or SHGFI_SYSICONINDEX or SHGFI_SMALLICON, False);
  FillTree(DeskFolder, FDeskItems, nil);
end;

procedure TShellTreeView.FillTree(AFolder: IShellFolder; AItemList: PItemIDList; AParent: TTreeNode);
const
  SFGAO_FolderAttribs = SFGAO_HASSUBFOLDER or SFGAO_FOLDER;
var
  HR: HResult;
  SaveCursor: TCursor;
  AEnumList: IEnumIDList;
  NewItem,
  EntireList,
  TempList: PItemIDList;
  NewAttrib,
  i,
  NewCount: LongInt;
  NewHasChild: Boolean;
  NewData: PItemData;
  NewText: String;
  DataStr: PChar;
begin
  ViewPidlContents(AItemList);
  if Succeeded(HR) then
  begin
    SaveCursor := Screen.Cursor;
    Screen.Cursor := crHourglass;
    try
      HR := AFolder.EnumObjects(Handle, SHCONTF_FOLDERS or SHCONTF_NONFOLDERS, AEnumList);
      if Succeeded(HR) then
      begin
        i := 0;
        while AEnumList.Next(1, NewItem, NewCount) = S_OK do
        begin
          NewAttrib := SFGAO_FolderAttribs;
          AFolder.GetAttributesOf(1, NewItem, UINT(NewAttrib));
          if (NewAttrib and SFGAO_FolderAttribs) <> 0 then
          begin
            NewHasChild := ((NewAttrib and SFGAO_FOLDER) = SFGAO_FOLDER) and
               ((NewAttrib and SFGAO_HASSUBFOLDER) = SFGAO_HASSUBFOLDER);
            NewData := FShellMalloc.Alloc(SizeOf(NewData));
            NewText := GetNameOf(AFolder, NewItem, SHGDN_NORMAL);
            EntireList := CombineLists(AItemList, NewItem);
            with NewData^ do
            begin
              sfParent := AFolder;
              AFolder.AddRef;
              idItemList := CopyItemID(FShellMalloc, NewItem);
            end;
            with Items.AddChildObject(AParent, NewText, NewData) do
            begin
              HasChildren := NewHasChild;
              ImageIndex := GetIcon(NewData^.idFullList, SHGFI_PIDL or SHGFI_SYSICONINDEX or SHGFI_SMALLICON, True);
              SelectedIndex := GetIcon(NewData^.idFullList, SHGFI_PIDL or SHGFI_SYSICONINDEX or SHGFI_SMALLICON or SHGFI_OPENICON, True);
            end;
            inc(i);
          end;
          FShellMalloc.Free(EntireList);
          EntireList := nil;
        end;
        FShellMalloc.Free(NewItem);
        NewItem := nil;
      end;
    finally
      Screen.Cursor := SaveCursor;
    end;
  end;
end;

function TShellTreeView.DeskFolder: IShellFolder;
begin
  if not Assigned(FDeskFolder) then
  begin
    SHGetDesktopFolder(FDeskFolder);
    FDeskFolder.AddRef;
  end;
  Result := FDeskFolder;
end;

end.
