// The caching is very primitive, and probably won't even help all that much in a real
// world situation.  Enhancing the caching mechanism is left as an exercise for the user.

unit VMMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtListView, StdCtrls, ExtCtrls, CommCtrl;

type
  PVirtualItem = ^TVirtualItem;
  TVirtualItem = packed record
    ImageIndex: integer;
    Title: string;
    State: UINT;
    SubText1: string;
    SubText2: string;
  end;

  TForm1 = class(TForm)
    ExtListView: TExtListView;
    Panel1: TPanel;
    ComboBox1: TComboBox;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ExtListViewODCacheHint(Sender: TObject; var HintInfo: TLVCacheHint);
    procedure ExtListViewODFindItem(Sender: TObject; var FindInfo: TLVFindItem;
                                    var Found: Boolean);
    procedure ExtListViewODGetItemInfo(Sender: TObject; Item, SubItem: Integer;
                                       Mask: TLVODMaskItems; var Image: Integer;
                                       var Param: Longint; var State, Indent: Integer;
                                       var Text: string);
  private
    CacheStart,
    CacheStop: integer;
    ItemCache: TList;
    NumItems: integer;
  public
    procedure PrepCache(FromIndex, ToIndex: integer);
    function GetVirtualItem(Item: integer): TVirtualItem;
    function CreateVirtualItem(Item: integer): PVirtualItem;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  TmpIcon: TIcon;
begin
  ItemCache := NIL;
  ComboBox1.ItemIndex := 2;
  with ExtListView do begin
    LargeImages := TImageList.Create(Self);
    with LargeImages do begin
      Width := GetSystemMetrics(SM_CXICON);
      Height := GetSystemMetrics(SM_CYICON);
      AddIcon(Application.Icon);
      TmpIcon := TIcon.Create;
      TmpIcon.Handle := LoadIcon(0, MakeIntResource(IDI_APPLICATION));
      AddIcon(TmpIcon);
    end;

    SmallImages := TImageList.Create(Self);
    with SmallImages do begin
      Width := GetSystemMetrics(SM_CXSMICON);
      Height := GetSystemMetrics(SM_CYSMICON);
      AddIcon(Application.Icon);
      AddIcon(TmpIcon);
      TmpIcon.Free;
    end;
  end;

  CacheStart := -1;
  CacheStop := -1;
  NumItems := 500;
  ExtListView.SetItemCountEx(NumItems, [lvsicfNoScroll]);
end;

procedure TForm1.FormDestroy(Sender: TObject);
var
  x: integer;
begin
  if ItemCache <> NIL then
    for x := ItemCache.Count-1 downto 0 do begin
      Dispose(ItemCache[x]);
      ItemCache.Delete(x);
    end;
  ExtListView.LargeImages.Free;
  ExtListView.SmallImages.Free;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  case ComboBox1.ItemIndex of
    0: ExtListView.ViewStyle := vsIcon;
    1: ExtListView.ViewStyle := vsList;
    2: ExtListView.ViewStyle := vsReport;
    3: ExtListView.ViewStyle := vsSmallIcon;
  end;
end;

procedure TForm1.ExtListViewODGetItemInfo(Sender: TObject; Item, SubItem: Integer;
                                          Mask: TLVODMaskItems; var Image: Integer;
                                          var Param: Longint; var State, Indent: Integer;
                                          var Text: string);
var
  AnItem: TVirtualItem;
begin
  AnItem := GetVirtualItem(Item);
  if lvifText in Mask then
    case SubItem of
      0: Text := AnItem.Title;
      1: Text := AnItem.SubText1;
      2: Text := AnItem.SubText2;
    else
      Text := '';
    end;
  if lvifImage in Mask then
    Image := AnItem.ImageIndex;
  if lvifParam in Mask then
    Param := 0;
  if lvifState in Mask then
    State := State or AnItem.State;
  if lvifIndent in Mask then
    if odd(Item) then { Just to show indenting, no real reason for it }
      Indent := 1
    else
      Indent := 0;
end;

procedure TForm1.ExtListViewODCacheHint(Sender: TObject; var HintInfo: TLVCacheHint);
begin
  with HintInfo do
    PrepCache(iFrom, iTo);
end;

procedure TForm1.ExtListViewODFindItem(Sender: TObject; var FindInfo: TLVFindItem;
                                       var Found: Boolean);
begin
  Found := FALSE;
end;

procedure TForm1.PrepCache(FromIndex, ToIndex: integer);
var
  x: integer;
begin
  if ItemCache = NIL then ItemCache := TList.Create;
  if (FromIndex < CacheStart) or (ToIndex > CacheStop) then begin
    // Free up the old cache items
    if CacheStart > -1 then
      for x := ItemCache.Count-1 downto 0 do begin
        Dispose(ItemCache[x]);
        ItemCache.Delete(x);
      end;
    // load the new cache items
    CacheStart := FromIndex;
    CacheStop := ToIndex;
    for x := CacheStart to CacheStop do
      ItemCache.Add(CreateVirtualItem(x));
  end;
end;

function TForm1.GetVirtualItem(Item: integer): TVirtualItem;
var
  TmpItem: PVirtualItem;
begin
  if (Item < CacheStart) or (Item > CacheStop) then begin
    TmpItem := CreateVirtualItem(Item);
    Result := TmpItem^;
    Dispose(TmpItem);
  end else
    Result := PVirtualItem(ItemCache[Item-CacheStart])^;
end;

function TForm1.CreateVirtualItem(Item: integer): PVirtualItem;
begin
  New(Result);
  with Result^ do begin
    if odd(Item) then
      ImageIndex := 1
    else
      ImageIndex := 0;
    State := 0;
    Title := 'VM Test Item #'+IntToStr(Item);
    SubText1 := 'Item #'+IntToStr(Item)+': Subitem 1';
    SubText2 := 'Item #'+IntToStr(Item)+': Subitem 2';
  end;
end;


end.

