//-------------------------------------------------------------//
//                                                             //
//     ExtPage.HPP                                             //
//     Header of components Extended PageControl and           //
//     Extended TabControl v2.3 for Borland C++Builder         //
//                                                             //
//     Copy this file into your C++Builder Include directory   //
//                                                             //
//-------------------------------------------------------------//
#ifndef ExtPageHPP
#define ExtPageHPP
//----------------------------------------------------------------------------
#include <CommCtrl.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <StdCtrls.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <System.hpp>
namespace Extpage
{
//-- type declarations -------------------------------------------------------
enum TExtGlyphPosition { glPosLeft, glPosTop };

class __declspec(delphiclass) TExtGlyphs;
class __declspec(pascalimplementation) TExtGlyphs : public Classes::TPersistent
{
    typedef Classes::TPersistent inherited;
    
private:
    Graphics::TBitmap* FGlyph;
    Graphics::TBitmap* FGlyphPaint;
    Controls::TControl* FGlpyhOwner;
    Controls::TImageList* FImageList;
    Word FNumGlyphs;
    Classes::TNotifyEvent FOnChange;
    Classes::TNotifyEvent FOnChangeGlyph;
    TExtGlyphPosition FPosition;
    int FSpacing;
    Graphics::TColor FTransparentColor;
    void __fastcall SetGlyph(Graphics::TBitmap* p0);
    void __fastcall SetNumGlyphs(Word p0);
    void __fastcall SetPosition(TExtGlyphPosition p0);
    void __fastcall SetSpacing(int p0);
    void __fastcall SetTransparentColor(Graphics::TColor p0);
    
protected:
    void __fastcall Changed(System::TObject* p0);
    void __fastcall ChangedGlyph(System::TObject* p0);
    
public:
    __fastcall TExtGlyphs(Controls::TControl* p0);
    __fastcall virtual ~TExtGlyphs(void);
    __property Controls::TImageList* ImageList = {read=FImageList, nodefault};
    __property Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
    __property Classes::TNotifyEvent OnChangeGlyph = {read=FOnChangeGlyph, write=FOnChangeGlyph};
    
__published:
    __property Graphics::TBitmap* Glyph = {read=FGlyph, write=SetGlyph, nodefault};
    __property Word NumGlyphs = {read=FNumGlyphs, write=SetNumGlyphs, default=0};
    __property TExtGlyphPosition Position = {read=FPosition, write=SetPosition, default=0};
    __property int Spacing = {read=FSpacing, write=SetSpacing, default=5};
    __property Graphics::TColor TransparentColor = {read=FTransparentColor, write=SetTransparentColor, 
        default=16711935};
};

class __declspec(delphiclass) TExtHottrack;
class __declspec(pascalimplementation) TExtHottrack : public Classes::TPersistent
{
    typedef Classes::TPersistent inherited;
    
private:
    bool FEnabled;
    Controls::TControl* FHottrackOwner;
    Graphics::TColor FTabActiveColor;
    Graphics::TColor FTabInactiveColor;
    void __fastcall SetEnabled(bool p0);
    void __fastcall SetTabActiveColor(Graphics::TColor p0);
    void __fastcall SetTabInactiveColor(Graphics::TColor p0);
    
public:
    int TabTracked;
    __fastcall TExtHottrack(Controls::TControl* p0);
    
__published:
    __property bool Enabled = {read=FEnabled, write=SetEnabled, default=0};
    __property Graphics::TColor TabActiveColor = {read=FTabActiveColor, write=SetTabActiveColor, default=-2147483635
        };
    __property Graphics::TColor TabInactiveColor = {read=FTabInactiveColor, write=SetTabInactiveColor, 
        default=-2147483635};
public:
    /* TObject.Destroy */ __fastcall virtual ~TExtHottrack(void) { }
    
};

class __declspec(delphiclass) EExtPageInvalidCall;
class __declspec(pascalimplementation) EExtPageInvalidCall : public Sysutils::Exception
{
    typedef Sysutils::Exception inherited;
    
public:
    /* Exception.Create */ __fastcall EExtPageInvalidCall(const System::AnsiString Msg) : Sysutils::Exception(
        Msg) { }
    /* Exception.CreateFmt */ __fastcall EExtPageInvalidCall(const System::AnsiString Msg, const System::TVarRec 
        * Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
    /* Exception.CreateRes */ __fastcall EExtPageInvalidCall(int Ident) : Sysutils::Exception(Ident) { }
        
    /* Exception.CreateResFmt */ __fastcall EExtPageInvalidCall(int Ident, const System::TVarRec * Args
        , const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
    /* Exception.CreateHelp */ __fastcall EExtPageInvalidCall(const System::AnsiString Msg, int AHelpContext
        ) : Sysutils::Exception(Msg, AHelpContext) { }
    /* Exception.CreateFmtHelp */ __fastcall EExtPageInvalidCall(const System::AnsiString Msg, const System::TVarRec 
        * Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
        ) { }
    /* Exception.CreateResHelp */ __fastcall EExtPageInvalidCall(int Ident, int AHelpContext) : Sysutils::
        Exception(Ident, AHelpContext) { }
    /* Exception.CreateResFmtHelp */ __fastcall EExtPageInvalidCall(int Ident, const System::TVarRec * 
        Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
        ) { }
    
public:
    /* TObject.Destroy */ __fastcall virtual ~EExtPageInvalidCall(void) { }
    
};

typedef void __fastcall (__closure *TExtNbDrawTabEvent)(Controls::TWinControl* Control, int Index, bool 
    ActiveTab, const Windows::TRect &RectFg, const Windows::TRect &RectBg, Stdctrls::TOwnerDrawState State
    );

typedef void __fastcall (__closure *TExtDrawBkgndInside)(Controls::TWinControl* Control, HDC DC, int 
    CurrPage, const Windows::TRect &RectBg);

typedef void __fastcall (__closure *TExtDrawBkgndOutside)(Controls::TWinControl* Control, HDC DC, HRGN 
    RgnBg);

enum TExtTabStyle { tabStDefault, tabStButton };

enum TExtTabPosition { tabPosLeft, tabPosRight, tabPosTop, tabPosBottom };

class __declspec(delphiclass) TExtPageControl;
class __declspec(pascalimplementation) TExtPageControl : public Comctrls::TPageControl
{
    typedef Comctrls::TPageControl inherited;
    
private:
    Graphics::TCanvas* FCanvas;
    TExtHottrack* FHottrack;
    System::AnsiString FHintOrg;
    bool FirstPaint;
    int FLastTabHintIndex;
    TExtDrawBkgndInside FOnDrawBkgndInside;
    TExtDrawBkgndOutside FOnDrawBkgndOutside;
    TExtNbDrawTabEvent FOnDrawTab;
    Graphics::TColor FTabActiveColor;
    Graphics::TFont* FTabActiveFont;
    TExtGlyphs* FTabGlyphs;
    Word FTabHeight;
    Classes::TStringList* FTabHints;
    Graphics::TColor FTabInactiveColor;
    Graphics::TFont* FTabInactiveFont;
    TExtTabPosition FTabPosition;
    TExtTabStyle FTabStyle;
    Word FTabWidth;
    bool FTabWordWrap;
    int StopBGPainting;
    bool StopBGPaintingTabs;
    int StopFGPainting;
    bool StopFGPaintingTabs;
    void __fastcall CheckAndSetHWndFont(void);
    Comctrls::TTabSheet* __fastcall GetActivePage(void);
    HIDESBASE void __fastcall SetActivePage(Comctrls::TTabSheet* p0);
    void __fastcall SetHottrack(TExtHottrack* p0);
    void __fastcall SetTabActiveColor(Graphics::TColor p0);
    void __fastcall SetTabActiveFont(Graphics::TFont* p0);
    void __fastcall SetTabGlyphs(TExtGlyphs* p0);
    HIDESBASE void __fastcall SetTabHeight(Word p0);
    void __fastcall SetTabHints(Classes::TStringList* p0);
    void __fastcall SetTabInactiveColor(Graphics::TColor p0);
    void __fastcall SetTabInactiveFont(Graphics::TFont* p0);
    void __fastcall SetTabPosition(TExtTabPosition p0);
    void __fastcall SetTabStyle(TExtTabStyle p0);
    HIDESBASE void __fastcall SetTabWidth(Word p0);
    void __fastcall SetTabWordWrap(bool p0);
    HIDESBASE MESSAGE void __fastcall CMDialogChar(Messages::TWMKey &p0);
    HIDESBASE MESSAGE void __fastcall CMFontChanged(Messages::TMessage &p0);
    MESSAGE void __fastcall CMHintShow(Messages::TMessage &p0);
    HIDESBASE MESSAGE void __fastcall CMMouseLeave(Messages::TMessage &p0);
    HIDESBASE MESSAGE void __fastcall CMParentColorChanged(Messages::TMessage &p0);
    MESSAGE void __fastcall CNDrawTab(Messages::TWMDrawItem &p0);
    MESSAGE void __fastcall TCMInsertItem(Messages::TMessage &p0);
    HIDESBASE MESSAGE void __fastcall WMEraseBkgnd(Messages::TWMEraseBkgnd &p0);
    HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &p0);
    HIDESBASE MESSAGE void __fastcall WMNCHitTest(Messages::TWMNCHitTest &p0);
    HIDESBASE MESSAGE void __fastcall WMPaint(Messages::TWMPaint &p0);
    
protected:
    virtual void __fastcall ChangeScale(int p0, int p1);
    virtual void __fastcall CreateParams(Controls::TCreateParams &p0);
    virtual void __fastcall CreateWnd(void);
    virtual void __fastcall FillTabBG(HDC p0, bool p1, const Windows::TRect &p2);
    virtual int __fastcall GetTabNumber(const tagPOINT &p0);
    void __fastcall GlyphHasChanged(System::TObject* p0);
    void __fastcall GlyphHasChangedPicture(System::TObject* p0);
    virtual void __fastcall Loaded(void);
    virtual void __fastcall TabFontChanged(System::TObject* p0);
    virtual tagPOINT __fastcall TabTextOut(const Windows::TRect &p0, const tagPOINT &p1,  System::AnsiString 
        p2, Classes::TAlignment p3, bool p4);
    
public:
    __fastcall virtual TExtPageControl(Classes::TComponent* p0);
    __fastcall virtual ~TExtPageControl(void);
    virtual void __fastcall BeginUpdate(void);
    virtual void __fastcall DefaultDrawTab(int p0, const Windows::TRect &p1, Stdctrls::TOwnerDrawState 
        p2);
    virtual void __fastcall DestroyAllOtherSheetHandles(void);
    virtual void __fastcall DrawTab(int p0, bool p1, const Windows::TRect &p2, const Windows::TRect 
        &p3, Stdctrls::TOwnerDrawState p4);
    virtual void __fastcall EndUpdate(void);
    int __fastcall GetPageIndexByTabIndex(int p0);
    virtual void __fastcall GetSheetRect(Windows::TRect &p0);
    virtual Windows::TRect __fastcall GetTabRect(int p0);
    virtual void __fastcall HottrackChange(int p0, int p1);
    bool __fastcall IsNewComCtl(void);
    virtual void __fastcall ReAlignTabSheets(bool p0);
    __property Graphics::TCanvas* Canvas = {read=FCanvas, nodefault};
    __property Tabs ;
    
__published:
    __property Comctrls::TTabSheet* ActivePage = {read=GetActivePage, write=SetActivePage, nodefault};
    __property Color ;
    __property TExtHottrack* Hottrack = {read=FHottrack, write=SetHottrack, nodefault};
    __property ParentColor ;
    __property Graphics::TColor TabActiveColor = {read=FTabActiveColor, write=SetTabActiveColor, nodefault
        };
    __property Graphics::TFont* TabActiveFont = {read=FTabActiveFont, write=SetTabActiveFont, nodefault
        };
    __property TExtGlyphs* TabGlyphs = {read=FTabGlyphs, write=SetTabGlyphs, nodefault};
    __property Word TabHeight = {read=FTabHeight, write=SetTabHeight, nodefault};
    __property Classes::TStringList* TabHints = {read=FTabHints, write=SetTabHints, nodefault};
    __property Graphics::TColor TabInactiveColor = {read=FTabInactiveColor, write=SetTabInactiveColor, 
        nodefault};
    __property Graphics::TFont* TabInactiveFont = {read=FTabInactiveFont, write=SetTabInactiveFont, nodefault
        };
    __property TExtTabPosition TabPosition = {read=FTabPosition, write=SetTabPosition, default=2};
    __property TExtTabStyle TabStyle = {read=FTabStyle, write=SetTabStyle, default=0};
    __property Word TabWidth = {read=FTabWidth, write=SetTabWidth, nodefault};
    __property bool TabWordWrap = {read=FTabWordWrap, write=SetTabWordWrap, default=0};
    __property TExtDrawBkgndInside OnDrawBkgndInside = {read=FOnDrawBkgndInside, write=FOnDrawBkgndInside
        };
    __property TExtDrawBkgndOutside OnDrawBkgndOutside = {read=FOnDrawBkgndOutside, write=FOnDrawBkgndOutside
        };
    __property TExtNbDrawTabEvent OnDrawTab = {read=FOnDrawTab, write=FOnDrawTab};
public:
    /* TWinControl.CreateParented */ __fastcall TExtPageControl(HWND ParentWindow) : Comctrls::TPageControl(
        ParentWindow) { }
    
};

class __declspec(delphiclass) TExtTabControl;
class __declspec(pascalimplementation) TExtTabControl : public Comctrls::TTabControl
{
    typedef Comctrls::TTabControl inherited;
    
private:
    Graphics::TCanvas* FCanvas;
    TExtHottrack* FHottrack;
    System::AnsiString FHintOrg;
    bool FirstPaint;
    int FLastTabHintIndex;
    TExtDrawBkgndInside FOnDrawBkgndInside;
    TExtDrawBkgndOutside FOnDrawBkgndOutside;
    TExtNbDrawTabEvent FOnDrawTab;
    Graphics::TColor FTabActiveColor;
    Graphics::TFont* FTabActiveFont;
    Classes::TList* FTabDisabledList;
    TExtGlyphs* FTabGlyphs;
    Word FTabHeight;
    Classes::TStringList* FTabHints;
    Graphics::TColor FTabInactiveColor;
    Graphics::TFont* FTabInactiveFont;
    TExtTabPosition FTabPosition;
    TExtTabStyle FTabStyle;
    Word FTabWidth;
    bool FTabWordWrap;
    int StopBGPainting;
    bool StopBGPaintingTabs;
    int StopFGPainting;
    bool StopFGPaintingTabs;
    void __fastcall CheckAndSetHWndFont(void);
    bool __fastcall GetTabEnabled(int p0);
    HIDESBASE int __fastcall GetTabIndex(void);
    void __fastcall SetHottrack(TExtHottrack* p0);
    void __fastcall SetTabActiveColor(Graphics::TColor p0);
    void __fastcall SetTabActiveFont(Graphics::TFont* p0);
    void __fastcall SetTabEnabled(int p0, bool p1);
    void __fastcall SetTabGlyphs(TExtGlyphs* p0);
    HIDESBASE void __fastcall SetTabHeight(Word p0);
    void __fastcall SetTabHints(Classes::TStringList* p0);
    void __fastcall SetTabInactiveColor(Graphics::TColor p0);
    void __fastcall SetTabInactiveFont(Graphics::TFont* p0);
    HIDESBASE void __fastcall SetTabIndex(int p0);
    void __fastcall SetTabPosition(TExtTabPosition p0);
    void __fastcall SetTabStyle(TExtTabStyle p0);
    HIDESBASE void __fastcall SetTabWidth(Word p0);
    void __fastcall SetTabWordWrap(bool p0);
    HIDESBASE MESSAGE void __fastcall CMDialogChar(Messages::TWMKey &p0);
    HIDESBASE MESSAGE void __fastcall CMFontChanged(Messages::TMessage &p0);
    MESSAGE void __fastcall CMHintShow(Messages::TMessage &p0);
    HIDESBASE MESSAGE void __fastcall CMMouseLeave(Messages::TMessage &p0);
    HIDESBASE MESSAGE void __fastcall CMParentColorChanged(Messages::TMessage &p0);
    MESSAGE void __fastcall CNDrawTab(Messages::TWMDrawItem &p0);
    MESSAGE void __fastcall TCMInsertItem(Messages::TMessage &p0);
    HIDESBASE MESSAGE void __fastcall WMEraseBkgnd(Messages::TWMEraseBkgnd &p0);
    HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &p0);
    HIDESBASE MESSAGE void __fastcall WMNCHitTest(Messages::TWMNCHitTest &p0);
    HIDESBASE MESSAGE void __fastcall WMPaint(Messages::TWMPaint &p0);
    
protected:
    virtual void __fastcall ChangeScale(int p0, int p1);
    virtual void __fastcall CreateParams(Controls::TCreateParams &p0);
    virtual void __fastcall CreateWnd(void);
    virtual void __fastcall FillTabBG(HDC p0, bool p1, const Windows::TRect &p2);
    virtual int __fastcall GetTabNumber(const tagPOINT &p0);
    void __fastcall GlyphHasChanged(System::TObject* p0);
    void __fastcall GlyphHasChangedPicture(System::TObject* p0);
    virtual void __fastcall Loaded(void);
    virtual void __fastcall TabFontChanged(System::TObject* p0);
    virtual tagPOINT __fastcall TabTextOut(const Windows::TRect &p0, const tagPOINT &p1,  System::AnsiString 
        p2, Classes::TAlignment p3, bool p4);
    
public:
    __fastcall virtual TExtTabControl(Classes::TComponent* p0);
    __fastcall virtual ~TExtTabControl(void);
    virtual void __fastcall BeginUpdate(void);
    virtual void __fastcall DefaultDrawTab(int p0, const Windows::TRect &p1, Stdctrls::TOwnerDrawState 
        p2);
    virtual void __fastcall DrawTab(int p0, bool p1, const Windows::TRect &p2, const Windows::TRect 
        &p3, Stdctrls::TOwnerDrawState p4);
    virtual void __fastcall EndUpdate(void);
    virtual void __fastcall GetSheetRect(Windows::TRect &p0);
    virtual Windows::TRect __fastcall GetTabRect(int p0);
    virtual void __fastcall HottrackChange(int p0, int p1);
    bool __fastcall IsNewComCtl(void);
    __property Graphics::TCanvas* Canvas = {read=FCanvas, nodefault};
    __property bool TabEnabled[int Index] = {read=GetTabEnabled, write=SetTabEnabled};
    __property Tabs ;
    
__published:
    __property Color ;
    __property TExtHottrack* Hottrack = {read=FHottrack, write=SetHottrack, nodefault};
    __property ParentColor ;
    __property Graphics::TColor TabActiveColor = {read=FTabActiveColor, write=SetTabActiveColor, nodefault
        };
    __property Graphics::TFont* TabActiveFont = {read=FTabActiveFont, write=SetTabActiveFont, nodefault
        };
    __property TExtGlyphs* TabGlyphs = {read=FTabGlyphs, write=SetTabGlyphs, nodefault};
    __property Word TabHeight = {read=FTabHeight, write=SetTabHeight, nodefault};
    __property Classes::TStringList* TabHints = {read=FTabHints, write=SetTabHints, nodefault};
    __property Graphics::TColor TabInactiveColor = {read=FTabInactiveColor, write=SetTabInactiveColor, 
        nodefault};
    __property Graphics::TFont* TabInactiveFont = {read=FTabInactiveFont, write=SetTabInactiveFont, nodefault
        };
    __property int TabIndex = {read=GetTabIndex, write=SetTabIndex, nodefault};
    __property TExtTabPosition TabPosition = {read=FTabPosition, write=SetTabPosition, default=2};
    __property TExtTabStyle TabStyle = {read=FTabStyle, write=SetTabStyle, default=0};
    __property Word TabWidth = {read=FTabWidth, write=SetTabWidth, nodefault};
    __property bool TabWordWrap = {read=FTabWordWrap, write=SetTabWordWrap, default=0};
    __property TExtDrawBkgndInside OnDrawBkgndInside = {read=FOnDrawBkgndInside, write=FOnDrawBkgndInside
        };
    __property TExtDrawBkgndOutside OnDrawBkgndOutside = {read=FOnDrawBkgndOutside, write=FOnDrawBkgndOutside
        };
    __property TExtNbDrawTabEvent OnDrawTab = {read=FOnDrawTab, write=FOnDrawTab};
public:
    /* TWinControl.CreateParented */ __fastcall TExtTabControl(HWND ParentWindow) : Comctrls::TTabControl(
        ParentWindow) { }
    
};

//-- var, const, procedure ---------------------------------------------------
#define TCS_BOTTOM (Byte)(2)
#define TCS_RIGHT (Byte)(2)
#define TCS_VERTICAL (Byte)(128)
extern void __fastcall ExtDrawBkgndImage(Controls::TWinControl* p0, int /*HDC*/ p1, const Windows::TRect &p2
    , Extctrls::TImage* p3);
extern void __fastcall ExtDrawBkgndImageRgn(Controls::TWinControl* p0, int /*HDC*/ p1, int /*HRGN*/ p2, Extctrls::TImage* 
    p3);
extern void __fastcall ExtDrawTabGraphic(Graphics::TCanvas* p0, Graphics::TGraphic* p1, const Windows::TRect 
    &p2, bool p3);
extern void __fastcall ExtStretchBlt(int /*HDC*/ p0, const Windows::TRect &p1, Graphics::TGraphic* p2, 
    int p3, int p4, int p5, int p6, int p7, int p8, int p9);
extern void __fastcall Register(void);

}   /* namespace Extpage */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Extpage;
#endif
//-- end unit ----------------------------------------------------------------
#endif  // ExtPage
