unit CopyMsg;

interface

uses
  Messages;

const

  wm_fcReset    = wm_User+0; { reset labels between disks with wait message }
  wm_fcSearching= wm_User+1; { reset labels between disks with search message }
  wm_fcName     = wm_User+2; { set labels }
  wm_fcRead     = wm_User+3; { update Gauge.Progress }
  wm_fcWrite    = wm_User+4; { update Gauge.Progress }
  wm_fcIdle     = wm_User+5; { get idle messages like abort }

function StringAsPChar(var S: OpenString): PChar;

implementation

function StringAsPChar(var S: OpenString): PChar;
{ This function null-terminates a string so that it can be passed to functions }
{ that require PChar types. If string is longer than 254 chars, then it will   }
{ be truncated to 254. }
begin
  if Length(S) = High(S) then Dec(S[0]); { Truncate S if it's too long }
  S[Length(S) + 1] := #0;                { Place null at end of string }
  Result := @S[1];                       { Return "PChar'd" string }
end;

end.
