unit Timelabl;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TTimeLabel = class(TLabel)
  private
    FCurTime: LongInt;
    FCurValue: LongInt;
    FMaxValue: LongInt;
    FStartTime: Longint;
    FElapsedTime: Longint;
  public
    constructor Create(AOwner : TComponent); override;
    procedure Reset;
    procedure Resume;
    procedure Start(AMaxValue: LongInt);
    procedure UpdateIt(Value: LongInt);
  published
    property MaxValue: LongInt read FMaxValue write FMaxValue;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TTimeLabel]);
end;

{ TTimeLabel }
constructor TTimeLabel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Reset;
end;

procedure TTimeLabel.Reset;
begin
  FCurTime := MaxLongint;
  FCurValue := 0;
  FMaxValue := 0;
  FStartTime := 0;
  FElapsedTime := 0;
end;

procedure TTimeLabel.Resume;
begin
  FStartTime:= GetTickCount;
end;

procedure TTimeLabel.Start(AMaxValue: LongInt);
begin
  FMaxValue := AMaxValue;
  FStartTime := GetTickCount;
end;

procedure TTimeLabel.UpdateIt(Value: LongInt);
var
  CurTime:LongInt;
begin
  Inc(FCurValue,Value);
  if LongBool(FStartTime) then
  begin
    FElapsedTime:=FElapsedTime+GetTickCount-FStartTime;
    Resume;
  end;
  CurTime :=
    Round(((FStartTime+Round((FMaxValue-FCurValue)/FCurValue*FElapsedTime))-FStartTime)/1000.0);
  if CurTime > FCurTime then Exit;
  if FCurTime > CurTime then
    FCurTime := CurTime;
  if FCurTime > 1 then
    Caption := Format('Estimated time left: %d seconds',[FCurTime])
  else
    if FCurTime > 0 then
      Caption := 'Estimated time left: 1 second'
    else
      Caption := '';
  Refresh;
end;

end.

