{
TFileView is a TListView component which emulates
the right hand side of explorer.  It adds all
the files in the selected directory with their
proper icons.

At runtime set the dir and mask to show all files.

Call UpOneLevel to move up one level in the dir
structure.

know Problems:
	After browsing up through directories files lose icons
	Doesn't show modified date
	Can't Drag files to / from

Please feel free to improve or modify the code.  If
you do please send updates to myself at
chris@lexology.co.uk
}
unit FileView;

interface

uses
  Windows, Dialogs, SysUtils, Classes, Controls, ComCtrls, ShellAPI;

type
  TDirChangeEvent = procedure (Sender: TObject; Dir: String) of object;

  TFileView = class(TCustomListView)
  private
    { Private declarations }
    fDirectory,
    fFileMask: String;
    fChangeDir,
    fRun: boolean;
    LargeIcons,
    SmallIcons: TImageList;
    fNumOfFile: integer;
    fOnDirChange: TDirChangeEvent;
    procedure SetDirectory(Dir: string);
    procedure SetFileMask(Mask: string);
    procedure AddFile(FileName: String; FileSize: integer);
    procedure NameChange(Sender: TObject; Item: TListItem; var S: string);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor destroy; override;
    procedure DblClick; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure UpdateFiles;
    procedure UpOneLevel;
  published
    { Published declarations }
    property OnDirChange: TDirChangeEvent read fOnDirChange write fOnDirChange;
    property Directory: string read fDirectory write SetDirectory;
		property FileMask: string read fFileMask write SetFileMask;
    property RunOnDblClick: Boolean read fRun write fRun default True;
    property ChangeDir: Boolean read fChangeDir write fChangeDir default True;
    property NumOfFiles: integer read fNumOfFile;
    property Align;
    property BorderStyle;
    property Color;
    property OnClick;
    property OnDblClick;
    property Ctl3D;
    property DragMode;
    property ReadOnly;
    property Font;
    property HideSelection;
    property IconOptions;
    property MultiSelect;
    property OnColumnClick;
    property OnEnter;
    property OnExit;
    property OnDragDrop;
    property OnDragOver;
    property DragCursor;
    property OnStartDrag;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property ParentShowHint;
    property ShowHint;
    property PopupMenu;
    property ShowColumnHeaders;
    property SortType;
    property TabOrder;
    property TabStop default True;
    property ViewStyle;
    property Visible;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
  end;

procedure Register;

implementation

procedure TFileView.NameChange(Sender: TObject; Item: TListItem; var S: string);
begin
  if not RenameFile(fDirectory + Item.Caption, fDirectory + S) then
  begin
    ShowMessage('Failed to rename file');
    S := Item.Caption;
  end;
end;

procedure TFileView.KeyDown(var Key: Word; Shift: TShiftState);
begin
  if key = VK_F5 then
    UpdateFiles;
  inherited KeyDown(Key, Shift);
end;

procedure TFileView.UpOneLevel;
var
  Source,
  Dest: String;
begin
  if length(fDirectory) = 3 then
    exit;

  Source := fDirectory;

  Source := Copy(Source, 1, length(Source) - 1);

  Dest := '';

  while pos('\', Source) > 0 do
  begin
    Dest := Copy(Source, 1, pos('\', Source));
    Source := Copy(Source, pos('\', Source) + 1, length(Source));
  end;

  SetDirectory(Dest);
end;

procedure TFileView.DblClick;
var
  FileName: string;
  FileInfo: TSHFileInfo;
begin
  if Selected = nil then
    exit;

  FileName := fDirectory + Selected.Caption;

    { if file type is a folder then change dir if allowed }
  if (SHGetFileInfo(PChar(FileName),
  								 0,
                   FileInfo,
                   sizeof(TSHFileInfo),
                   SHGFI_TYPENAME)) <> 0 then
		if (FileInfo.szTypeName = 'File Folder') and (fChangeDir) then
    begin
      SetDirectory(FileName);
      exit;
    end;

  if not fRun then
    exit;
    { if it is another type of file then run the file }
  if not ShellExecute(Application.Handle,
    									'open',
                      PChar(FileName),
                      nil,
                      nil,
                      SW_NORMAL) > 32 then
    raise(Exception.Create('File execution failed'));
  inherited DblClick;
end;

constructor TFileView.Create(AOwner: TComponent);
var
  AHandle: DWORD;
  FileInfo: TSHFileInfo;
begin
  inherited Create(AOwner);
   { create the image lists and point their handles to the windows image lists }
  LargeIcons := TImageList.CreateSize(32, 32);
  LargeIcons.ShareImages := True;
  SmallIcons := TImageList.CreateSize(16, 16);
  SmallIcons.ShareImages := True;
  LargeImages := LargeIcons;
  SmallImages := SmallIcons;

	 { get Large Icons handle from windows }
  AHandle := SHGetFileInfo('',
  												 0,
                           FileInfo,
                           sizeof(TSHFileInfo),
                           SHGFI_ICON or SHGFI_SYSICONINDEX);
  if AHandle <> 0 then
    LargeIcons.Handle := AHandle;

   { get Large Icons handle from windows }
  AHandle := SHGetFileInfo('',
  												 0,
                           FileInfo,
                           sizeof(TSHFileInfo),
                           SHGFI_SMALLICON or SHGFI_SYSICONINDEX);
  if AHandle <> 0 then
    SmallIcons.Handle := AHandle;


  OnEdited := NameChange;
end;

destructor TFileView.destroy;
begin
   { free icons before destroying the component }
  LargeIcons.Free;
  SmallIcons.Free;
  inherited destroy;
end;

procedure TFileView.SetDirectory(Dir: string);
begin
  if fDirectory = Dir then
    exit;
    { make sure Dir ends with a '\' so the mask can be added }
  if Copy(Dir, length(dir), 1) <> '\' then
    Dir := Dir + '\';
  fDirectory := Dir;
  UpdateFiles;
       { call OnDirChange event }
  if Assigned(fOnDirChange) then
    fOnDirChange(Self, Dir);
end;

procedure TFileView.SetFileMask(Mask: string);
begin
  if Mask = fFileMask then
    exit;
  fFileMask := Mask;
	UpdateFiles;
end;

procedure TFileView.UpdateFiles;
var
  SearchRec: TSearchRec;
  NewColumn: TListColumn;
begin
   { Don't show files at design time }
  if (csDesigning in ComponentState) then
    exit;

   { This section resets the view }
  fNumOfFile := 0; // reset num of file to get file count at end
  Items.Clear;  // clear all items in view
	Columns.Clear; { reset columns. I tried to create to columns when the
  								 component is created but I got access violations so I
                   do it here instead }
  NewColumn := Columns.Add;
  NewColumn.Caption := 'Name';
  NewColumn.Width := 125;      { maybe these widths could be stored in the
   															 registry depending on the application name }
  NewColumn := Columns.Add;
  NewColumn.Caption := 'Size';
  NewColumn.Width := 60;
  NewColumn.Alignment := taRightJustify;
  NewColumn := Columns.Add;
  NewColumn.Caption := 'Type';
  NewColumn.Width := 125;
{  NewColumn := Columns.Add;
  NewColumn.Caption := 'Modified';
  NewColumn.Width := 125;  }  { this section adds another column for the
  															modified date of the file.  I haven't got
                                any of getting this data yet.  Suggestions
                                please! }

   { this section uses findfirst and find next to get all the files in the
     current directory.  when it finds the file it calls AddFile }
	if FindFirst(fDirectory + fFileMask, faAnyFile, SearchRec) = 0 then
  begin
		AddFile(SearchRec.Name, SearchRec.Size);
    inc(fNumOfFile);  // inc num of file to get file count at end
    while FindNext(SearchRec) = 0 do
    begin
   		AddFile(SearchRec.Name, SearchRec.Size);
      inc(fNumOfFile);  // inc num of file to get file count at end
    end;
  end;
  FindClose(SearchRec);
end;

  { This procedure adds the file to the view with all its infomation }
procedure TFileView.AddFile(FileName: String; FileSize: integer);
var
  NewItem: TListItem;
  FileInfo: TSHFileInfo;
begin
   { ignore these to files }
  if (FileName = '.') or (FileName = '..') then
    exit;
   { create new item }
  Newitem := Items.Add;
   { set caption }
  NewItem.Caption := FileName;
   { add file size with either MB, KB of bytes at the end }
  if round(FileSize / 1048576) > 0 then
    NewItem.SubItems.Add(IntToStr(round(FileSize / 1024)) + 'MB')
  else
	  if round(FileSize / 1024) > 0 then
		  NewItem.SubItems.Add(IntToStr(round(FileSize / 1024)) + 'KB')
    else
      if FileSize > 0 then
      	NewItem.SubItems.Add(IntToStr(FileSize) + ' Bytes')
      else
        NewItem.SubItems.Add('');

   { add file type from reg otherwise add extension }
  if (SHGetFileInfo(PChar(fDirectory + FileName),
  								 0,
                   FileInfo,
                   sizeof(TSHFileInfo),
                   SHGFI_TYPENAME)) = 0 then
    NewItem.SubItems.Add(UpperCase(ExtractFileExt(FileName)) + ' File')
  else
  	NewItem.SubItems.Add(FileInfo.szTypeName);

  { in here I need to write a section to get the date when the file was
    last modified }

   { Get item index from windows }
  if SHGetFileInfo(PChar(fDirectory + FileName),
  								 0,
                   FileInfo,
                   sizeof(TSHFileInfo),
                   SHGFI_ICON or SHGFI_SYSICONINDEX) <> 0 then
  	NewItem.ImageIndex := FileInfo.IIcon
  else { if it fails set the icon to 0 }
    NewItem.ImageIndex := 0;
end;

procedure Register;
begin
  RegisterComponents('Win95', [TFileView]);
end;

end.
