unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, FileCtrl, psflfind, psfind, ExtCtrls;

type
  TForm1 = class(TForm)
    FindText1: TFindText;
    FileFind1: TFileFind;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    Label3: TLabel;
    Edit2: TEdit;
    ListBox1: TListBox;
    Label4: TLabel;
    Label5: TLabel;
    ListBox2: TListBox;
    Button1: TButton;
    CheckBox2: TCheckBox;
    Panel1: TPanel;
    Label6: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
   i : longint;
begin
     if edit2.text = '' then
     begin
       Messagedlg('Please enter the file specification',mterror,[mbok],0);
       edit2.setfocus;
       exit;
     end;
     if edit1.text = '' then
     begin
       Messagedlg('Please enter the text to search for',mterror,[mbok],0);
       edit1.setfocus;
       exit;
     end;
     filefind1.searchdrive := directorylistbox1.directory;
     filefind1.searchsubdirs := checkbox2.checked;
     filefind1.filename := edit2.text;
     panel1.caption := 'Looking for matching files...';
     screen.cursor := crhourglass;
     application.processmessages;
     filefind1.findall;

     listbox1.clear;
     for i := 0 to filefind1.filesfound - 1 do
     begin
       listbox1.items.add(filefind1.filelist[i]);
       application.processmessages;
     end;
     panel1.caption := inttostr(filefind1.filesfound)+' files found';
     findtext1.casesensitive := checkbox1.checked;
     findtext1.findstring := edit1.text;
     listbox2.clear;
     panel1.caption := 'Searching files for '+edit1.text;
     for i := 0 to listbox1.items.count - 1 do
     begin
       findtext1.filename := listbox1.items[i];
       findtext1.searchfile;
       if findtext1.filepos > 0 then
       begin
         listbox2.items.add(listbox1.items[i]+ '['+inttostr(findtext1.filepos)+']');
         application.processmessages;
       end;
     end;
     panel1.caption := edit1.text + ' found in '+inttostr(listbox2.items.count)+
        ' of '+inttostr(filefind1.filesfound)+' files.';
     screen.cursor := crdefault;
end;

end.
