unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, Grids;

type
  TMainForm = class(TForm)
    StringGrid1: TStringGrid;
    procedure FormCreate(Sender: TObject);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses FInfo;

function BoolToStr(b: boolean):string;
begin
  if b then result := 'True' else result := 'False';
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  FileInfo: TFileInfo;
  i: word;
begin
  i := 0;
  StringGrid1.ColWidths[0] := 32;
  StringGrid1.ColWidths[1] := 20;
  StringGrid1.ColWidths[2] := 216;
  StringGrid1.ColWidths[3] := 96;
  StringGrid1.ColWidths[4] := 32;
  StringGrid1.ColWidths[5] := 64;
  StringGrid1.ColWidths[6] := 64;
  StringGrid1.ColWidths[7] := 128;
  StringGrid1.ColWidths[9] := 24;

  FileInfo := TFileInfo.Create;
  FileInfo.Mask := '*.*';

  while FileInfo.Exists do
  begin
     StringGrid1.Cells[0,i] := BoolToStr(FileInfo.Exists);
     StringGrid1.Cells[1,i] := FileInfo.Drive;
     StringGrid1.Cells[2,i] := FileInfo.Path;
     StringGrid1.Cells[3,i] := FileInfo.Name;
     StringGrid1.Cells[4,i] := FileInfo.Ext;
     StringGrid1.Cells[5,i] := FileInfo.AttrStr;
     StringGrid1.Cells[6,i] := IntToStr(FileInfo.Size);
     StringGrid1.Cells[7,i] := DateToStr(FileInfo.Time);
     StringGrid1.Cells[8,i] := TimeToStr(FileInfo.Time);
     StringGrid1.Cells[9,i] := IntToStr(FileInfo.DosError);

     inc(i);
     If StringGrid1.RowCount <= i then StringGrid1.RowCount := StringGrid1.RowCount+1;

     FileInfo.Next;
  end;

  StringGrid1.Cells[0,i] := BoolToStr(FileInfo.Exists);
  StringGrid1.Cells[9,i] := IntToStr(FileInfo.DosError);

  FileInfo.Destroy;
end;

end.
